/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmColor;
import com.aspose.cad.fileformats.cgm.classes.StructuredDataRecord;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.commands.TileElement;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.fileformats.cgm.enums.CompressionType;
import com.aspose.cad.system.io.MemoryStream;

public class BitonalTile
extends TileElement {
    private CgmColor a;
    private CgmColor b;

    public final CgmColor getBackgroundcolor() {
        return this.a;
    }

    private void a(CgmColor cgmColor) {
        this.a = cgmColor;
    }

    public final CgmColor getForegroundcolor() {
        return this.b;
    }

    private void b(CgmColor cgmColor) {
        this.b = cgmColor;
    }

    public BitonalTile(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 28, cgmFile));
    }

    public BitonalTile(CgmFile cgmFile, CompressionType compressionType, int n2, CgmColor cgmColor, CgmColor cgmColor2, StructuredDataRecord structuredDataRecord, byte[] byArray) {
        this(cgmFile, compressionType, n2, cgmColor, cgmColor2, structuredDataRecord, new MemoryStream(byArray));
    }

    BitonalTile(CgmFile cgmFile, CompressionType compressionType, int n2, CgmColor cgmColor, CgmColor cgmColor2, StructuredDataRecord structuredDataRecord, MemoryStream memoryStream) {
        this(cgmFile);
        this.setDataRecord(structuredDataRecord);
        this.setCompressionType(compressionType);
        this.setRowPaddingIndicator(n2);
        this.a(cgmColor);
        this.b(cgmColor2);
        this.a(memoryStream);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setCompressionType(CompressionType.values()[iBinaryReader.readIndex()]);
        this.setRowPaddingIndicator(iBinaryReader.readInt());
        this.a(iBinaryReader.readColor());
        this.b(iBinaryReader.readColor());
        this.readSdrAndBitStream(iBinaryReader);
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeIndex(this.getCompressionType().ordinal());
        iBinaryWriter.writeInt(this.getRowPaddingIndicator());
        iBinaryWriter.writeColor(this.getBackgroundcolor());
        iBinaryWriter.writeColor(this.getForegroundcolor());
        this.writeSdrAndBitStream(iBinaryWriter);
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write(" BITONALTILE");
        iClearTextWriter.write(String.format(" %s", this.writeInt(this.getCompressionType().ordinal())));
        iClearTextWriter.write(String.format(" %s", this.writeInt(this.getRowPaddingIndicator())));
        iClearTextWriter.write(String.format(" %s", this.writeColor(this.getBackgroundcolor())));
        iClearTextWriter.write(String.format(" %s", this.writeColor(this.getForegroundcolor())));
        this.writeSDR(iClearTextWriter, this.getDataRecord());
        if (this.a() != null) {
            iClearTextWriter.write(String.format(" %s", this.writeBitStream(this.a().toArray())));
        }
        iClearTextWriter.writeLine(";");
    }

    @Override
    protected void readBitmap(IBinaryReader iBinaryReader) {
        iBinaryReader.unsupported("BITMAP for BitonalTile");
    }

    @Override
    protected void writeBitmap(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.unsupported("BITMAP for BitonalTile");
    }
}

