/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.exporters.cadapsentitiesexporter.cadaps3d;

import com.aspose.cad.exporters.cadapsentitiesexporter.cadaps3d.TransformationMatrix;
import com.aspose.cad.internal.N.aE;
import com.aspose.cad.internal.N.aa;
import com.aspose.cad.internal.N.bE;
import com.aspose.cad.internal.eT.d;
import com.aspose.cad.internal.p.P;

public class Point3D {
    public static final Point3D ZERO = new Point3D();
    private double a;
    private double b;
    private double c;
    private double d;

    public Point3D() {
        this(0.0, 0.0, 0.0, 1.0);
    }

    public Point3D(double d2, double d3, double d4, double d5) {
        this.a = d2;
        this.b = d3;
        this.c = d4;
        this.d = d5;
    }

    public Point3D(double d2, double d3) {
        this(d2, d3, 0.0, 1.0);
    }

    public Point3D(double d2, double d3, double d4) {
        this(d2, d3, d4, 1.0);
    }

    private Point3D(P p2) {
        this(p2.b(), p2.c(), p2.d(), 1.0);
    }

    public static Point3D a(P p2) {
        return new Point3D(p2);
    }

    public double getX() {
        return this.a;
    }

    public void setX(double d2) {
        this.a = d2;
    }

    public double getY() {
        return this.b;
    }

    public void setY(double d2) {
        this.b = d2;
    }

    public double getZ() {
        return this.c;
    }

    public void setZ(double d2) {
        this.c = d2;
    }

    public double getW() {
        return this.d;
    }

    public void setW(double d2) {
        this.d = d2;
    }

    public static double distance(Point3D point3D, Point3D point3D2) {
        return bE.s((point3D.getX() - point3D2.getX()) * (point3D.getX() - point3D2.getX()) + (point3D.getY() - point3D2.getY()) * (point3D.getY() - point3D2.getY()) + (point3D.getZ() - point3D2.getZ()) * (point3D.getZ() - point3D2.getZ()));
    }

    public static Point3D spherical(double d2, double d3, double d4) {
        Point3D point3D = new Point3D();
        double d5 = bE.g(d3 * Math.PI / 180.0);
        double d6 = bE.h(d3 * Math.PI / 180.0);
        double d7 = bE.g(d4 * Math.PI / 180.0);
        double d8 = bE.h(d4 * Math.PI / 180.0);
        point3D.setX(d2 * d5 * d8);
        point3D.setY(d2 * d6);
        point3D.setZ(-d2 * d5 * d7);
        point3D.setW(1.0);
        return point3D;
    }

    public static Point3D crossProduct(Point3D point3D, Point3D point3D2) {
        return new Point3D(point3D.getY() * point3D2.getZ() - point3D2.getY() * point3D.getZ(), point3D.getZ() * point3D2.getX() - point3D2.getZ() * point3D.getX(), point3D.getX() * point3D2.getY() - point3D2.getX() * point3D.getY(), 1.0);
    }

    public static double dotProduct(Point3D point3D, Point3D point3D2) {
        return point3D.getX() * point3D2.getX() + point3D.getY() * point3D2.getY() + point3D.getZ() * point3D2.getZ();
    }

    public static Point3D normalVector(Point3D point3D, Point3D point3D2, Point3D point3D3) {
        return Point3D.crossProduct(Point3D.op_Subtraction(point3D2, point3D), Point3D.op_Subtraction(point3D3, point3D)).normalize();
    }

    public void transform(TransformationMatrix transformationMatrix) {
        double[] dArray = transformationMatrix.vectorMultiply(new double[]{this.a, this.b, this.c, this.d});
        this.a = dArray[0];
        this.b = dArray[1];
        this.c = dArray[2];
        this.d = dArray[3];
    }

    public void transformNormalize(TransformationMatrix transformationMatrix) {
        this.transform(transformationMatrix);
        this.a /= this.d;
        this.b /= this.d;
        this.c /= this.d;
        this.d = 1.0;
    }

    public static boolean op_Equality(Point3D point3D, Point3D point3D2) {
        if (aE.b(point3D, null)) {
            return aE.b(point3D2, null);
        }
        return point3D.equals(point3D2);
    }

    public static boolean op_Inequality(Point3D point3D, Point3D point3D2) {
        return !Point3D.op_Equality(point3D, point3D2);
    }

    public static Point3D op_Subtraction(Point3D point3D, Point3D point3D2) {
        return new Point3D(point3D.getX() - point3D2.getX(), point3D.getY() - point3D2.getY(), point3D.getZ() - point3D2.getZ(), 1.0);
    }

    public static Point3D op_Addition(Point3D point3D, Point3D point3D2) {
        return new Point3D(point3D.getX() + point3D2.getX(), point3D.getY() + point3D2.getY(), point3D.getZ() + point3D2.getZ(), 1.0);
    }

    public static Point3D op_Multiply(Point3D point3D, double d2) {
        return new Point3D(point3D.getX() * d2, point3D.getY() * d2, point3D.getZ() * d2, point3D.getW());
    }

    public boolean equals(Object object) {
        Point3D point3D = (Point3D)((Object)com.aspose.cad.internal.eT.d.a(object, Point3D.class));
        if (point3D == null) {
            return false;
        }
        return this.equalsSoft(object, 1.0E-7);
    }

    public final boolean equalsSoft(Object object) {
        return this.equalsSoft(object, 1.0E-4);
    }

    public final boolean equalsSoft(Object object, double d2) {
        Point3D point3D = (Point3D)((Object)com.aspose.cad.internal.eT.d.a(object, Point3D.class));
        return bE.a(this.a - point3D.a) < d2 && bE.a(this.b - point3D.b) < d2 && bE.a(this.c - point3D.c) < d2 && bE.a(this.d - point3D.d) < d2;
    }

    public int hashCode() {
        return aa.a(this.getX()) ^ aa.a(this.getY()) ^ aa.a(this.getZ());
    }

    public Point3D copy() {
        return new Point3D(this.getX(), this.getY(), this.getZ(), 1.0);
    }

    public final Point3D normalize() {
        double d2 = Point3D.distance(this, new Point3D(0.0, 0.0, 0.0, 1.0));
        return new Point3D(this.getX() / d2, this.getY() / d2, this.getZ() / d2, 1.0);
    }
}

