/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSSignature;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.c;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.k;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.s;
import com.aspose.cad.internal.bouncycastle.util.Arrays;

public class XMSSSigner
implements StateAwareMessageSigner {
    private XMSSPrivateKeyParameters a;
    private XMSSPrivateKeyParameters b;
    private XMSSPublicKeyParameters c;
    private XMSSParameters d;
    private c e;
    private boolean f;
    private boolean g;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            this.f = true;
            this.g = false;
            this.b = this.a = (XMSSPrivateKeyParameters)cipherParameters;
            this.d = this.a.getParameters();
            this.e = this.d.getWOTSPlus().b();
        } else {
            this.f = false;
            this.c = (XMSSPublicKeyParameters)cipherParameters;
            this.d = this.c.getParameters();
            this.e = this.d.getWOTSPlus().b();
        }
    }

    @Override
    public byte[] generateSignature(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        if (this.f) {
            if (this.a == null) {
                throw new IllegalStateException("signing key no longer usable");
            }
        } else {
            throw new IllegalStateException("signer not initialized for signature generation");
        }
        if (this.a.getBDSState().getAuthenticationPath().isEmpty()) {
            throw new IllegalStateException("not initialized");
        }
        int n2 = this.a.getIndex();
        if (!XMSSUtil.isIndexValid(this.d.getHeight(), n2)) {
            throw new IllegalStateException("index out of bounds");
        }
        byte[] byArray2 = this.e.d(this.a.getSecretKeyPRF(), XMSSUtil.toBytesBigEndian(n2, 32));
        byte[] byArray3 = Arrays.concatenate(byArray2, this.a.getRoot(), XMSSUtil.toBytesBigEndian(n2, this.d.getDigestSize()));
        byte[] byArray4 = this.e.c(byArray3, byArray);
        OTSHashAddress oTSHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(n2).build();
        k k2 = this.a(byArray4, oTSHashAddress);
        XMSSSignature xMSSSignature = (XMSSSignature)new XMSSSignature.Builder(this.d).withIndex(n2).withRandom(byArray2).withWOTSPlusSignature(k2).withAuthPath(this.a.getBDSState().getAuthenticationPath()).build();
        this.g = true;
        if (this.b != null) {
            this.b = this.a = this.b.getNextKey();
        } else {
            this.a = null;
        }
        return xMSSSignature.toByteArray();
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        XMSSSignature xMSSSignature = new XMSSSignature.Builder(this.d).withSignature(byArray2).build();
        int n2 = xMSSSignature.getIndex();
        this.d.getWOTSPlus().a(new byte[this.d.getDigestSize()], this.c.getPublicSeed());
        byte[] byArray3 = Arrays.concatenate(xMSSSignature.getRandom(), this.c.getRoot(), XMSSUtil.toBytesBigEndian(n2, this.d.getDigestSize()));
        byte[] byArray4 = this.e.c(byArray3, byArray);
        int n3 = this.d.getHeight();
        int n4 = XMSSUtil.getLeafIndex(n2, n3);
        OTSHashAddress oTSHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(n2).build();
        XMSSNode xMSSNode = s.a(this.d.getWOTSPlus(), n3, byArray4, xMSSSignature, oTSHashAddress, n4);
        return Arrays.constantTimeAreEqual(xMSSNode.getValue(), this.c.getRoot());
    }

    @Override
    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        if (this.g) {
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this.a;
            this.a = null;
            this.b = null;
            return xMSSPrivateKeyParameters;
        }
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this.b.getNextKey();
        this.b = null;
        return xMSSPrivateKeyParameters;
    }

    private k a(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray.length != this.d.getDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        this.d.getWOTSPlus().a(this.d.getWOTSPlus().b(this.a.getSecretKeySeed(), oTSHashAddress), this.a.getPublicSeed());
        return this.d.getWOTSPlus().a(byArray, oTSHashAddress);
    }
}

