/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.params;

import com.aspose.cad.internal.bouncycastle.crypto.DerivationParameters;
import com.aspose.cad.internal.bouncycastle.util.Arrays;

public final class KDFFeedbackParameters
implements DerivationParameters {
    private static final int a = -1;
    private final byte[] b;
    private final byte[] c;
    private final boolean d;
    private final int e;
    private final byte[] f;

    private KDFFeedbackParameters(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, boolean bl2) {
        if (byArray == null) {
            throw new IllegalArgumentException("A KDF requires Ki (a seed) as input");
        }
        this.b = Arrays.clone(byArray);
        this.f = byArray3 == null ? new byte[0] : Arrays.clone(byArray3);
        this.e = n2;
        this.c = byArray2 == null ? new byte[0] : Arrays.clone(byArray2);
        this.d = bl2;
    }

    public static KDFFeedbackParameters createWithCounter(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        if (n2 != 8 && n2 != 16 && n2 != 24 && n2 != 32) {
            throw new IllegalArgumentException("Length of counter should be 8, 16, 24 or 32");
        }
        return new KDFFeedbackParameters(byArray, byArray2, byArray3, n2, true);
    }

    public static KDFFeedbackParameters createWithoutCounter(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new KDFFeedbackParameters(byArray, byArray2, byArray3, -1, false);
    }

    public byte[] getKI() {
        return this.b;
    }

    public byte[] getIV() {
        return this.c;
    }

    public boolean useCounter() {
        return this.d;
    }

    public int getR() {
        return this.e;
    }

    public byte[] getFixedInputData() {
        return Arrays.clone(this.f);
    }
}

