/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.generators;

import com.aspose.cad.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.KeyGenerationParameters;

public class Poly1305KeyGenerator
extends CipherKeyGenerator {
    private static final byte a = -4;
    private static final byte b = 15;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        super.init(new KeyGenerationParameters(keyGenerationParameters.getRandom(), 256));
    }

    @Override
    public byte[] generateKey() {
        byte[] byArray = super.generateKey();
        Poly1305KeyGenerator.clamp(byArray);
        return byArray;
    }

    public static void clamp(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
        }
        byArray[3] = (byte)(byArray[3] & 0xF);
        byArray[7] = (byte)(byArray[7] & 0xF);
        byArray[11] = (byte)(byArray[11] & 0xF);
        byArray[15] = (byte)(byArray[15] & 0xF);
        byArray[4] = (byte)(byArray[4] & 0xFFFFFFFC);
        byArray[8] = (byte)(byArray[8] & 0xFFFFFFFC);
        byArray[12] = (byte)(byArray[12] & 0xFFFFFFFC);
    }

    public static void checkKey(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
        }
        Poly1305KeyGenerator.a(byArray[3], (byte)15);
        Poly1305KeyGenerator.a(byArray[7], (byte)15);
        Poly1305KeyGenerator.a(byArray[11], (byte)15);
        Poly1305KeyGenerator.a(byArray[15], (byte)15);
        Poly1305KeyGenerator.a(byArray[4], (byte)-4);
        Poly1305KeyGenerator.a(byArray[8], (byte)-4);
        Poly1305KeyGenerator.a(byArray[12], (byte)-4);
    }

    private static void a(byte by2, byte by3) {
        if ((by2 & ~by3) != 0) {
            throw new IllegalArgumentException("Invalid format for r portion of Poly1305 key.");
        }
    }
}

