/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert.dane;

import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.cert.dane.DANEEntry;
import com.aspose.cad.internal.bouncycastle.cert.dane.DANEEntryFetcherFactory;
import com.aspose.cad.internal.bouncycastle.cert.dane.DANEEntrySelector;
import com.aspose.cad.internal.bouncycastle.cert.dane.DANEEntrySelectorFactory;
import com.aspose.cad.internal.bouncycastle.cert.dane.DANEException;
import com.aspose.cad.internal.bouncycastle.operator.DigestCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DANECertificateFetcher {
    private final DANEEntryFetcherFactory a;
    private final DANEEntrySelectorFactory b;

    public DANECertificateFetcher(DANEEntryFetcherFactory dANEEntryFetcherFactory, DigestCalculator digestCalculator) {
        this.a = dANEEntryFetcherFactory;
        this.b = new DANEEntrySelectorFactory(digestCalculator);
    }

    public List fetch(String string) throws DANEException {
        DANEEntrySelector dANEEntrySelector = this.b.createSelector(string);
        List list = this.a.build(dANEEntrySelector.getDomainName()).getEntries();
        ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>(list.size());
        for (DANEEntry dANEEntry : list) {
            if (!dANEEntrySelector.match(dANEEntry)) continue;
            arrayList.add(dANEEntry.getCertificate());
        }
        return Collections.unmodifiableList(arrayList);
    }
}

