/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.crmf;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Boolean;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Choice;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.crmf.EncryptedKey;

public class PKIArchiveOptions
extends ASN1Object
implements ASN1Choice {
    public static final int encryptedPrivKey = 0;
    public static final int keyGenParameters = 1;
    public static final int archiveRemGenPrivKey = 2;
    private ASN1Encodable a;

    public static PKIArchiveOptions getInstance(Object object) {
        if (object == null || object instanceof PKIArchiveOptions) {
            return (PKIArchiveOptions)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return new PKIArchiveOptions((ASN1TaggedObject)object);
        }
        throw new IllegalArgumentException("unknown object: " + object);
    }

    private PKIArchiveOptions(ASN1TaggedObject aSN1TaggedObject) {
        switch (aSN1TaggedObject.getTagNo()) {
            case 0: {
                this.a = EncryptedKey.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 1: {
                this.a = ASN1OctetString.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 2: {
                this.a = ASN1Boolean.getInstance(aSN1TaggedObject, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag number: " + aSN1TaggedObject.getTagNo());
            }
        }
    }

    public PKIArchiveOptions(EncryptedKey encryptedKey) {
        this.a = encryptedKey;
    }

    public PKIArchiveOptions(ASN1OctetString aSN1OctetString) {
        this.a = aSN1OctetString;
    }

    public PKIArchiveOptions(boolean bl2) {
        this.a = ASN1Boolean.getInstance(bl2);
    }

    public int getType() {
        if (this.a instanceof EncryptedKey) {
            return 0;
        }
        if (this.a instanceof ASN1OctetString) {
            return 1;
        }
        return 2;
    }

    public ASN1Encodable getValue() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a instanceof EncryptedKey) {
            return new DERTaggedObject(true, 0, this.a);
        }
        if (this.a instanceof ASN1OctetString) {
            return new DERTaggedObject(false, 1, this.a);
        }
        return new DERTaggedObject(false, 2, this.a);
    }
}

