/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.pqc.crypto.rainbow;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.MessageSigner;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.rainbow.Layer;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.rainbow.RainbowKeyParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.rainbow.util.ComputeInField;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.rainbow.util.GF2Field;
import java.security.SecureRandom;

public class RainbowSigner
implements MessageSigner {
    private static final int a = 65536;
    private SecureRandom b;
    int signableDocumentLength;
    private short[] c;
    private ComputeInField d = new ComputeInField();
    RainbowKeyParameters key;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.b = parametersWithRandom.getRandom();
                this.key = (RainbowPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.b = new SecureRandom();
                this.key = (RainbowPrivateKeyParameters)cipherParameters;
            }
        } else {
            this.key = (RainbowPublicKeyParameters)cipherParameters;
        }
        this.signableDocumentLength = this.key.getDocLength();
    }

    private short[] a(Layer[] layerArray, short[] sArray) {
        short[] sArray2 = new short[sArray.length];
        sArray2 = this.d.addVect(((RainbowPrivateKeyParameters)this.key).getB1(), sArray);
        short[] sArray3 = this.d.multiplyMatrix(((RainbowPrivateKeyParameters)this.key).getInvA1(), sArray2);
        for (int i2 = 0; i2 < layerArray[0].getVi(); ++i2) {
            this.c[i2] = (short)this.b.nextInt();
            this.c[i2] = (short)(this.c[i2] & 0xFF);
        }
        return sArray3;
    }

    @Override
    public byte[] generateSignature(byte[] byArray) {
        boolean bl2;
        Layer[] layerArray = ((RainbowPrivateKeyParameters)this.key).getLayers();
        int n2 = layerArray.length;
        this.c = new short[((RainbowPrivateKeyParameters)this.key).getInvA2().length];
        byte[] byArray2 = new byte[layerArray[n2 - 1].getViNext()];
        short[] sArray = this.a(byArray);
        int n3 = 0;
        do {
            bl2 = true;
            int n4 = 0;
            try {
                int n5;
                short[] sArray2 = this.a(layerArray, sArray);
                for (n5 = 0; n5 < n2; ++n5) {
                    int n6;
                    short[] sArray3 = new short[layerArray[n5].getOi()];
                    short[] sArray4 = new short[layerArray[n5].getOi()];
                    for (n6 = 0; n6 < layerArray[n5].getOi(); ++n6) {
                        sArray3[n6] = sArray2[n4];
                        ++n4;
                    }
                    sArray4 = this.d.solveEquation(layerArray[n5].plugInVinegars(this.c), sArray3);
                    if (sArray4 == null) {
                        throw new Exception("LES is not solveable!");
                    }
                    for (n6 = 0; n6 < sArray4.length; ++n6) {
                        this.c[layerArray[n5].getVi() + n6] = sArray4[n6];
                    }
                }
                short[] sArray5 = this.d.addVect(((RainbowPrivateKeyParameters)this.key).getB2(), this.c);
                short[] sArray6 = this.d.multiplyMatrix(((RainbowPrivateKeyParameters)this.key).getInvA2(), sArray5);
                for (n5 = 0; n5 < byArray2.length; ++n5) {
                    byArray2[n5] = (byte)sArray6[n5];
                }
            }
            catch (Exception exception) {
                bl2 = false;
            }
        } while (!bl2 && ++n3 < 65536);
        if (n3 == 65536) {
            throw new IllegalStateException("unable to generate signature - LES not solvable");
        }
        return byArray2;
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        short[] sArray = new short[byArray2.length];
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            short s2 = byArray2[i2];
            sArray[i2] = s2 = (short)(s2 & 0xFF);
        }
        short[] sArray2 = this.a(byArray);
        short[] sArray3 = this.a(sArray);
        boolean bl2 = true;
        if (sArray2.length != sArray3.length) {
            return false;
        }
        for (int i3 = 0; i3 < sArray2.length; ++i3) {
            bl2 = bl2 && sArray2[i3] == sArray3[i3];
        }
        return bl2;
    }

    private short[] a(short[] sArray) {
        short[][] sArray2 = ((RainbowPublicKeyParameters)this.key).getCoeffQuadratic();
        short[][] sArray3 = ((RainbowPublicKeyParameters)this.key).getCoeffSingular();
        short[] sArray4 = ((RainbowPublicKeyParameters)this.key).getCoeffScalar();
        short[] sArray5 = new short[sArray2.length];
        int n2 = sArray3[0].length;
        int n3 = 0;
        short s2 = 0;
        for (int i2 = 0; i2 < sArray2.length; ++i2) {
            n3 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                for (int i4 = i3; i4 < n2; ++i4) {
                    s2 = GF2Field.multElem(sArray2[i2][n3], GF2Field.multElem(sArray[i3], sArray[i4]));
                    sArray5[i2] = GF2Field.addElem(sArray5[i2], s2);
                    ++n3;
                }
                s2 = GF2Field.multElem(sArray3[i2][i3], sArray[i3]);
                sArray5[i2] = GF2Field.addElem(sArray5[i2], s2);
            }
            sArray5[i2] = GF2Field.addElem(sArray5[i2], sArray4[i2]);
        }
        return sArray5;
    }

    private short[] a(byte[] byArray) {
        short[] sArray = new short[this.signableDocumentLength];
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            sArray[n3] = byArray[n2];
            int n4 = n3++;
            sArray[n4] = (short)(sArray[n4] & 0xFF);
            ++n2;
            if (n3 < sArray.length) continue;
        }
        return sArray;
    }
}

