/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.signers;

import com.aspose.cad.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.CryptoException;
import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.crypto.Signer;
import com.aspose.cad.internal.bouncycastle.crypto.params.RSAKeyParameters;
import com.aspose.cad.internal.bouncycastle.crypto.signers.ISOTrailers;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class X931Signer
implements Signer {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    public static final int TRAILER_SHA256 = 13516;
    public static final int TRAILER_SHA512 = 13772;
    public static final int TRAILER_SHA384 = 14028;
    public static final int TRAILER_WHIRLPOOL = 14284;
    public static final int TRAILER_SHA224 = 14540;
    private Digest a;
    private AsymmetricBlockCipher b;
    private RSAKeyParameters c;
    private int d;
    private int e;
    private byte[] f;

    public X931Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, boolean bl2) {
        this.b = asymmetricBlockCipher;
        this.a = digest;
        if (bl2) {
            this.d = 188;
        } else {
            Integer n2 = ISOTrailers.getTrailer(digest);
            if (n2 != null) {
                this.d = n2;
            } else {
                throw new IllegalArgumentException("no valid trailer for digest: " + digest.getAlgorithmName());
            }
        }
    }

    public X931Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, false);
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.c = (RSAKeyParameters)cipherParameters;
        this.b.init(bl2, this.c);
        this.e = this.c.getModulus().bitLength();
        this.f = new byte[(this.e + 7) / 8];
        this.reset();
    }

    private void a(byte[] byArray) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }

    @Override
    public void update(byte by2) {
        this.a.update(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.a.update(byArray, n2, n3);
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    @Override
    public byte[] generateSignature() throws CryptoException {
        this.a(this.d);
        BigInteger bigInteger = new BigInteger(1, this.b.processBlock(this.f, 0, this.f.length));
        this.a(this.f);
        bigInteger = bigInteger.min(this.c.getModulus().subtract(bigInteger));
        return BigIntegers.asUnsignedByteArray((this.c.getModulus().bitLength() + 7) / 8, bigInteger);
    }

    private void a(int n2) {
        int n3;
        int n4 = this.a.getDigestSize();
        if (n2 == 188) {
            n3 = this.f.length - n4 - 1;
            this.a.doFinal(this.f, n3);
            this.f[this.f.length - 1] = -68;
        } else {
            n3 = this.f.length - n4 - 2;
            this.a.doFinal(this.f, n3);
            this.f[this.f.length - 2] = (byte)(n2 >>> 8);
            this.f[this.f.length - 1] = (byte)n2;
        }
        this.f[0] = 107;
        for (int i2 = n3 - 2; i2 != 0; --i2) {
            this.f[i2] = -69;
        }
        this.f[n3 - 1] = -70;
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        BigInteger bigInteger;
        try {
            this.f = this.b.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            return false;
        }
        BigInteger bigInteger2 = new BigInteger(1, this.f);
        if ((bigInteger2.intValue() & 0xF) == 12) {
            bigInteger = bigInteger2;
        } else {
            bigInteger2 = this.c.getModulus().subtract(bigInteger2);
            if ((bigInteger2.intValue() & 0xF) == 12) {
                bigInteger = bigInteger2;
            } else {
                return false;
            }
        }
        this.a(this.d);
        byte[] byArray2 = BigIntegers.asUnsignedByteArray(this.f.length, bigInteger);
        boolean bl2 = Arrays.constantTimeAreEqual(this.f, byArray2);
        if (this.d == 15052 && !bl2) {
            this.f[this.f.length - 2] = 64;
            bl2 = Arrays.constantTimeAreEqual(this.f, byArray2);
        }
        this.a(this.f);
        this.a(byArray2);
        return bl2;
    }
}

