/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.engines;

import com.aspose.cad.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.TweakableBlockCipherParameters;

public class ThreefishEngine
implements BlockCipher {
    public static final int BLOCKSIZE_256 = 256;
    public static final int BLOCKSIZE_512 = 512;
    public static final int BLOCKSIZE_1024 = 1024;
    private static final int a = 16;
    private static final int b = 2;
    private static final int c = 72;
    private static final int d = 72;
    private static final int e = 80;
    private static final int f = 80;
    private static final long g = 2004413935125273122L;
    private static int[] h = new int[80];
    private static int[] i = new int[h.length];
    private static int[] j = new int[h.length];
    private static int[] k = new int[h.length];
    private int l;
    private int m;
    private long[] n;
    private long[] o = new long[5];
    private long[] p;
    private d q;
    private boolean r;

    public ThreefishEngine(int n2) {
        this.l = n2 / 8;
        this.m = this.l / 8;
        this.n = new long[this.m];
        this.p = new long[2 * this.m + 1];
        switch (n2) {
            case 256: {
                this.q = new b(this.p, this.o);
                break;
            }
            case 512: {
                this.q = new c(this.p, this.o);
                break;
            }
            case 1024: {
                this.q = new a(this.p, this.o);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid blocksize - Threefish is defined with block size of 256, 512, or 1024 bits");
            }
        }
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        if (cipherParameters instanceof TweakableBlockCipherParameters) {
            object = (TweakableBlockCipherParameters)cipherParameters;
            byArray2 = ((TweakableBlockCipherParameters)object).getKey().getKey();
            byArray = ((TweakableBlockCipherParameters)object).getTweak();
        } else if (cipherParameters instanceof KeyParameter) {
            byArray2 = ((KeyParameter)cipherParameters).getKey();
            byArray = null;
        } else {
            throw new IllegalArgumentException("Invalid parameter passed to Threefish init - " + cipherParameters.getClass().getName());
        }
        object = null;
        long[] lArray = null;
        if (byArray2 != null) {
            if (byArray2.length != this.l) {
                throw new IllegalArgumentException("Threefish key must be same size as block (" + this.l + " bytes)");
            }
            object = new long[this.m];
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                object[i2] = ThreefishEngine.bytesToWord(byArray2, i2 * 8);
            }
        }
        if (byArray != null) {
            if (byArray.length != 16) {
                throw new IllegalArgumentException("Threefish tweak must be 16 bytes");
            }
            lArray = new long[]{ThreefishEngine.bytesToWord(byArray, 0), ThreefishEngine.bytesToWord(byArray, 8)};
        }
        this.init(bl2, (long[])object, lArray);
    }

    public void init(boolean bl2, long[] lArray, long[] lArray2) {
        this.r = bl2;
        if (lArray != null) {
            this.a(lArray);
        }
        if (lArray2 != null) {
            this.b(lArray2);
        }
    }

    private void a(long[] lArray) {
        if (lArray.length != this.m) {
            throw new IllegalArgumentException("Threefish key must be same size as block (" + this.m + " words)");
        }
        long l2 = 2004413935125273122L;
        for (int i2 = 0; i2 < this.m; ++i2) {
            this.p[i2] = lArray[i2];
            l2 ^= this.p[i2];
        }
        this.p[this.m] = l2;
        System.arraycopy(this.p, 0, this.p, this.m + 1, this.m);
    }

    private void b(long[] lArray) {
        if (lArray.length != 2) {
            throw new IllegalArgumentException("Tweak must be 2 words.");
        }
        this.o[0] = lArray[0];
        this.o[1] = lArray[1];
        this.o[2] = this.o[0] ^ this.o[1];
        this.o[3] = this.o[0];
        this.o[4] = this.o[1];
    }

    @Override
    public String getAlgorithmName() {
        return "Threefish-" + this.l * 8;
    }

    @Override
    public int getBlockSize() {
        return this.l;
    }

    @Override
    public void reset() {
    }

    @Override
    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        int n4;
        if (n2 + this.l > byArray.length) {
            throw new DataLengthException("Input buffer too short");
        }
        if (n3 + this.l > byArray2.length) {
            throw new OutputLengthException("Output buffer too short");
        }
        for (n4 = 0; n4 < this.l; n4 += 8) {
            this.n[n4 >> 3] = ThreefishEngine.bytesToWord(byArray, n2 + n4);
        }
        this.processBlock(this.n, this.n);
        for (n4 = 0; n4 < this.l; n4 += 8) {
            ThreefishEngine.wordToBytes(this.n[n4 >> 3], byArray2, n3 + n4);
        }
        return this.l;
    }

    public int processBlock(long[] lArray, long[] lArray2) throws DataLengthException, IllegalStateException {
        if (this.p[this.m] == 0L) {
            throw new IllegalStateException("Threefish engine not initialised");
        }
        if (lArray.length != this.m) {
            throw new DataLengthException("Input buffer too short");
        }
        if (lArray2.length != this.m) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (this.r) {
            this.q.a(lArray, lArray2);
        } else {
            this.q.b(lArray, lArray2);
        }
        return this.m;
    }

    public static long bytesToWord(byte[] byArray, int n2) {
        if (n2 + 8 > byArray.length) {
            throw new IllegalArgumentException();
        }
        long l2 = 0L;
        int n3 = n2;
        l2 = (long)byArray[n3++] & 0xFFL;
        l2 |= ((long)byArray[n3++] & 0xFFL) << 8;
        l2 |= ((long)byArray[n3++] & 0xFFL) << 16;
        l2 |= ((long)byArray[n3++] & 0xFFL) << 24;
        l2 |= ((long)byArray[n3++] & 0xFFL) << 32;
        l2 |= ((long)byArray[n3++] & 0xFFL) << 40;
        l2 |= ((long)byArray[n3++] & 0xFFL) << 48;
        return l2 |= ((long)byArray[n3++] & 0xFFL) << 56;
    }

    public static void wordToBytes(long l2, byte[] byArray, int n2) {
        if (n2 + 8 > byArray.length) {
            throw new IllegalArgumentException();
        }
        int n3 = n2;
        byArray[n3++] = (byte)l2;
        byArray[n3++] = (byte)(l2 >> 8);
        byArray[n3++] = (byte)(l2 >> 16);
        byArray[n3++] = (byte)(l2 >> 24);
        byArray[n3++] = (byte)(l2 >> 32);
        byArray[n3++] = (byte)(l2 >> 40);
        byArray[n3++] = (byte)(l2 >> 48);
        byArray[n3++] = (byte)(l2 >> 56);
    }

    static long rotlXor(long l2, int n2, long l3) {
        return (l2 << n2 | l2 >>> -n2) ^ l3;
    }

    static long xorRotr(long l2, int n2, long l3) {
        long l4 = l2 ^ l3;
        return l4 >>> n2 | l4 << -n2;
    }

    static {
        for (int i2 = 0; i2 < h.length; ++i2) {
            ThreefishEngine.i[i2] = i2 % 17;
            ThreefishEngine.h[i2] = i2 % 9;
            ThreefishEngine.j[i2] = i2 % 5;
            ThreefishEngine.k[i2] = i2 % 3;
        }
    }

    private static final class a
    extends d {
        private static final int c = 24;
        private static final int d = 13;
        private static final int e = 8;
        private static final int f = 47;
        private static final int g = 8;
        private static final int h = 17;
        private static final int i = 22;
        private static final int j = 37;
        private static final int k = 38;
        private static final int l = 19;
        private static final int m = 10;
        private static final int n = 55;
        private static final int o = 49;
        private static final int p = 18;
        private static final int q = 23;
        private static final int r = 52;
        private static final int s = 33;
        private static final int t = 4;
        private static final int u = 51;
        private static final int v = 13;
        private static final int w = 34;
        private static final int x = 41;
        private static final int y = 59;
        private static final int z = 17;
        private static final int A = 5;
        private static final int B = 20;
        private static final int C = 48;
        private static final int D = 41;
        private static final int E = 47;
        private static final int F = 28;
        private static final int G = 16;
        private static final int H = 25;
        private static final int I = 41;
        private static final int J = 9;
        private static final int K = 37;
        private static final int L = 31;
        private static final int M = 12;
        private static final int N = 47;
        private static final int O = 44;
        private static final int P = 30;
        private static final int Q = 16;
        private static final int R = 34;
        private static final int S = 56;
        private static final int T = 51;
        private static final int U = 4;
        private static final int V = 53;
        private static final int W = 42;
        private static final int X = 41;
        private static final int Y = 31;
        private static final int Z = 44;
        private static final int aa = 47;
        private static final int ab = 46;
        private static final int ac = 19;
        private static final int ad = 42;
        private static final int ae = 44;
        private static final int af = 25;
        private static final int ag = 9;
        private static final int ah = 48;
        private static final int ai = 35;
        private static final int aj = 52;
        private static final int ak = 23;
        private static final int al = 31;
        private static final int am = 37;
        private static final int an = 20;

        public a(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        @Override
        void a(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.b;
            long[] lArray4 = this.a;
            int[] nArray = i;
            int[] nArray2 = k;
            if (lArray3.length != 33) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l2 = lArray[0];
            long l3 = lArray[1];
            long l4 = lArray[2];
            long l5 = lArray[3];
            long l6 = lArray[4];
            long l7 = lArray[5];
            long l8 = lArray[6];
            long l9 = lArray[7];
            long l10 = lArray[8];
            long l11 = lArray[9];
            long l12 = lArray[10];
            long l13 = lArray[11];
            long l14 = lArray[12];
            long l15 = lArray[13];
            long l16 = lArray[14];
            long l17 = lArray[15];
            l2 += lArray3[0];
            l3 += lArray3[1];
            l4 += lArray3[2];
            l5 += lArray3[3];
            l6 += lArray3[4];
            l7 += lArray3[5];
            l8 += lArray3[6];
            l9 += lArray3[7];
            l10 += lArray3[8];
            l11 += lArray3[9];
            l12 += lArray3[10];
            l13 += lArray3[11];
            l14 += lArray3[12];
            l15 += lArray3[13] + lArray4[0];
            l16 += lArray3[14] + lArray4[1];
            l17 += lArray3[15];
            for (int i2 = 1; i2 < 20; i2 += 2) {
                int n2 = nArray[i2];
                int n3 = nArray2[i2];
                l2 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 24, l2);
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 13, l4);
                l6 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 8, l6);
                l8 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 47, l8);
                l10 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 8, l10);
                l12 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 17, l12);
                l14 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 22, l14);
                l16 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 37, l16);
                l2 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 38, l2);
                l4 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 19, l4);
                l8 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 10, l8);
                l6 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 55, l6);
                l12 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 49, l12);
                l14 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 18, l14);
                l16 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 23, l16);
                l10 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 52, l10);
                l2 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 33, l2);
                l4 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 4, l4);
                l6 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 51, l6);
                l8 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 13, l8);
                l14 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 34, l14);
                l16 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 41, l16);
                l10 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 59, l10);
                l12 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 17, l12);
                l2 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 5, l2);
                l4 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 20, l4);
                l8 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 48, l8);
                l6 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 41, l6);
                l16 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 47, l16);
                l10 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 28, l10);
                l12 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 16, l12);
                l14 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 25, l14);
                l2 += lArray3[n2];
                l3 += lArray3[n2 + 1];
                l4 += lArray3[n2 + 2];
                l5 += lArray3[n2 + 3];
                l6 += lArray3[n2 + 4];
                l7 += lArray3[n2 + 5];
                l8 += lArray3[n2 + 6];
                l9 += lArray3[n2 + 7];
                l10 += lArray3[n2 + 8];
                l11 += lArray3[n2 + 9];
                l12 += lArray3[n2 + 10];
                l13 += lArray3[n2 + 11];
                l14 += lArray3[n2 + 12];
                l15 += lArray3[n2 + 13] + lArray4[n3];
                l16 += lArray3[n2 + 14] + lArray4[n3 + 1];
                l17 += lArray3[n2 + 15] + (long)i2;
                l2 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 41, l2);
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 9, l4);
                l6 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 37, l6);
                l8 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 31, l8);
                l10 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 12, l10);
                l12 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 47, l12);
                l14 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 44, l14);
                l16 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 30, l16);
                l2 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 16, l2);
                l4 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 34, l4);
                l8 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 56, l8);
                l6 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 51, l6);
                l12 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 4, l12);
                l14 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 53, l14);
                l16 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 42, l16);
                l10 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 41, l10);
                l2 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 31, l2);
                l4 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 44, l4);
                l6 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 47, l6);
                l8 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 46, l8);
                l14 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 19, l14);
                l16 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 42, l16);
                l10 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 44, l10);
                l12 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 25, l12);
                l2 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 9, l2);
                l4 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 48, l4);
                l8 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 35, l8);
                l6 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 52, l6);
                l16 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 23, l16);
                l10 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 31, l10);
                l12 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 37, l12);
                l14 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 20, l14);
                l2 += lArray3[n2 + 1];
                l3 += lArray3[n2 + 2];
                l4 += lArray3[n2 + 3];
                l5 += lArray3[n2 + 4];
                l6 += lArray3[n2 + 5];
                l7 += lArray3[n2 + 6];
                l8 += lArray3[n2 + 7];
                l9 += lArray3[n2 + 8];
                l10 += lArray3[n2 + 9];
                l11 += lArray3[n2 + 10];
                l12 += lArray3[n2 + 11];
                l13 += lArray3[n2 + 12];
                l14 += lArray3[n2 + 13];
                l15 += lArray3[n2 + 14] + lArray4[n3 + 1];
                l16 += lArray3[n2 + 15] + lArray4[n3 + 2];
                l17 += lArray3[n2 + 16] + (long)i2 + 1L;
            }
            lArray2[0] = l2;
            lArray2[1] = l3;
            lArray2[2] = l4;
            lArray2[3] = l5;
            lArray2[4] = l6;
            lArray2[5] = l7;
            lArray2[6] = l8;
            lArray2[7] = l9;
            lArray2[8] = l10;
            lArray2[9] = l11;
            lArray2[10] = l12;
            lArray2[11] = l13;
            lArray2[12] = l14;
            lArray2[13] = l15;
            lArray2[14] = l16;
            lArray2[15] = l17;
        }

        @Override
        void b(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.b;
            long[] lArray4 = this.a;
            int[] nArray = i;
            int[] nArray2 = k;
            if (lArray3.length != 33) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l2 = lArray[0];
            long l3 = lArray[1];
            long l4 = lArray[2];
            long l5 = lArray[3];
            long l6 = lArray[4];
            long l7 = lArray[5];
            long l8 = lArray[6];
            long l9 = lArray[7];
            long l10 = lArray[8];
            long l11 = lArray[9];
            long l12 = lArray[10];
            long l13 = lArray[11];
            long l14 = lArray[12];
            long l15 = lArray[13];
            long l16 = lArray[14];
            long l17 = lArray[15];
            for (int i2 = 19; i2 >= 1; i2 -= 2) {
                int n2 = nArray[i2];
                int n3 = nArray2[i2];
                l2 -= lArray3[n2 + 1];
                l3 -= lArray3[n2 + 2];
                l4 -= lArray3[n2 + 3];
                l5 -= lArray3[n2 + 4];
                l6 -= lArray3[n2 + 5];
                l7 -= lArray3[n2 + 6];
                l8 -= lArray3[n2 + 7];
                l9 -= lArray3[n2 + 8];
                l10 -= lArray3[n2 + 9];
                l11 -= lArray3[n2 + 10];
                l12 -= lArray3[n2 + 11];
                l13 -= lArray3[n2 + 12];
                l14 -= lArray3[n2 + 13];
                l15 -= lArray3[n2 + 14] + lArray4[n3 + 1];
                l16 -= lArray3[n2 + 15] + lArray4[n3 + 2];
                l17 -= lArray3[n2 + 16] + (long)i2 + 1L;
                l17 = ThreefishEngine.xorRotr(l17, 9, l2);
                l2 -= l17;
                l13 = ThreefishEngine.xorRotr(l13, 48, l4);
                l4 -= l13;
                l15 = ThreefishEngine.xorRotr(l15, 35, l8);
                l8 -= l15;
                l11 = ThreefishEngine.xorRotr(l11, 52, l6);
                l6 -= l11;
                l3 = ThreefishEngine.xorRotr(l3, 23, l16);
                l16 -= l3;
                l7 = ThreefishEngine.xorRotr(l7, 31, l10);
                l10 -= l7;
                l5 = ThreefishEngine.xorRotr(l5, 37, l12);
                l12 -= l5;
                l9 = ThreefishEngine.xorRotr(l9, 20, l14);
                l14 -= l9;
                l9 = ThreefishEngine.xorRotr(l9, 31, l2);
                l2 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 44, l4);
                l4 -= l7;
                l5 = ThreefishEngine.xorRotr(l5, 47, l6);
                l6 -= l5;
                l3 = ThreefishEngine.xorRotr(l3, 46, l8);
                l8 -= l3;
                l17 = ThreefishEngine.xorRotr(l17, 19, l14);
                l14 -= l17;
                l15 = ThreefishEngine.xorRotr(l15, 42, l16);
                l16 -= l15;
                l13 = ThreefishEngine.xorRotr(l13, 44, l10);
                l10 -= l13;
                l11 = ThreefishEngine.xorRotr(l11, 25, l12);
                l12 -= l11;
                l11 = ThreefishEngine.xorRotr(l11, 16, l2);
                l2 -= l11;
                l15 = ThreefishEngine.xorRotr(l15, 34, l4);
                l4 -= l15;
                l13 = ThreefishEngine.xorRotr(l13, 56, l8);
                l8 -= l13;
                l17 = ThreefishEngine.xorRotr(l17, 51, l6);
                l6 -= l17;
                l9 = ThreefishEngine.xorRotr(l9, 4, l12);
                l12 -= l9;
                l5 = ThreefishEngine.xorRotr(l5, 53, l14);
                l14 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 42, l16);
                l16 -= l7;
                l3 = ThreefishEngine.xorRotr(l3, 41, l10);
                l10 -= l3;
                l3 = ThreefishEngine.xorRotr(l3, 41, l2);
                l2 -= l3;
                l5 = ThreefishEngine.xorRotr(l5, 9, l4);
                l4 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 37, l6);
                l6 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 31, l8);
                l8 -= l9;
                l11 = ThreefishEngine.xorRotr(l11, 12, l10);
                l10 -= l11;
                l13 = ThreefishEngine.xorRotr(l13, 47, l12);
                l12 -= l13;
                l15 = ThreefishEngine.xorRotr(l15, 44, l14);
                l14 -= l15;
                l17 = ThreefishEngine.xorRotr(l17, 30, l16);
                l16 -= l17;
                l2 -= lArray3[n2];
                l3 -= lArray3[n2 + 1];
                l4 -= lArray3[n2 + 2];
                l5 -= lArray3[n2 + 3];
                l6 -= lArray3[n2 + 4];
                l7 -= lArray3[n2 + 5];
                l8 -= lArray3[n2 + 6];
                l9 -= lArray3[n2 + 7];
                l10 -= lArray3[n2 + 8];
                l11 -= lArray3[n2 + 9];
                l12 -= lArray3[n2 + 10];
                l13 -= lArray3[n2 + 11];
                l14 -= lArray3[n2 + 12];
                l15 -= lArray3[n2 + 13] + lArray4[n3];
                l16 -= lArray3[n2 + 14] + lArray4[n3 + 1];
                l17 -= lArray3[n2 + 15] + (long)i2;
                l17 = ThreefishEngine.xorRotr(l17, 5, l2);
                l2 -= l17;
                l13 = ThreefishEngine.xorRotr(l13, 20, l4);
                l4 -= l13;
                l15 = ThreefishEngine.xorRotr(l15, 48, l8);
                l8 -= l15;
                l11 = ThreefishEngine.xorRotr(l11, 41, l6);
                l6 -= l11;
                l3 = ThreefishEngine.xorRotr(l3, 47, l16);
                l16 -= l3;
                l7 = ThreefishEngine.xorRotr(l7, 28, l10);
                l10 -= l7;
                l5 = ThreefishEngine.xorRotr(l5, 16, l12);
                l12 -= l5;
                l9 = ThreefishEngine.xorRotr(l9, 25, l14);
                l14 -= l9;
                l9 = ThreefishEngine.xorRotr(l9, 33, l2);
                l2 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 4, l4);
                l4 -= l7;
                l5 = ThreefishEngine.xorRotr(l5, 51, l6);
                l6 -= l5;
                l3 = ThreefishEngine.xorRotr(l3, 13, l8);
                l8 -= l3;
                l17 = ThreefishEngine.xorRotr(l17, 34, l14);
                l14 -= l17;
                l15 = ThreefishEngine.xorRotr(l15, 41, l16);
                l16 -= l15;
                l13 = ThreefishEngine.xorRotr(l13, 59, l10);
                l10 -= l13;
                l11 = ThreefishEngine.xorRotr(l11, 17, l12);
                l12 -= l11;
                l11 = ThreefishEngine.xorRotr(l11, 38, l2);
                l2 -= l11;
                l15 = ThreefishEngine.xorRotr(l15, 19, l4);
                l4 -= l15;
                l13 = ThreefishEngine.xorRotr(l13, 10, l8);
                l8 -= l13;
                l17 = ThreefishEngine.xorRotr(l17, 55, l6);
                l6 -= l17;
                l9 = ThreefishEngine.xorRotr(l9, 49, l12);
                l12 -= l9;
                l5 = ThreefishEngine.xorRotr(l5, 18, l14);
                l14 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 23, l16);
                l16 -= l7;
                l3 = ThreefishEngine.xorRotr(l3, 52, l10);
                l10 -= l3;
                l3 = ThreefishEngine.xorRotr(l3, 24, l2);
                l2 -= l3;
                l5 = ThreefishEngine.xorRotr(l5, 13, l4);
                l4 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 8, l6);
                l6 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 47, l8);
                l8 -= l9;
                l11 = ThreefishEngine.xorRotr(l11, 8, l10);
                l10 -= l11;
                l13 = ThreefishEngine.xorRotr(l13, 17, l12);
                l12 -= l13;
                l15 = ThreefishEngine.xorRotr(l15, 22, l14);
                l14 -= l15;
                l17 = ThreefishEngine.xorRotr(l17, 37, l16);
                l16 -= l17;
            }
            l2 -= lArray3[0];
            l3 -= lArray3[1];
            l4 -= lArray3[2];
            l5 -= lArray3[3];
            l6 -= lArray3[4];
            l7 -= lArray3[5];
            l8 -= lArray3[6];
            l9 -= lArray3[7];
            l10 -= lArray3[8];
            l11 -= lArray3[9];
            l12 -= lArray3[10];
            l13 -= lArray3[11];
            l14 -= lArray3[12];
            l15 -= lArray3[13] + lArray4[0];
            l16 -= lArray3[14] + lArray4[1];
            l17 -= lArray3[15];
            lArray2[0] = l2;
            lArray2[1] = l3;
            lArray2[2] = l4;
            lArray2[3] = l5;
            lArray2[4] = l6;
            lArray2[5] = l7;
            lArray2[6] = l8;
            lArray2[7] = l9;
            lArray2[8] = l10;
            lArray2[9] = l11;
            lArray2[10] = l12;
            lArray2[11] = l13;
            lArray2[12] = l14;
            lArray2[13] = l15;
            lArray2[14] = l16;
            lArray2[15] = l17;
        }
    }

    private static final class b
    extends d {
        private static final int c = 14;
        private static final int d = 16;
        private static final int e = 52;
        private static final int f = 57;
        private static final int g = 23;
        private static final int h = 40;
        private static final int i = 5;
        private static final int j = 37;
        private static final int k = 25;
        private static final int l = 33;
        private static final int m = 46;
        private static final int n = 12;
        private static final int o = 58;
        private static final int p = 22;
        private static final int q = 32;
        private static final int r = 32;

        public b(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        @Override
        void a(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.b;
            long[] lArray4 = this.a;
            int[] nArray = j;
            int[] nArray2 = k;
            if (lArray3.length != 9) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l2 = lArray[0];
            long l3 = lArray[1];
            long l4 = lArray[2];
            long l5 = lArray[3];
            l2 += lArray3[0];
            l3 += lArray3[1] + lArray4[0];
            l4 += lArray3[2] + lArray4[1];
            l5 += lArray3[3];
            for (int i2 = 1; i2 < 18; i2 += 2) {
                int n2 = nArray[i2];
                int n3 = nArray2[i2];
                l2 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 14, l2);
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 16, l4);
                l2 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 52, l2);
                l4 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 57, l4);
                l2 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 23, l2);
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 40, l4);
                l2 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 5, l2);
                l4 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 37, l4);
                l2 += lArray3[n2];
                l4 += lArray3[n2 + 2] + lArray4[n3 + 1];
                l3 = ThreefishEngine.rotlXor(l3, 25, l2 += (l3 += lArray3[n2 + 1] + lArray4[n3]));
                l5 = ThreefishEngine.rotlXor(l5, 33, l4 += (l5 += lArray3[n2 + 3] + (long)i2));
                l2 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 46, l2);
                l4 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 12, l4);
                l2 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 58, l2);
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 22, l4);
                l2 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 32, l2);
                l4 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 32, l4);
                l2 += lArray3[n2 + 1];
                l3 += lArray3[n2 + 2] + lArray4[n3 + 1];
                l4 += lArray3[n2 + 3] + lArray4[n3 + 2];
                l5 += lArray3[n2 + 4] + (long)i2 + 1L;
            }
            lArray2[0] = l2;
            lArray2[1] = l3;
            lArray2[2] = l4;
            lArray2[3] = l5;
        }

        @Override
        void b(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.b;
            long[] lArray4 = this.a;
            int[] nArray = j;
            int[] nArray2 = k;
            if (lArray3.length != 9) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l2 = lArray[0];
            long l3 = lArray[1];
            long l4 = lArray[2];
            long l5 = lArray[3];
            for (int i2 = 17; i2 >= 1; i2 -= 2) {
                int n2 = nArray[i2];
                int n3 = nArray2[i2];
                l3 -= lArray3[n2 + 2] + lArray4[n3 + 1];
                l5 -= lArray3[n2 + 4] + (long)i2 + 1L;
                l5 = ThreefishEngine.xorRotr(l5, 32, l2 -= lArray3[n2 + 1]);
                l3 = ThreefishEngine.xorRotr(l3, 32, l4 -= lArray3[n2 + 3] + lArray4[n3 + 2]);
                l4 -= l3;
                l3 = ThreefishEngine.xorRotr(l3, 58, l2 -= l5);
                l5 = ThreefishEngine.xorRotr(l5, 22, l4);
                l4 -= l5;
                l5 = ThreefishEngine.xorRotr(l5, 46, l2 -= l3);
                l3 = ThreefishEngine.xorRotr(l3, 12, l4);
                l4 -= l3;
                l3 = ThreefishEngine.xorRotr(l3, 25, l2 -= l5);
                l2 -= l3;
                l5 = ThreefishEngine.xorRotr(l5, 33, l4);
                l4 -= l5;
                l3 -= lArray3[n2 + 1] + lArray4[n3];
                l5 -= lArray3[n2 + 3] + (long)i2;
                l5 = ThreefishEngine.xorRotr(l5, 5, l2 -= lArray3[n2]);
                l3 = ThreefishEngine.xorRotr(l3, 37, l4 -= lArray3[n2 + 2] + lArray4[n3 + 1]);
                l4 -= l3;
                l3 = ThreefishEngine.xorRotr(l3, 23, l2 -= l5);
                l5 = ThreefishEngine.xorRotr(l5, 40, l4);
                l4 -= l5;
                l5 = ThreefishEngine.xorRotr(l5, 52, l2 -= l3);
                l3 = ThreefishEngine.xorRotr(l3, 57, l4);
                l4 -= l3;
                l3 = ThreefishEngine.xorRotr(l3, 14, l2 -= l5);
                l2 -= l3;
                l5 = ThreefishEngine.xorRotr(l5, 16, l4);
                l4 -= l5;
            }
            lArray2[0] = l2 -= lArray3[0];
            lArray2[1] = l3 -= lArray3[1] + lArray4[0];
            lArray2[2] = l4 -= lArray3[2] + lArray4[1];
            lArray2[3] = l5 -= lArray3[3];
        }
    }

    private static final class c
    extends d {
        private static final int c = 46;
        private static final int d = 36;
        private static final int e = 19;
        private static final int f = 37;
        private static final int g = 33;
        private static final int h = 27;
        private static final int i = 14;
        private static final int j = 42;
        private static final int k = 17;
        private static final int l = 49;
        private static final int m = 36;
        private static final int n = 39;
        private static final int o = 44;
        private static final int p = 9;
        private static final int q = 54;
        private static final int r = 56;
        private static final int s = 39;
        private static final int t = 30;
        private static final int u = 34;
        private static final int v = 24;
        private static final int w = 13;
        private static final int x = 50;
        private static final int y = 10;
        private static final int z = 17;
        private static final int A = 25;
        private static final int B = 29;
        private static final int C = 39;
        private static final int D = 43;
        private static final int E = 8;
        private static final int F = 35;
        private static final int G = 56;
        private static final int H = 22;

        protected c(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        @Override
        public void a(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.b;
            long[] lArray4 = this.a;
            int[] nArray = h;
            int[] nArray2 = k;
            if (lArray3.length != 17) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l2 = lArray[0];
            long l3 = lArray[1];
            long l4 = lArray[2];
            long l5 = lArray[3];
            long l6 = lArray[4];
            long l7 = lArray[5];
            long l8 = lArray[6];
            long l9 = lArray[7];
            l2 += lArray3[0];
            l3 += lArray3[1];
            l4 += lArray3[2];
            l5 += lArray3[3];
            l6 += lArray3[4];
            l7 += lArray3[5] + lArray4[0];
            l8 += lArray3[6] + lArray4[1];
            l9 += lArray3[7];
            for (int i2 = 1; i2 < 18; i2 += 2) {
                int n2 = nArray[i2];
                int n3 = nArray2[i2];
                l2 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 46, l2);
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 36, l4);
                l6 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 19, l6);
                l8 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 37, l8);
                l4 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 33, l4);
                l6 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 27, l6);
                l8 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 14, l8);
                l2 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 42, l2);
                l6 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 17, l6);
                l8 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 49, l8);
                l2 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 36, l2);
                l4 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 39, l4);
                l8 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 44, l8);
                l2 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 9, l2);
                l4 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 54, l4);
                l6 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 56, l6);
                l2 += lArray3[n2];
                l3 += lArray3[n2 + 1];
                l4 += lArray3[n2 + 2];
                l5 += lArray3[n2 + 3];
                l6 += lArray3[n2 + 4];
                l7 += lArray3[n2 + 5] + lArray4[n3];
                l8 += lArray3[n2 + 6] + lArray4[n3 + 1];
                l9 += lArray3[n2 + 7] + (long)i2;
                l2 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 39, l2);
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 30, l4);
                l6 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 34, l6);
                l8 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 24, l8);
                l4 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 13, l4);
                l6 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 50, l6);
                l8 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 10, l8);
                l2 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 17, l2);
                l6 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 25, l6);
                l8 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 29, l8);
                l2 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 39, l2);
                l4 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 43, l4);
                l8 += l3;
                l3 = ThreefishEngine.rotlXor(l3, 8, l8);
                l2 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 35, l2);
                l4 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 56, l4);
                l6 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 22, l6);
                l2 += lArray3[n2 + 1];
                l3 += lArray3[n2 + 2];
                l4 += lArray3[n2 + 3];
                l5 += lArray3[n2 + 4];
                l6 += lArray3[n2 + 5];
                l7 += lArray3[n2 + 6] + lArray4[n3 + 1];
                l8 += lArray3[n2 + 7] + lArray4[n3 + 2];
                l9 += lArray3[n2 + 8] + (long)i2 + 1L;
            }
            lArray2[0] = l2;
            lArray2[1] = l3;
            lArray2[2] = l4;
            lArray2[3] = l5;
            lArray2[4] = l6;
            lArray2[5] = l7;
            lArray2[6] = l8;
            lArray2[7] = l9;
        }

        @Override
        public void b(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.b;
            long[] lArray4 = this.a;
            int[] nArray = h;
            int[] nArray2 = k;
            if (lArray3.length != 17) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l2 = lArray[0];
            long l3 = lArray[1];
            long l4 = lArray[2];
            long l5 = lArray[3];
            long l6 = lArray[4];
            long l7 = lArray[5];
            long l8 = lArray[6];
            long l9 = lArray[7];
            for (int i2 = 17; i2 >= 1; i2 -= 2) {
                int n2 = nArray[i2];
                int n3 = nArray2[i2];
                l2 -= lArray3[n2 + 1];
                l3 -= lArray3[n2 + 2];
                l4 -= lArray3[n2 + 3];
                l5 -= lArray3[n2 + 4];
                l6 -= lArray3[n2 + 5];
                l7 -= lArray3[n2 + 6] + lArray4[n3 + 1];
                l9 -= lArray3[n2 + 8] + (long)i2 + 1L;
                l3 = ThreefishEngine.xorRotr(l3, 8, l8 -= lArray3[n2 + 7] + lArray4[n3 + 2]);
                l8 -= l3;
                l9 = ThreefishEngine.xorRotr(l9, 35, l2);
                l2 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 56, l4);
                l4 -= l7;
                l5 = ThreefishEngine.xorRotr(l5, 22, l6);
                l3 = ThreefishEngine.xorRotr(l3, 25, l6 -= l5);
                l6 -= l3;
                l5 = ThreefishEngine.xorRotr(l5, 29, l8);
                l8 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 39, l2);
                l2 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 43, l4);
                l3 = ThreefishEngine.xorRotr(l3, 13, l4 -= l9);
                l4 -= l3;
                l9 = ThreefishEngine.xorRotr(l9, 50, l6);
                l6 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 10, l8);
                l8 -= l7;
                l5 = ThreefishEngine.xorRotr(l5, 17, l2);
                l3 = ThreefishEngine.xorRotr(l3, 39, l2 -= l5);
                l2 -= l3;
                l5 = ThreefishEngine.xorRotr(l5, 30, l4);
                l4 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 34, l6);
                l6 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 24, l8);
                l8 -= l9;
                l2 -= lArray3[n2];
                l3 -= lArray3[n2 + 1];
                l4 -= lArray3[n2 + 2];
                l5 -= lArray3[n2 + 3];
                l6 -= lArray3[n2 + 4];
                l7 -= lArray3[n2 + 5] + lArray4[n3];
                l9 -= lArray3[n2 + 7] + (long)i2;
                l3 = ThreefishEngine.xorRotr(l3, 44, l8 -= lArray3[n2 + 6] + lArray4[n3 + 1]);
                l8 -= l3;
                l9 = ThreefishEngine.xorRotr(l9, 9, l2);
                l2 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 54, l4);
                l4 -= l7;
                l5 = ThreefishEngine.xorRotr(l5, 56, l6);
                l3 = ThreefishEngine.xorRotr(l3, 17, l6 -= l5);
                l6 -= l3;
                l5 = ThreefishEngine.xorRotr(l5, 49, l8);
                l8 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 36, l2);
                l2 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 39, l4);
                l3 = ThreefishEngine.xorRotr(l3, 33, l4 -= l9);
                l4 -= l3;
                l9 = ThreefishEngine.xorRotr(l9, 27, l6);
                l6 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 14, l8);
                l8 -= l7;
                l5 = ThreefishEngine.xorRotr(l5, 42, l2);
                l3 = ThreefishEngine.xorRotr(l3, 46, l2 -= l5);
                l2 -= l3;
                l5 = ThreefishEngine.xorRotr(l5, 36, l4);
                l4 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 19, l6);
                l6 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 37, l8);
                l8 -= l9;
            }
            l2 -= lArray3[0];
            l3 -= lArray3[1];
            l4 -= lArray3[2];
            l5 -= lArray3[3];
            l6 -= lArray3[4];
            l7 -= lArray3[5] + lArray4[0];
            l8 -= lArray3[6] + lArray4[1];
            l9 -= lArray3[7];
            lArray2[0] = l2;
            lArray2[1] = l3;
            lArray2[2] = l4;
            lArray2[3] = l5;
            lArray2[4] = l6;
            lArray2[5] = l7;
            lArray2[6] = l8;
            lArray2[7] = l9;
        }
    }

    private static abstract class d {
        protected final long[] a;
        protected final long[] b;

        protected d(long[] lArray, long[] lArray2) {
            this.b = lArray;
            this.a = lArray2;
        }

        abstract void a(long[] var1, long[] var2);

        abstract void b(long[] var1, long[] var2);
    }
}

