/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.x500.style;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.DERIA5String;
import com.aspose.cad.internal.bouncycastle.asn1.DERPrintableString;
import com.aspose.cad.internal.bouncycastle.asn1.x500.RDN;
import com.aspose.cad.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.cad.internal.bouncycastle.asn1.x500.X500NameStyle;
import com.aspose.cad.internal.bouncycastle.asn1.x500.style.AbstractX500NameStyle;
import com.aspose.cad.internal.bouncycastle.asn1.x500.style.IETFUtils;
import java.util.Hashtable;

public class RFC4519Style
extends AbstractX500NameStyle {
    public static final ASN1ObjectIdentifier businessCategory = new ASN1ObjectIdentifier("2.5.4.15").intern();
    public static final ASN1ObjectIdentifier c = new ASN1ObjectIdentifier("2.5.4.6").intern();
    public static final ASN1ObjectIdentifier cn = new ASN1ObjectIdentifier("2.5.4.3").intern();
    public static final ASN1ObjectIdentifier dc = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.25").intern();
    public static final ASN1ObjectIdentifier description = new ASN1ObjectIdentifier("2.5.4.13").intern();
    public static final ASN1ObjectIdentifier destinationIndicator = new ASN1ObjectIdentifier("2.5.4.27").intern();
    public static final ASN1ObjectIdentifier distinguishedName = new ASN1ObjectIdentifier("2.5.4.49").intern();
    public static final ASN1ObjectIdentifier dnQualifier = new ASN1ObjectIdentifier("2.5.4.46").intern();
    public static final ASN1ObjectIdentifier enhancedSearchGuide = new ASN1ObjectIdentifier("2.5.4.47").intern();
    public static final ASN1ObjectIdentifier facsimileTelephoneNumber = new ASN1ObjectIdentifier("2.5.4.23").intern();
    public static final ASN1ObjectIdentifier generationQualifier = new ASN1ObjectIdentifier("2.5.4.44").intern();
    public static final ASN1ObjectIdentifier givenName = new ASN1ObjectIdentifier("2.5.4.42").intern();
    public static final ASN1ObjectIdentifier houseIdentifier = new ASN1ObjectIdentifier("2.5.4.51").intern();
    public static final ASN1ObjectIdentifier initials = new ASN1ObjectIdentifier("2.5.4.43").intern();
    public static final ASN1ObjectIdentifier internationalISDNNumber = new ASN1ObjectIdentifier("2.5.4.25").intern();
    public static final ASN1ObjectIdentifier l = new ASN1ObjectIdentifier("2.5.4.7").intern();
    public static final ASN1ObjectIdentifier member = new ASN1ObjectIdentifier("2.5.4.31").intern();
    public static final ASN1ObjectIdentifier name = new ASN1ObjectIdentifier("2.5.4.41").intern();
    public static final ASN1ObjectIdentifier o = new ASN1ObjectIdentifier("2.5.4.10").intern();
    public static final ASN1ObjectIdentifier ou = new ASN1ObjectIdentifier("2.5.4.11").intern();
    public static final ASN1ObjectIdentifier owner = new ASN1ObjectIdentifier("2.5.4.32").intern();
    public static final ASN1ObjectIdentifier physicalDeliveryOfficeName = new ASN1ObjectIdentifier("2.5.4.19").intern();
    public static final ASN1ObjectIdentifier postalAddress = new ASN1ObjectIdentifier("2.5.4.16").intern();
    public static final ASN1ObjectIdentifier postalCode = new ASN1ObjectIdentifier("2.5.4.17").intern();
    public static final ASN1ObjectIdentifier postOfficeBox = new ASN1ObjectIdentifier("2.5.4.18").intern();
    public static final ASN1ObjectIdentifier preferredDeliveryMethod = new ASN1ObjectIdentifier("2.5.4.28").intern();
    public static final ASN1ObjectIdentifier registeredAddress = new ASN1ObjectIdentifier("2.5.4.26").intern();
    public static final ASN1ObjectIdentifier roleOccupant = new ASN1ObjectIdentifier("2.5.4.33").intern();
    public static final ASN1ObjectIdentifier searchGuide = new ASN1ObjectIdentifier("2.5.4.14").intern();
    public static final ASN1ObjectIdentifier seeAlso = new ASN1ObjectIdentifier("2.5.4.34").intern();
    public static final ASN1ObjectIdentifier serialNumber = new ASN1ObjectIdentifier("2.5.4.5").intern();
    public static final ASN1ObjectIdentifier sn = new ASN1ObjectIdentifier("2.5.4.4").intern();
    public static final ASN1ObjectIdentifier st = new ASN1ObjectIdentifier("2.5.4.8").intern();
    public static final ASN1ObjectIdentifier street = new ASN1ObjectIdentifier("2.5.4.9").intern();
    public static final ASN1ObjectIdentifier telephoneNumber = new ASN1ObjectIdentifier("2.5.4.20").intern();
    public static final ASN1ObjectIdentifier teletexTerminalIdentifier = new ASN1ObjectIdentifier("2.5.4.22").intern();
    public static final ASN1ObjectIdentifier telexNumber = new ASN1ObjectIdentifier("2.5.4.21").intern();
    public static final ASN1ObjectIdentifier title = new ASN1ObjectIdentifier("2.5.4.12").intern();
    public static final ASN1ObjectIdentifier uid = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.1").intern();
    public static final ASN1ObjectIdentifier uniqueMember = new ASN1ObjectIdentifier("2.5.4.50").intern();
    public static final ASN1ObjectIdentifier userPassword = new ASN1ObjectIdentifier("2.5.4.35").intern();
    public static final ASN1ObjectIdentifier x121Address = new ASN1ObjectIdentifier("2.5.4.24").intern();
    public static final ASN1ObjectIdentifier x500UniqueIdentifier = new ASN1ObjectIdentifier("2.5.4.45").intern();
    private static final Hashtable a = new Hashtable();
    private static final Hashtable b = new Hashtable();
    public static final X500NameStyle INSTANCE;
    protected final Hashtable defaultLookUp;
    protected final Hashtable defaultSymbols = RFC4519Style.copyHashTable(a);

    protected RFC4519Style() {
        this.defaultLookUp = RFC4519Style.copyHashTable(b);
    }

    @Override
    protected ASN1Encodable encodeStringValue(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        if (aSN1ObjectIdentifier.equals(dc)) {
            return new DERIA5String(string);
        }
        if (aSN1ObjectIdentifier.equals(c) || aSN1ObjectIdentifier.equals(serialNumber) || aSN1ObjectIdentifier.equals(dnQualifier) || aSN1ObjectIdentifier.equals(telephoneNumber)) {
            return new DERPrintableString(string);
        }
        return super.encodeStringValue(aSN1ObjectIdentifier, string);
    }

    @Override
    public String oidToDisplayName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (String)a.get(aSN1ObjectIdentifier);
    }

    @Override
    public String[] oidToAttrNames(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return IETFUtils.findAttrNamesForOID(aSN1ObjectIdentifier, this.defaultLookUp);
    }

    @Override
    public ASN1ObjectIdentifier attrNameToOID(String string) {
        return IETFUtils.decodeAttrName(string, this.defaultLookUp);
    }

    @Override
    public RDN[] fromString(String string) {
        RDN[] rDNArray = IETFUtils.rDNsFromString(string, this);
        RDN[] rDNArray2 = new RDN[rDNArray.length];
        for (int i2 = 0; i2 != rDNArray.length; ++i2) {
            rDNArray2[rDNArray2.length - i2 - 1] = rDNArray[i2];
        }
        return rDNArray2;
    }

    @Override
    public String toString(X500Name x500Name) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        RDN[] rDNArray = x500Name.getRDNs();
        for (int i2 = rDNArray.length - 1; i2 >= 0; --i2) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(',');
            }
            IETFUtils.appendRDN(stringBuffer, rDNArray[i2], this.defaultSymbols);
        }
        return stringBuffer.toString();
    }

    static {
        a.put(businessCategory, "businessCategory");
        a.put(c, "c");
        a.put(cn, "cn");
        a.put(dc, "dc");
        a.put(description, "description");
        a.put(destinationIndicator, "destinationIndicator");
        a.put(distinguishedName, "distinguishedName");
        a.put(dnQualifier, "dnQualifier");
        a.put(enhancedSearchGuide, "enhancedSearchGuide");
        a.put(facsimileTelephoneNumber, "facsimileTelephoneNumber");
        a.put(generationQualifier, "generationQualifier");
        a.put(givenName, "givenName");
        a.put(houseIdentifier, "houseIdentifier");
        a.put(initials, "initials");
        a.put(internationalISDNNumber, "internationalISDNNumber");
        a.put(l, "l");
        a.put(member, "member");
        a.put(name, "name");
        a.put(o, "o");
        a.put(ou, "ou");
        a.put(owner, "owner");
        a.put(physicalDeliveryOfficeName, "physicalDeliveryOfficeName");
        a.put(postalAddress, "postalAddress");
        a.put(postalCode, "postalCode");
        a.put(postOfficeBox, "postOfficeBox");
        a.put(preferredDeliveryMethod, "preferredDeliveryMethod");
        a.put(registeredAddress, "registeredAddress");
        a.put(roleOccupant, "roleOccupant");
        a.put(searchGuide, "searchGuide");
        a.put(seeAlso, "seeAlso");
        a.put(serialNumber, "serialNumber");
        a.put(sn, "sn");
        a.put(st, "st");
        a.put(street, "street");
        a.put(telephoneNumber, "telephoneNumber");
        a.put(teletexTerminalIdentifier, "teletexTerminalIdentifier");
        a.put(telexNumber, "telexNumber");
        a.put(title, "title");
        a.put(uid, "uid");
        a.put(uniqueMember, "uniqueMember");
        a.put(userPassword, "userPassword");
        a.put(x121Address, "x121Address");
        a.put(x500UniqueIdentifier, "x500UniqueIdentifier");
        b.put("businesscategory", businessCategory);
        b.put("c", c);
        b.put("cn", cn);
        b.put("dc", dc);
        b.put("description", description);
        b.put("destinationindicator", destinationIndicator);
        b.put("distinguishedname", distinguishedName);
        b.put("dnqualifier", dnQualifier);
        b.put("enhancedsearchguide", enhancedSearchGuide);
        b.put("facsimiletelephonenumber", facsimileTelephoneNumber);
        b.put("generationqualifier", generationQualifier);
        b.put("givenname", givenName);
        b.put("houseidentifier", houseIdentifier);
        b.put("initials", initials);
        b.put("internationalisdnnumber", internationalISDNNumber);
        b.put("l", l);
        b.put("member", member);
        b.put("name", name);
        b.put("o", o);
        b.put("ou", ou);
        b.put("owner", owner);
        b.put("physicaldeliveryofficename", physicalDeliveryOfficeName);
        b.put("postaladdress", postalAddress);
        b.put("postalcode", postalCode);
        b.put("postofficebox", postOfficeBox);
        b.put("preferreddeliverymethod", preferredDeliveryMethod);
        b.put("registeredaddress", registeredAddress);
        b.put("roleoccupant", roleOccupant);
        b.put("searchguide", searchGuide);
        b.put("seealso", seeAlso);
        b.put("serialnumber", serialNumber);
        b.put("sn", sn);
        b.put("st", st);
        b.put("street", street);
        b.put("telephonenumber", telephoneNumber);
        b.put("teletexterminalidentifier", teletexTerminalIdentifier);
        b.put("telexnumber", telexNumber);
        b.put("title", title);
        b.put("uid", uid);
        b.put("uniquemember", uniqueMember);
        b.put("userpassword", userPassword);
        b.put("x121address", x121Address);
        b.put("x500uniqueidentifier", x500UniqueIdentifier);
        INSTANCE = new RFC4519Style();
    }
}

