/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.isismtt.x509;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERPrintableString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.x500.DirectoryString;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.cad.internal.bouncycastle.asn1.x509.IssuerSerial;
import java.util.Enumeration;

public class ProcurationSyntax
extends ASN1Object {
    private String a;
    private DirectoryString b;
    private GeneralName c;
    private IssuerSerial d;

    public static ProcurationSyntax getInstance(Object object) {
        if (object == null || object instanceof ProcurationSyntax) {
            return (ProcurationSyntax)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ProcurationSyntax((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    private ProcurationSyntax(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        block5: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement());
            switch (aSN1TaggedObject.getTagNo()) {
                case 1: {
                    this.a = DERPrintableString.getInstance(aSN1TaggedObject, true).getString();
                    continue block5;
                }
                case 2: {
                    this.b = DirectoryString.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 3: {
                    ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
                    if (aSN1Primitive instanceof ASN1TaggedObject) {
                        this.c = GeneralName.getInstance(aSN1Primitive);
                        continue block5;
                    }
                    this.d = IssuerSerial.getInstance(aSN1Primitive);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Bad tag number: " + aSN1TaggedObject.getTagNo());
        }
    }

    public ProcurationSyntax(String string, DirectoryString directoryString, IssuerSerial issuerSerial) {
        this.a = string;
        this.b = directoryString;
        this.c = null;
        this.d = issuerSerial;
    }

    public ProcurationSyntax(String string, DirectoryString directoryString, GeneralName generalName) {
        this.a = string;
        this.b = directoryString;
        this.c = generalName;
        this.d = null;
    }

    public String getCountry() {
        return this.a;
    }

    public DirectoryString getTypeOfSubstitution() {
        return this.b;
    }

    public GeneralName getThirdPerson() {
        return this.c;
    }

    public IssuerSerial getCertRef() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, new DERPrintableString(this.a, true)));
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, this.b));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 3, this.c));
        } else {
            aSN1EncodableVector.add(new DERTaggedObject(true, 3, this.d));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

