/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OutputStream;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1SetParser;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.BERSet;
import com.aspose.cad.internal.bouncycastle.asn1.BERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERNull;
import com.aspose.cad.internal.bouncycastle.asn1.DERSet;
import com.aspose.cad.internal.bouncycastle.asn1.DLSet;
import com.aspose.cad.internal.bouncycastle.asn1.b;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.Iterable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public abstract class ASN1Set
extends ASN1Primitive
implements Iterable<ASN1Encodable> {
    private Vector a = new Vector();
    private boolean b = false;

    public static ASN1Set getInstance(Object object) {
        ASN1Primitive aSN1Primitive;
        if (object == null || object instanceof ASN1Set) {
            return (ASN1Set)object;
        }
        if (object instanceof ASN1SetParser) {
            return ASN1Set.getInstance(((ASN1SetParser)object).toASN1Primitive());
        }
        if (object instanceof byte[]) {
            try {
                return ASN1Set.getInstance(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct set from byte[]: " + iOException.getMessage());
            }
        }
        if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1Set) {
            return (ASN1Set)aSN1Primitive;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public static ASN1Set getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        if (bl2) {
            if (!aSN1TaggedObject.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Set)aSN1TaggedObject.getObject();
        }
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (aSN1TaggedObject.isExplicit()) {
            if (aSN1TaggedObject instanceof BERTaggedObject) {
                return new BERSet(aSN1Primitive);
            }
            return new DLSet(aSN1Primitive);
        }
        if (aSN1Primitive instanceof ASN1Set) {
            return (ASN1Set)aSN1Primitive;
        }
        if (aSN1Primitive instanceof ASN1Sequence) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
            if (aSN1TaggedObject instanceof BERTaggedObject) {
                return new BERSet(aSN1Sequence.toArray());
            }
            return new DLSet(aSN1Sequence.toArray());
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + aSN1TaggedObject.getClass().getName());
    }

    protected ASN1Set() {
    }

    protected ASN1Set(ASN1Encodable aSN1Encodable) {
        this.a.addElement(aSN1Encodable);
    }

    protected ASN1Set(ASN1EncodableVector aSN1EncodableVector, boolean bl2) {
        for (int i2 = 0; i2 != aSN1EncodableVector.size(); ++i2) {
            this.a.addElement(aSN1EncodableVector.get(i2));
        }
        if (bl2) {
            this.sort();
        }
    }

    protected ASN1Set(ASN1Encodable[] aSN1EncodableArray, boolean bl2) {
        for (int i2 = 0; i2 != aSN1EncodableArray.length; ++i2) {
            this.a.addElement(aSN1EncodableArray[i2]);
        }
        if (bl2) {
            this.sort();
        }
    }

    public Enumeration getObjects() {
        return this.a.elements();
    }

    public ASN1Encodable getObjectAt(int n2) {
        return (ASN1Encodable)this.a.elementAt(n2);
    }

    public int size() {
        return this.a.size();
    }

    public ASN1Encodable[] toArray() {
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[this.size()];
        for (int i2 = 0; i2 != this.size(); ++i2) {
            aSN1EncodableArray[i2] = this.getObjectAt(i2);
        }
        return aSN1EncodableArray;
    }

    public ASN1SetParser parser() {
        ASN1Set aSN1Set = this;
        return new b(this, aSN1Set);
    }

    @Override
    public int hashCode() {
        Enumeration enumeration = this.getObjects();
        int n2 = this.size();
        while (enumeration.hasMoreElements()) {
            ASN1Encodable aSN1Encodable = this.a(enumeration);
            n2 *= 17;
            n2 ^= aSN1Encodable.hashCode();
        }
        return n2;
    }

    @Override
    ASN1Primitive toDERObject() {
        if (this.b) {
            DERSet dERSet = new DERSet();
            ((ASN1Set)dERSet).a = this.a;
            return dERSet;
        }
        Vector vector = new Vector();
        for (int i2 = 0; i2 != this.a.size(); ++i2) {
            vector.addElement(this.a.elementAt(i2));
        }
        DERSet dERSet = new DERSet();
        ((ASN1Set)dERSet).a = vector;
        dERSet.sort();
        return dERSet;
    }

    @Override
    ASN1Primitive toDLObject() {
        DLSet dLSet = new DLSet();
        ((ASN1Set)dLSet).a = this.a;
        return dLSet;
    }

    @Override
    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Set)) {
            return false;
        }
        ASN1Set aSN1Set = (ASN1Set)aSN1Primitive;
        if (this.size() != aSN1Set.size()) {
            return false;
        }
        Enumeration enumeration = this.getObjects();
        Enumeration enumeration2 = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Primitive aSN1Primitive2;
            ASN1Encodable aSN1Encodable = this.a(enumeration);
            ASN1Encodable aSN1Encodable2 = this.a(enumeration2);
            ASN1Primitive aSN1Primitive3 = aSN1Encodable.toASN1Primitive();
            if (aSN1Primitive3 == (aSN1Primitive2 = aSN1Encodable2.toASN1Primitive()) || aSN1Primitive3.equals(aSN1Primitive2)) continue;
            return false;
        }
        return true;
    }

    private ASN1Encodable a(Enumeration enumeration) {
        ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
        if (aSN1Encodable == null) {
            return DERNull.INSTANCE;
        }
        return aSN1Encodable;
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        int n2 = Math.min(byArray.length, byArray2.length);
        for (int i2 = 0; i2 != n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return (byArray[i2] & 0xFF) < (byArray2[i2] & 0xFF);
        }
        return n2 == byArray.length;
    }

    private byte[] a(ASN1Encodable aSN1Encodable) {
        try {
            return aSN1Encodable.toASN1Primitive().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
    }

    protected void sort() {
        if (!this.b) {
            this.b = true;
            if (this.a.size() > 1) {
                boolean bl2 = true;
                int n2 = this.a.size() - 1;
                while (bl2) {
                    int n3 = 0;
                    byte[] byArray = this.a((ASN1Encodable)this.a.elementAt(0));
                    bl2 = false;
                    for (int i2 = 0; i2 != n2; ++i2) {
                        byte[] byArray2 = this.a((ASN1Encodable)this.a.elementAt(i2 + 1));
                        if (this.a(byArray, byArray2)) {
                            byArray = byArray2;
                            continue;
                        }
                        Object e2 = this.a.elementAt(i2);
                        this.a.setElementAt(this.a.elementAt(i2 + 1), i2);
                        this.a.setElementAt(e2, i2 + 1);
                        bl2 = true;
                        n3 = i2;
                    }
                    n2 = n3;
                }
            }
        }
    }

    @Override
    boolean isConstructed() {
        return true;
    }

    @Override
    abstract void encode(ASN1OutputStream var1) throws IOException;

    public String toString() {
        return this.a.toString();
    }

    @Override
    public Iterator<ASN1Encodable> iterator() {
        return new Arrays.Iterator<ASN1Encodable>(this.toArray());
    }
}

