/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.voms;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.DERIA5String;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Attribute;
import com.aspose.cad.internal.bouncycastle.asn1.x509.IetfAttrSyntax;
import com.aspose.cad.internal.bouncycastle.cert.X509AttributeCertificateHolder;
import java.util.ArrayList;
import java.util.List;

public class VOMSAttribute {
    public static final String VOMS_ATTR_OID = "1.3.6.1.4.1.8005.100.100.4";
    private X509AttributeCertificateHolder a;
    private String b;
    private String c;
    private List d = new ArrayList();
    private List e = new ArrayList();

    public VOMSAttribute(X509AttributeCertificateHolder x509AttributeCertificateHolder) {
        if (x509AttributeCertificateHolder == null) {
            throw new IllegalArgumentException("VOMSAttribute: AttributeCertificate is NULL");
        }
        this.a = x509AttributeCertificateHolder;
        Attribute[] attributeArray = x509AttributeCertificateHolder.getAttributes(new ASN1ObjectIdentifier(VOMS_ATTR_OID));
        if (attributeArray == null) {
            return;
        }
        try {
            for (int i2 = 0; i2 != attributeArray.length; ++i2) {
                IetfAttrSyntax ietfAttrSyntax = IetfAttrSyntax.getInstance(attributeArray[i2].getAttributeValues()[0]);
                String string = ((DERIA5String)ietfAttrSyntax.getPolicyAuthority().getNames()[0].getName()).getString();
                int n2 = string.indexOf("://");
                if (n2 < 0 || n2 == string.length() - 1) {
                    throw new IllegalArgumentException("Bad encoding of VOMS policyAuthority : [" + string + "]");
                }
                this.c = string.substring(0, n2);
                this.b = string.substring(n2 + 3);
                if (ietfAttrSyntax.getValueType() != 1) {
                    throw new IllegalArgumentException("VOMS attribute values are not encoded as octet strings, policyAuthority = " + string);
                }
                ASN1OctetString[] aSN1OctetStringArray = (ASN1OctetString[])ietfAttrSyntax.getValues();
                for (int i3 = 0; i3 != aSN1OctetStringArray.length; ++i3) {
                    String string2 = new String(aSN1OctetStringArray[i3].getOctets());
                    FQAN fQAN = new FQAN(string2);
                    if (this.d.contains(string2) || !string2.startsWith("/" + this.c + "/")) continue;
                    this.d.add(string2);
                    this.e.add(fQAN);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Badly encoded VOMS extension in AC issued by " + x509AttributeCertificateHolder.getIssuer());
        }
    }

    public X509AttributeCertificateHolder getAC() {
        return this.a;
    }

    public List getFullyQualifiedAttributes() {
        return this.d;
    }

    public List getListOfFQAN() {
        return this.e;
    }

    public String getHostPort() {
        return this.b;
    }

    public String getVO() {
        return this.c;
    }

    public String toString() {
        return "VO      :" + this.c + "\nHostPort:" + this.b + "\nFQANs   :" + this.e;
    }

    public class FQAN {
        String fqan;
        String group;
        String role;
        String capability;

        public FQAN(String string) {
            this.fqan = string;
        }

        public FQAN(String string, String string2, String string3) {
            this.group = string;
            this.role = string2;
            this.capability = string3;
        }

        public String getFQAN() {
            if (this.fqan != null) {
                return this.fqan;
            }
            this.fqan = this.group + "/Role=" + (this.role != null ? this.role : "") + (this.capability != null ? "/Capability=" + this.capability : "");
            return this.fqan;
        }

        protected void split() {
            int n2 = this.fqan.length();
            int n3 = this.fqan.indexOf("/Role=");
            if (n3 < 0) {
                return;
            }
            this.group = this.fqan.substring(0, n3);
            int n4 = this.fqan.indexOf("/Capability=", n3 + 6);
            String string = n4 < 0 ? this.fqan.substring(n3 + 6) : this.fqan.substring(n3 + 6, n4);
            this.role = string.length() == 0 ? null : string;
            string = n4 < 0 ? null : this.fqan.substring(n4 + 12);
            this.capability = string == null || string.length() == 0 ? null : string;
        }

        public String getGroup() {
            if (this.group == null && this.fqan != null) {
                this.split();
            }
            return this.group;
        }

        public String getRole() {
            if (this.group == null && this.fqan != null) {
                this.split();
            }
            return this.role;
        }

        public String getCapability() {
            if (this.group == null && this.fqan != null) {
                this.split();
            }
            return this.capability;
        }

        public String toString() {
            return this.getFQAN();
        }
    }
}

