/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jce.provider;

import com.aspose.cad.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.BufferedBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.cad.internal.bouncycastle.crypto.engines.DESEngine;
import com.aspose.cad.internal.bouncycastle.crypto.engines.DESedeEngine;
import com.aspose.cad.internal.bouncycastle.crypto.engines.TwofishEngine;
import com.aspose.cad.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.modes.CFBBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.modes.CTSBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.modes.OFBBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.cad.internal.bouncycastle.crypto.params.RC2Parameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.RC5Parameters;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.aspose.cad.internal.bouncycastle.jce.provider.BrokenPBE;
import com.aspose.cad.internal.bouncycastle.util.Strings;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class BrokenJCEBlockCipher
implements BrokenPBE {
    private Class[] a = new Class[]{IvParameterSpec.class, PBEParameterSpec.class, RC2ParameterSpec.class, RC5ParameterSpec.class};
    private BufferedBlockCipher b;
    private ParametersWithIV c;
    private int d = 2;
    private int e = 1;
    private int f;
    private int g;
    private int h = 0;
    private AlgorithmParameters i = null;

    protected BrokenJCEBlockCipher(BlockCipher blockCipher) {
        this.b = new PaddedBufferedBlockCipher(blockCipher);
    }

    protected BrokenJCEBlockCipher(BlockCipher blockCipher, int n2, int n3, int n4, int n5) {
        this.b = new PaddedBufferedBlockCipher(blockCipher);
        this.d = n2;
        this.e = n3;
        this.f = n4;
        this.g = n5;
    }

    protected int engineGetBlockSize() {
        return this.b.getBlockSize();
    }

    protected byte[] engineGetIV() {
        return this.c != null ? this.c.getIV() : null;
    }

    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length;
    }

    protected int engineGetOutputSize(int n2) {
        return this.b.getOutputSize(n2);
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.i == null && this.c != null) {
            String string = this.b.getUnderlyingCipher().getAlgorithmName();
            if (string.indexOf(47) >= 0) {
                string = string.substring(0, string.indexOf(47));
            }
            try {
                this.i = AlgorithmParameters.getInstance(string, "BC");
                this.i.init(this.c.getIV());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        return this.i;
    }

    protected void engineSetMode(String string) {
        String string2 = Strings.toUpperCase(string);
        if (string2.equals("ECB")) {
            this.h = 0;
            this.b = new PaddedBufferedBlockCipher(this.b.getUnderlyingCipher());
        } else if (string2.equals("CBC")) {
            this.h = this.b.getUnderlyingCipher().getBlockSize();
            this.b = new PaddedBufferedBlockCipher(new CBCBlockCipher(this.b.getUnderlyingCipher()));
        } else if (string2.startsWith("OFB")) {
            this.h = this.b.getUnderlyingCipher().getBlockSize();
            if (string2.length() != 3) {
                int n2 = Integer.parseInt(string2.substring(3));
                this.b = new PaddedBufferedBlockCipher(new OFBBlockCipher(this.b.getUnderlyingCipher(), n2));
            } else {
                this.b = new PaddedBufferedBlockCipher(new OFBBlockCipher(this.b.getUnderlyingCipher(), 8 * this.b.getBlockSize()));
            }
        } else if (string2.startsWith("CFB")) {
            this.h = this.b.getUnderlyingCipher().getBlockSize();
            if (string2.length() != 3) {
                int n3 = Integer.parseInt(string2.substring(3));
                this.b = new PaddedBufferedBlockCipher(new CFBBlockCipher(this.b.getUnderlyingCipher(), n3));
            } else {
                this.b = new PaddedBufferedBlockCipher(new CFBBlockCipher(this.b.getUnderlyingCipher(), 8 * this.b.getBlockSize()));
            }
        } else {
            throw new IllegalArgumentException("can't support mode " + string);
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase(string);
        if (string2.equals("NOPADDING")) {
            this.b = new BufferedBlockCipher(this.b.getUnderlyingCipher());
        } else if (string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING") || string2.equals("ISO10126PADDING")) {
            this.b = new PaddedBufferedBlockCipher(this.b.getUnderlyingCipher());
        } else if (string2.equals("WITHCTS")) {
            this.b = new CTSBlockCipher(this.b.getUnderlyingCipher());
        } else {
            throw new NoSuchPaddingException("Padding " + string + " unknown.");
        }
    }

    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object;
        CipherParameters cipherParameters;
        if (key instanceof BCPBEKey) {
            cipherParameters = BrokenPBE.Util.makePBEParameters((BCPBEKey)key, algorithmParameterSpec, this.d, this.e, this.b.getUnderlyingCipher().getAlgorithmName(), this.f, this.g);
            if (this.g != 0) {
                this.c = (ParametersWithIV)cipherParameters;
            }
        } else if (algorithmParameterSpec == null) {
            cipherParameters = new KeyParameter(key.getEncoded());
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            if (this.h != 0) {
                cipherParameters = new ParametersWithIV(new KeyParameter(key.getEncoded()), ((IvParameterSpec)algorithmParameterSpec).getIV());
                this.c = (ParametersWithIV)cipherParameters;
            } else {
                cipherParameters = new KeyParameter(key.getEncoded());
            }
        } else if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            object = (RC2ParameterSpec)algorithmParameterSpec;
            cipherParameters = new RC2Parameters(key.getEncoded(), ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits());
            if (((RC2ParameterSpec)object).getIV() != null && this.h != 0) {
                cipherParameters = new ParametersWithIV(cipherParameters, ((RC2ParameterSpec)object).getIV());
                this.c = (ParametersWithIV)cipherParameters;
            }
        } else if (algorithmParameterSpec instanceof RC5ParameterSpec) {
            object = (RC5ParameterSpec)algorithmParameterSpec;
            cipherParameters = new RC5Parameters(key.getEncoded(), ((RC5ParameterSpec)algorithmParameterSpec).getRounds());
            if (((RC5ParameterSpec)object).getWordSize() != 32) {
                throw new IllegalArgumentException("can only accept RC5 word size 32 (at the moment...)");
            }
            if (((RC5ParameterSpec)object).getIV() != null && this.h != 0) {
                cipherParameters = new ParametersWithIV(cipherParameters, ((RC5ParameterSpec)object).getIV());
                this.c = (ParametersWithIV)cipherParameters;
            }
        } else {
            throw new InvalidAlgorithmParameterException("unknown parameter type.");
        }
        if (this.h != 0 && !(cipherParameters instanceof ParametersWithIV)) {
            if (secureRandom == null) {
                secureRandom = new SecureRandom();
            }
            if (n2 == 1 || n2 == 3) {
                object = new byte[this.h];
                secureRandom.nextBytes((byte[])object);
                cipherParameters = new ParametersWithIV(cipherParameters, (byte[])object);
                this.c = (ParametersWithIV)cipherParameters;
            } else {
                throw new InvalidAlgorithmParameterException("no IV set when one expected");
            }
        }
        switch (n2) {
            case 1: 
            case 3: {
                this.b.init(true, cipherParameters);
                break;
            }
            case 2: 
            case 4: {
                this.b.init(false, cipherParameters);
                break;
            }
            default: {
                System.out.println("eeek!");
            }
        }
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            for (int i2 = 0; i2 != this.a.length; ++i2) {
                try {
                    algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(this.a[i2]);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.i = algorithmParameters;
        this.engineInit(n2, key, algorithmParameterSpec, secureRandom);
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException(invalidAlgorithmParameterException.getMessage());
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        int n4 = this.b.getUpdateOutputSize(n3);
        if (n4 > 0) {
            byte[] byArray2 = new byte[n4];
            this.b.processBytes(byArray, n2, n3, byArray2, 0);
            return byArray2;
        }
        this.b.processBytes(byArray, n2, n3, null, 0);
        return null;
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        return this.b.processBytes(byArray, n2, n3, byArray2, n4);
    }

    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        int n4 = 0;
        byte[] byArray2 = new byte[this.engineGetOutputSize(n3)];
        if (n3 != 0) {
            n4 = this.b.processBytes(byArray, n2, n3, byArray2, 0);
        }
        try {
            n4 += this.b.doFinal(byArray2, n4);
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalBlockSizeException(dataLengthException.getMessage());
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new BadPaddingException(invalidCipherTextException.getMessage());
        }
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray3, 0, n4);
        return byArray3;
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalBlockSizeException, BadPaddingException {
        int n5 = 0;
        if (n3 != 0) {
            n5 = this.b.processBytes(byArray, n2, n3, byArray2, n4);
        }
        try {
            return n5 + this.b.doFinal(byArray2, n4 + n5);
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalBlockSizeException(dataLengthException.getMessage());
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new BadPaddingException(invalidCipherTextException.getMessage());
        }
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IllegalBlockSizeException(badPaddingException.getMessage());
        }
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws InvalidKeyException {
        byte[] byArray2 = null;
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        if (n2 == 3) {
            return new SecretKeySpec(byArray2, string);
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string, "BC");
            if (n2 == 1) {
                return keyFactory.generatePublic(new X509EncodedKeySpec(byArray2));
            }
            if (n2 == 2) {
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InvalidKeyException("Unknown key type " + noSuchProviderException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("Unknown key type " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Unknown key type " + invalidKeySpecException.getMessage());
        }
        throw new InvalidKeyException("Unknown key type " + n2);
    }

    public static class BrokePBEWithMD5AndDES
    extends BrokenJCEBlockCipher {
        public BrokePBEWithMD5AndDES() {
            super(new CBCBlockCipher(new DESEngine()), 0, 0, 64, 64);
        }
    }

    public static class BrokePBEWithSHA1AndDES
    extends BrokenJCEBlockCipher {
        public BrokePBEWithSHA1AndDES() {
            super(new CBCBlockCipher(new DESEngine()), 0, 1, 64, 64);
        }
    }

    public static class BrokePBEWithSHAAndDES2Key
    extends BrokenJCEBlockCipher {
        public BrokePBEWithSHAAndDES2Key() {
            super(new CBCBlockCipher(new DESedeEngine()), 2, 1, 128, 64);
        }
    }

    public static class BrokePBEWithSHAAndDES3Key
    extends BrokenJCEBlockCipher {
        public BrokePBEWithSHAAndDES3Key() {
            super(new CBCBlockCipher(new DESedeEngine()), 2, 1, 192, 64);
        }
    }

    public static class OldPBEWithSHAAndDES3Key
    extends BrokenJCEBlockCipher {
        public OldPBEWithSHAAndDES3Key() {
            super(new CBCBlockCipher(new DESedeEngine()), 3, 1, 192, 64);
        }
    }

    public static class OldPBEWithSHAAndTwofish
    extends BrokenJCEBlockCipher {
        public OldPBEWithSHAAndTwofish() {
            super(new CBCBlockCipher(new TwofishEngine()), 3, 1, 256, 128);
        }
    }
}

