/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.keystore.pkcs12;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.cad.internal.bouncycastle.asn1.BEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.BEROutputStream;
import com.aspose.cad.internal.bouncycastle.asn1.DERBMPString;
import com.aspose.cad.internal.bouncycastle.asn1.DERNull;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.DEROutputStream;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERSet;
import com.aspose.cad.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import com.aspose.cad.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.CertBag;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.ContentInfo;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.EncryptedData;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.MacData;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PBES2Parameters;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.Pfx;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.SafeBag;
import com.aspose.cad.internal.bouncycastle.asn1.util.ASN1Dump;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.DigestInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.crypto.util.DigestFactory;
import com.aspose.cad.internal.bouncycastle.jcajce.PKCS12Key;
import com.aspose.cad.internal.bouncycastle.jcajce.PKCS12StoreParameter;
import com.aspose.cad.internal.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import com.aspose.cad.internal.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import com.aspose.cad.internal.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jce.interfaces.BCKeyStore;
import com.aspose.cad.internal.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.aspose.cad.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import com.aspose.cad.internal.bouncycastle.jce.provider.JDKPKCS12StoreParameter;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.Integers;
import com.aspose.cad.internal.bouncycastle.util.Properties;
import com.aspose.cad.internal.bouncycastle.util.Strings;
import com.aspose.cad.internal.bouncycastle.util.encoders.Hex;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS12KeyStoreSpi
extends KeyStoreSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
BCKeyStore {
    static final String PKCS12_MAX_IT_COUNT_PROPERTY = "com.aspose.cad.internal.bouncycastle.pkcs12.max_it_count";
    private final JcaJceHelper a = new BCJcaJceHelper();
    private static final int b = 20;
    private static final int c = 51200;
    private static final b d = new b();
    private c e = new c(null);
    private Hashtable f = new Hashtable();
    private c g = new c(null);
    private Hashtable h = new Hashtable();
    private Hashtable i = new Hashtable();
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected SecureRandom random = new SecureRandom();
    private CertificateFactory j;
    private ASN1ObjectIdentifier k;
    private ASN1ObjectIdentifier l;
    private AlgorithmIdentifier m = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE);
    private int n = 102400;
    private int o = 20;
    private static Provider p = null;

    public PKCS12KeyStoreSpi(Provider provider, ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier2) {
        this.k = aSN1ObjectIdentifier;
        this.l = aSN1ObjectIdentifier2;
        try {
            this.j = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("can't create cert factory - " + exception.toString());
        }
    }

    private SubjectKeyIdentifier a(PublicKey publicKey) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            return new SubjectKeyIdentifier(PKCS12KeyStoreSpi.a(subjectPublicKeyInfo));
        }
        catch (Exception exception) {
            throw new RuntimeException("error creating key");
        }
    }

    private static byte[] a(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Digest digest = DigestFactory.createSHA1();
        byte[] byArray = new byte[digest.getDigestSize()];
        byte[] byArray2 = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        digest.update(byArray2, 0, byArray2.length);
        digest.doFinal(byArray, 0);
        return byArray;
    }

    @Override
    public void setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    public Enumeration engineAliases() {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Enumeration enumeration = this.g.a();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.e.a();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.keys();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.g.b(string) != null || this.e.b(string) != null;
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Key key = (Key)this.e.a(string);
        Certificate certificate = (Certificate)this.g.a(string);
        if (certificate != null) {
            this.h.remove(new a(certificate.getPublicKey()));
        }
        if (key != null) {
            String string2 = (String)this.f.remove(string);
            if (string2 != null) {
                certificate = (Certificate)this.i.remove(string2);
            }
            if (certificate != null) {
                this.h.remove(new a(certificate.getPublicKey()));
            }
        }
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getCertificate.");
        }
        Certificate certificate = (Certificate)this.g.b(string);
        if (certificate == null) {
            String string2 = (String)this.f.get(string);
            certificate = string2 != null ? (Certificate)this.i.get(string2) : (Certificate)this.i.get(string);
        }
        return certificate;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        String string;
        Certificate certificate2;
        Enumeration enumeration = this.g.b();
        Enumeration enumeration2 = this.g.a();
        while (enumeration.hasMoreElements()) {
            certificate2 = (Certificate)enumeration.nextElement();
            string = (String)enumeration2.nextElement();
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        enumeration = this.i.elements();
        enumeration2 = this.i.keys();
        while (enumeration.hasMoreElements()) {
            certificate2 = (Certificate)enumeration.nextElement();
            string = (String)enumeration2.nextElement();
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getCertificateChain.");
        }
        if (!this.engineIsKeyEntry(string)) {
            return null;
        }
        Certificate certificate = this.engineGetCertificate(string);
        if (certificate != null) {
            Certificate[] certificateArray;
            Vector<Certificate> vector = new Vector<Certificate>();
            while (certificate != null) {
                Object object;
                Object object2;
                Object object3;
                certificateArray = (Certificate[])certificate;
                Certificate certificate2 = null;
                byte[] byArray = certificateArray.getExtensionValue(Extension.authorityKeyIdentifier.getId());
                if (byArray != null) {
                    try {
                        object3 = new ASN1InputStream(byArray);
                        object2 = ((ASN1OctetString)((ASN1InputStream)object3).readObject()).getOctets();
                        object3 = new ASN1InputStream((byte[])object2);
                        object = AuthorityKeyIdentifier.getInstance(((ASN1InputStream)object3).readObject());
                        if (((AuthorityKeyIdentifier)object).getKeyIdentifier() != null) {
                            certificate2 = (Certificate)this.h.get(new a(((AuthorityKeyIdentifier)object).getKeyIdentifier()));
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException.toString());
                    }
                }
                if (certificate2 == null && !(object3 = certificateArray.getIssuerDN()).equals(object2 = certificateArray.getSubjectDN())) {
                    object = this.h.keys();
                    while (object.hasMoreElements()) {
                        X509Certificate x509Certificate = (X509Certificate)this.h.get(object.nextElement());
                        Principal principal = x509Certificate.getSubjectDN();
                        if (!principal.equals(object3)) continue;
                        try {
                            certificateArray.verify(x509Certificate.getPublicKey());
                            certificate2 = x509Certificate;
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                if (vector.contains(certificate)) {
                    certificate = null;
                    continue;
                }
                vector.addElement(certificate);
                if (certificate2 != certificate) {
                    certificate = certificate2;
                    continue;
                }
                certificate = null;
            }
            certificateArray = new Certificate[vector.size()];
            for (int i2 = 0; i2 != certificateArray.length; ++i2) {
                certificateArray[i2] = (Certificate)vector.elementAt(i2);
            }
            return certificateArray;
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        if (string == null) {
            throw new NullPointerException("alias == null");
        }
        if (this.e.b(string) == null && this.g.b(string) == null) {
            return null;
        }
        return new Date();
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getKey.");
        }
        return (Key)this.e.b(string);
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        return this.g.b(string) != null && this.e.b(string) == null;
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        return this.e.b(string) != null;
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.e.b(string) != null) {
            throw new KeyStoreException("There is a key entry with the name " + string + ".");
        }
        this.g.a(string, certificate);
        this.h.put(new a(certificate.getPublicKey()), certificate);
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new RuntimeException("operation not supported");
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("PKCS12 does not support non-PrivateKeys");
        }
        if (key instanceof PrivateKey && certificateArray == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        if (this.e.b(string) != null) {
            this.engineDeleteEntry(string);
        }
        this.e.a(string, key);
        if (certificateArray != null) {
            this.g.a(string, certificateArray[0]);
            for (int i2 = 0; i2 != certificateArray.length; ++i2) {
                this.h.put(new a(certificateArray[i2].getPublicKey()), certificateArray[i2]);
            }
        }
    }

    @Override
    public int engineSize() {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Enumeration enumeration = this.g.a();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.e.a();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.size();
    }

    protected PrivateKey unwrapKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, char[] cArray, boolean bl2) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        try {
            if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), this.a(pKCS12PBEParams.getIterations()));
                Cipher cipher = this.a.createCipher(aSN1ObjectIdentifier.getId());
                PKCS12Key pKCS12Key = new PKCS12Key(cArray, bl2);
                cipher.init(4, (Key)pKCS12Key, pBEParameterSpec);
                return (PrivateKey)cipher.unwrap(byArray, "", 2);
            }
            if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_PBES2)) {
                Cipher cipher = this.a(4, cArray, algorithmIdentifier);
                return (PrivateKey)cipher.unwrap(byArray, "", 2);
            }
        }
        catch (Exception exception) {
            throw new IOException("exception unwrapping private key - " + exception.toString());
        }
        throw new IOException("exception unwrapping private key - cannot recognise: " + aSN1ObjectIdentifier);
    }

    protected byte[] wrapKey(String string, Key key, PKCS12PBEParams pKCS12PBEParams, char[] cArray) throws IOException {
        byte[] byArray;
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        try {
            SecretKeyFactory secretKeyFactory = this.a.createSecretKeyFactory(string);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
            Cipher cipher = this.a.createCipher(string);
            cipher.init(3, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
            byArray = cipher.wrap(key);
        }
        catch (Exception exception) {
            throw new IOException("exception encrypting data - " + exception.toString());
        }
        return byArray;
    }

    protected byte[] cryptData(boolean bl2, AlgorithmIdentifier algorithmIdentifier, char[] cArray, boolean bl3, byte[] byArray) throws IOException {
        int n2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        int n3 = n2 = bl2 ? 1 : 2;
        if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
            PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
            try {
                PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
                PKCS12Key pKCS12Key = new PKCS12Key(cArray, bl3);
                Cipher cipher = this.a.createCipher(aSN1ObjectIdentifier.getId());
                cipher.init(n2, (Key)pKCS12Key, pBEParameterSpec);
                return cipher.doFinal(byArray);
            }
            catch (Exception exception) {
                throw new IOException("exception decrypting data - " + exception.toString());
            }
        }
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_PBES2)) {
            try {
                Cipher cipher = this.a(n2, cArray, algorithmIdentifier);
                return cipher.doFinal(byArray);
            }
            catch (Exception exception) {
                throw new IOException("exception decrypting data - " + exception.toString());
            }
        }
        throw new IOException("unknown PBE algorithm: " + aSN1ObjectIdentifier);
    }

    private Cipher a(int n2, char[] cArray, AlgorithmIdentifier algorithmIdentifier) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchProviderException {
        PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
        PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(pBES2Parameters.getKeyDerivationFunc().getParameters());
        AlgorithmIdentifier algorithmIdentifier2 = AlgorithmIdentifier.getInstance(pBES2Parameters.getEncryptionScheme());
        SecretKeyFactory secretKeyFactory = this.a.createSecretKeyFactory(pBES2Parameters.getKeyDerivationFunc().getAlgorithm().getId());
        SecretKey secretKey = pBKDF2Params.isDefaultPrf() ? secretKeyFactory.generateSecret(new PBEKeySpec(cArray, pBKDF2Params.getSalt(), this.a(pBKDF2Params.getIterationCount()), d.a(algorithmIdentifier2))) : secretKeyFactory.generateSecret(new PBKDF2KeySpec(cArray, pBKDF2Params.getSalt(), this.a(pBKDF2Params.getIterationCount()), d.a(algorithmIdentifier2), pBKDF2Params.getPrf()));
        Cipher cipher = Cipher.getInstance(pBES2Parameters.getEncryptionScheme().getAlgorithm().getId());
        ASN1Encodable aSN1Encodable = pBES2Parameters.getEncryptionScheme().getParameters();
        if (aSN1Encodable instanceof ASN1OctetString) {
            cipher.init(n2, (Key)secretKey, new IvParameterSpec(ASN1OctetString.getInstance(aSN1Encodable).getOctets()));
        } else {
            GOST28147Parameters gOST28147Parameters = GOST28147Parameters.getInstance(aSN1Encodable);
            cipher.init(n2, (Key)secretKey, new GOST28147ParameterSpec(gOST28147Parameters.getEncryptionParamSet(), gOST28147Parameters.getIV()));
        }
        return cipher;
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
        ASN1Encodable aSN1Encodable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ASN1Object aSN1Object;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        ASN1Object aSN1Object2;
        Pfx pfx;
        if (inputStream == null) {
            return;
        }
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(10);
        int n2 = bufferedInputStream.read();
        if (n2 != 48) {
            throw new IOException("stream does not represent a PKCS12 key store");
        }
        bufferedInputStream.reset();
        ASN1InputStream aSN1InputStream = new ASN1InputStream(bufferedInputStream);
        try {
            pfx = Pfx.getInstance(aSN1InputStream.readObject());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        ContentInfo contentInfo = pfx.getAuthSafe();
        Vector<ASN1Object> vector = new Vector<ASN1Object>();
        boolean bl2 = false;
        boolean bl3 = false;
        if (pfx.getMacData() != null) {
            aSN1Object2 = pfx.getMacData();
            object8 = ((MacData)aSN1Object2).getMac();
            this.m = ((DigestInfo)object8).getAlgorithmId();
            byte[] byArray = ((MacData)aSN1Object2).getSalt();
            this.n = this.a(((MacData)aSN1Object2).getIterationCount());
            this.o = byArray.length;
            object7 = ((ASN1OctetString)contentInfo.getContent()).getOctets();
            try {
                object6 = this.a(this.m.getAlgorithm(), byArray, this.n, cArray, false, (byte[])object7);
                object5 = ((DigestInfo)object8).getDigest();
                if (!Arrays.constantTimeAreEqual(object6, (byte[])object5)) {
                    if (cArray.length > 0) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    object6 = this.a(this.m.getAlgorithm(), byArray, this.n, cArray, true, (byte[])object7);
                    if (!Arrays.constantTimeAreEqual(object6, (byte[])object5)) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    bl3 = true;
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("error constructing MAC: " + exception.toString());
            }
        }
        this.e = new c(null);
        this.f = new Hashtable();
        if (contentInfo.getContentType().equals(data)) {
            aSN1InputStream = new ASN1InputStream(((ASN1OctetString)contentInfo.getContent()).getOctets());
            aSN1Object2 = AuthenticatedSafe.getInstance(aSN1InputStream.readObject());
            object8 = ((AuthenticatedSafe)aSN1Object2).getContentInfo();
            for (int i2 = 0; i2 != ((ContentInfo[])object8).length; ++i2) {
                ASN1Encodable aSN1Encodable2;
                Object object9;
                ASN1Primitive aSN1Primitive;
                Object object10;
                Object object11;
                if (object8[i2].getContentType().equals(data)) {
                    object7 = new ASN1InputStream(((ASN1OctetString)((ContentInfo)object8[i2]).getContent()).getOctets());
                    object6 = (ASN1Sequence)((ASN1InputStream)object7).readObject();
                    for (int i3 = 0; i3 != object6.size(); ++i3) {
                        SafeBag safeBag = SafeBag.getInstance(object6.getObjectAt(i3));
                        if (safeBag.getBagId().equals(pkcs8ShroudedKeyBag)) {
                            aSN1Object = EncryptedPrivateKeyInfo.getInstance(safeBag.getBagValue());
                            object4 = this.unwrapKey(((EncryptedPrivateKeyInfo)aSN1Object).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)aSN1Object).getEncryptedData(), cArray, bl3);
                            object3 = null;
                            object2 = null;
                            if (safeBag.getBagAttributes() != null) {
                                object = safeBag.getBagAttributes().getObjects();
                                while (object.hasMoreElements()) {
                                    aSN1Encodable = (ASN1Sequence)object.nextElement();
                                    object11 = (ASN1ObjectIdentifier)((ASN1Sequence)aSN1Encodable).getObjectAt(0);
                                    object10 = (ASN1Set)((ASN1Sequence)aSN1Encodable).getObjectAt(1);
                                    aSN1Primitive = null;
                                    if (((ASN1Set)object10).size() > 0) {
                                        aSN1Primitive = (ASN1Primitive)((ASN1Set)object10).getObjectAt(0);
                                        if (object4 instanceof PKCS12BagAttributeCarrier) {
                                            object9 = (PKCS12BagAttributeCarrier)object4;
                                            aSN1Encodable2 = object9.getBagAttribute((ASN1ObjectIdentifier)object11);
                                            if (aSN1Encodable2 != null) {
                                                if (!aSN1Encodable2.toASN1Primitive().equals(aSN1Primitive)) {
                                                    throw new IOException("attempt to add existing attribute with different value");
                                                }
                                            } else {
                                                object9.setBagAttribute((ASN1ObjectIdentifier)object11, aSN1Primitive);
                                            }
                                        }
                                    }
                                    if (((ASN1Primitive)object11).equals(pkcs_9_at_friendlyName)) {
                                        object3 = ((DERBMPString)aSN1Primitive).getString();
                                        this.e.a((String)object3, object4);
                                        continue;
                                    }
                                    if (!((ASN1Primitive)object11).equals(pkcs_9_at_localKeyId)) continue;
                                    object2 = (ASN1OctetString)aSN1Primitive;
                                }
                            }
                            if (object2 != null) {
                                object = new String(Hex.encode(((ASN1OctetString)object2).getOctets()));
                                if (object3 == null) {
                                    this.e.a((String)object, object4);
                                    continue;
                                }
                                this.f.put(object3, object);
                                continue;
                            }
                            bl2 = true;
                            this.e.a("unmarked", object4);
                            continue;
                        }
                        if (safeBag.getBagId().equals(certBag)) {
                            vector.addElement(safeBag);
                            continue;
                        }
                        System.out.println("extra in data " + safeBag.getBagId());
                        System.out.println(ASN1Dump.dumpAsString(safeBag));
                    }
                    continue;
                }
                if (((ContentInfo)object8[i2]).getContentType().equals(encryptedData)) {
                    object7 = EncryptedData.getInstance(((ContentInfo)object8[i2]).getContent());
                    object6 = this.cryptData(false, ((EncryptedData)object7).getEncryptionAlgorithm(), cArray, bl3, ((EncryptedData)object7).getContent().getOctets());
                    object5 = (ASN1Sequence)ASN1Primitive.fromByteArray(object6);
                    for (int i4 = 0; i4 != ((ASN1Sequence)object5).size(); ++i4) {
                        ASN1Encodable aSN1Encodable3;
                        aSN1Object = SafeBag.getInstance(((ASN1Sequence)object5).getObjectAt(i4));
                        if (((SafeBag)aSN1Object).getBagId().equals(certBag)) {
                            vector.addElement(aSN1Object);
                            continue;
                        }
                        if (((SafeBag)aSN1Object).getBagId().equals(pkcs8ShroudedKeyBag)) {
                            object4 = EncryptedPrivateKeyInfo.getInstance(((SafeBag)aSN1Object).getBagValue());
                            object3 = this.unwrapKey(((EncryptedPrivateKeyInfo)object4).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)object4).getEncryptedData(), cArray, bl3);
                            object2 = (PKCS12BagAttributeCarrier)object3;
                            object = null;
                            aSN1Encodable = null;
                            object11 = ((SafeBag)aSN1Object).getBagAttributes().getObjects();
                            while (object11.hasMoreElements()) {
                                object10 = (ASN1Sequence)object11.nextElement();
                                aSN1Primitive = (ASN1ObjectIdentifier)((ASN1Sequence)object10).getObjectAt(0);
                                object9 = (ASN1Set)((ASN1Sequence)object10).getObjectAt(1);
                                aSN1Encodable2 = null;
                                if (((ASN1Set)object9).size() > 0) {
                                    aSN1Encodable2 = (ASN1Primitive)((ASN1Set)object9).getObjectAt(0);
                                    aSN1Encodable3 = object2.getBagAttribute((ASN1ObjectIdentifier)aSN1Primitive);
                                    if (aSN1Encodable3 != null) {
                                        if (!aSN1Encodable3.toASN1Primitive().equals(aSN1Encodable2)) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                    } else {
                                        object2.setBagAttribute((ASN1ObjectIdentifier)aSN1Primitive, aSN1Encodable2);
                                    }
                                }
                                if (aSN1Primitive.equals(pkcs_9_at_friendlyName)) {
                                    object = ((DERBMPString)aSN1Encodable2).getString();
                                    this.e.a((String)object, object3);
                                    continue;
                                }
                                if (!aSN1Primitive.equals(pkcs_9_at_localKeyId)) continue;
                                aSN1Encodable = (ASN1OctetString)aSN1Encodable2;
                            }
                            object10 = new String(Hex.encode(((ASN1OctetString)aSN1Encodable).getOctets()));
                            if (object == null) {
                                this.e.a((String)object10, object3);
                                continue;
                            }
                            this.f.put(object, object10);
                            continue;
                        }
                        if (((SafeBag)aSN1Object).getBagId().equals(keyBag)) {
                            object4 = PrivateKeyInfo.getInstance(((SafeBag)aSN1Object).getBagValue());
                            object3 = BouncyCastleProvider.getPrivateKey((PrivateKeyInfo)object4);
                            object2 = (PKCS12BagAttributeCarrier)object3;
                            object = null;
                            aSN1Encodable = null;
                            object11 = ((SafeBag)aSN1Object).getBagAttributes().getObjects();
                            while (object11.hasMoreElements()) {
                                object10 = ASN1Sequence.getInstance(object11.nextElement());
                                aSN1Primitive = ASN1ObjectIdentifier.getInstance(((ASN1Sequence)object10).getObjectAt(0));
                                object9 = ASN1Set.getInstance(((ASN1Sequence)object10).getObjectAt(1));
                                aSN1Encodable2 = null;
                                if (((ASN1Set)object9).size() <= 0) continue;
                                aSN1Encodable2 = (ASN1Primitive)((ASN1Set)object9).getObjectAt(0);
                                aSN1Encodable3 = object2.getBagAttribute((ASN1ObjectIdentifier)aSN1Primitive);
                                if (aSN1Encodable3 != null) {
                                    if (!aSN1Encodable3.toASN1Primitive().equals(aSN1Encodable2)) {
                                        throw new IOException("attempt to add existing attribute with different value");
                                    }
                                } else {
                                    object2.setBagAttribute((ASN1ObjectIdentifier)aSN1Primitive, aSN1Encodable2);
                                }
                                if (aSN1Primitive.equals(pkcs_9_at_friendlyName)) {
                                    object = ((DERBMPString)aSN1Encodable2).getString();
                                    this.e.a((String)object, object3);
                                    continue;
                                }
                                if (!aSN1Primitive.equals(pkcs_9_at_localKeyId)) continue;
                                aSN1Encodable = (ASN1OctetString)aSN1Encodable2;
                            }
                            object10 = new String(Hex.encode(((ASN1OctetString)aSN1Encodable).getOctets()));
                            if (object == null) {
                                this.e.a((String)object10, object3);
                                continue;
                            }
                            this.f.put(object, object10);
                            continue;
                        }
                        System.out.println("extra in encryptedData " + ((SafeBag)aSN1Object).getBagId());
                        System.out.println(ASN1Dump.dumpAsString(aSN1Object));
                    }
                    continue;
                }
                System.out.println("extra " + ((ContentInfo)object8[i2]).getContentType().getId());
                System.out.println("extra " + ASN1Dump.dumpAsString(((ContentInfo)object8[i2]).getContent()));
            }
        }
        this.g = new c(null);
        this.h = new Hashtable();
        this.i = new Hashtable();
        for (int i5 = 0; i5 != vector.size(); ++i5) {
            Object object12;
            object8 = (SafeBag)vector.elementAt(i5);
            CertBag certBag = CertBag.getInstance(((SafeBag)object8).getBagValue());
            if (!certBag.getCertId().equals(x509Certificate)) {
                throw new RuntimeException("Unsupported certificate type: " + certBag.getCertId());
            }
            try {
                object6 = new ByteArrayInputStream(((ASN1OctetString)certBag.getCertValue()).getOctets());
                object7 = this.j.generateCertificate((InputStream)object6);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
            object6 = null;
            object5 = null;
            if (((SafeBag)object8).getBagAttributes() != null) {
                object12 = ((SafeBag)object8).getBagAttributes().getObjects();
                while (object12.hasMoreElements()) {
                    aSN1Object = ASN1Sequence.getInstance(object12.nextElement());
                    object4 = ASN1ObjectIdentifier.getInstance(((ASN1Sequence)aSN1Object).getObjectAt(0));
                    object3 = ASN1Set.getInstance(((ASN1Sequence)aSN1Object).getObjectAt(1));
                    if (((ASN1Set)object3).size() <= 0) continue;
                    object2 = (ASN1Primitive)((ASN1Set)object3).getObjectAt(0);
                    object = null;
                    if (object7 instanceof PKCS12BagAttributeCarrier) {
                        object = (PKCS12BagAttributeCarrier)object7;
                        aSN1Encodable = object.getBagAttribute((ASN1ObjectIdentifier)object4);
                        if (aSN1Encodable != null) {
                            if (!aSN1Encodable.toASN1Primitive().equals(object2)) {
                                throw new IOException("attempt to add existing attribute with different value");
                            }
                        } else {
                            object.setBagAttribute((ASN1ObjectIdentifier)object4, (ASN1Encodable)object2);
                        }
                    }
                    if (((ASN1Primitive)object4).equals(pkcs_9_at_friendlyName)) {
                        object5 = ((DERBMPString)object2).getString();
                        continue;
                    }
                    if (!((ASN1Primitive)object4).equals(pkcs_9_at_localKeyId)) continue;
                    object6 = (ASN1OctetString)object2;
                }
            }
            this.h.put(new a(((Certificate)object7).getPublicKey()), object7);
            if (bl2) {
                if (!this.i.isEmpty()) continue;
                object12 = new String(Hex.encode(this.a(((Certificate)object7).getPublicKey()).getKeyIdentifier()));
                this.i.put(object12, object7);
                this.e.a((String)object12, this.e.a("unmarked"));
                continue;
            }
            if (object6 != null) {
                object12 = new String(Hex.encode(object6.getOctets()));
                this.i.put(object12, object7);
            }
            if (object5 == null) continue;
            this.g.a((String)object5, object7);
        }
    }

    private int a(BigInteger bigInteger) {
        int n2 = bigInteger.intValue();
        if (n2 < 0) {
            throw new IllegalStateException("negative iteration count found");
        }
        BigInteger bigInteger2 = Properties.asBigInteger(PKCS12_MAX_IT_COUNT_PROPERTY);
        if (bigInteger2 != null && bigInteger2.intValue() < n2) {
            throw new IllegalStateException("iteration count " + n2 + " greater than " + bigInteger2.intValue());
        }
        return n2;
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        char[] cArray;
        if (loadStoreParameter == null) {
            throw new IllegalArgumentException("'param' arg cannot be null");
        }
        if (!(loadStoreParameter instanceof PKCS12StoreParameter) && !(loadStoreParameter instanceof JDKPKCS12StoreParameter)) {
            throw new IllegalArgumentException("No support for 'param' of type " + loadStoreParameter.getClass().getName());
        }
        PKCS12StoreParameter pKCS12StoreParameter = loadStoreParameter instanceof PKCS12StoreParameter ? (PKCS12StoreParameter)loadStoreParameter : new PKCS12StoreParameter(((JDKPKCS12StoreParameter)loadStoreParameter).getOutputStream(), loadStoreParameter.getProtectionParameter(), ((JDKPKCS12StoreParameter)loadStoreParameter).isUseDEREncoding());
        KeyStore.ProtectionParameter protectionParameter = loadStoreParameter.getProtectionParameter();
        if (protectionParameter == null) {
            cArray = null;
        } else if (protectionParameter instanceof KeyStore.PasswordProtection) {
            cArray = ((KeyStore.PasswordProtection)protectionParameter).getPassword();
        } else {
            throw new IllegalArgumentException("No support for protection parameter of type " + protectionParameter.getClass().getName());
        }
        this.a(pKCS12StoreParameter.getOutputStream(), cArray, pKCS12StoreParameter.isForDEREncoding());
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException {
        this.a(outputStream, cArray, false);
    }

    private void a(OutputStream outputStream, char[] cArray, boolean bl2) throws IOException {
        MacData macData;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        ContentInfo[] contentInfoArray;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        AlgorithmIdentifier algorithmIdentifier;
        Object object11;
        Object object12;
        Object object13;
        Object object14;
        byte[] byArray;
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = this.e.a();
        while (enumeration.hasMoreElements()) {
            Object object15;
            byArray = new byte[20];
            this.random.nextBytes(byArray);
            object14 = (String)enumeration.nextElement();
            object13 = (PrivateKey)this.e.b((String)object14);
            object12 = new PKCS12PBEParams(byArray, 51200);
            object11 = this.wrapKey(this.k.getId(), (Key)object13, (PKCS12PBEParams)object12, cArray);
            algorithmIdentifier = new AlgorithmIdentifier(this.k, ((PKCS12PBEParams)object12).toASN1Primitive());
            object10 = new EncryptedPrivateKeyInfo(algorithmIdentifier, (byte[])object11);
            boolean bl3 = false;
            object9 = new ASN1EncodableVector();
            if (object13 instanceof PKCS12BagAttributeCarrier) {
                object8 = (PKCS12BagAttributeCarrier)object13;
                object15 = (DERBMPString)object8.getBagAttribute(pkcs_9_at_friendlyName);
                if (object15 == null || !((DERBMPString)object15).getString().equals(object14)) {
                    object8.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString((String)object14));
                }
                if (object8.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                    object7 = this.engineGetCertificate((String)object14);
                    object8.setBagAttribute(pkcs_9_at_localKeyId, this.a(((Certificate)object7).getPublicKey()));
                }
                object7 = object8.getBagAttributeKeys();
                while (object7.hasMoreElements()) {
                    contentInfoArray = (ASN1ObjectIdentifier)object7.nextElement();
                    object6 = new ASN1EncodableVector();
                    ((ASN1EncodableVector)object6).add((ASN1Encodable)contentInfoArray);
                    ((ASN1EncodableVector)object6).add(new DERSet(object8.getBagAttribute((ASN1ObjectIdentifier)contentInfoArray)));
                    bl3 = true;
                    ((ASN1EncodableVector)object9).add(new DERSequence((ASN1EncodableVector)object6));
                }
            }
            if (!bl3) {
                object8 = new ASN1EncodableVector();
                object15 = this.engineGetCertificate((String)object14);
                ((ASN1EncodableVector)object8).add(pkcs_9_at_localKeyId);
                ((ASN1EncodableVector)object8).add(new DERSet(this.a(((Certificate)object15).getPublicKey())));
                ((ASN1EncodableVector)object9).add(new DERSequence((ASN1EncodableVector)object8));
                object8 = new ASN1EncodableVector();
                ((ASN1EncodableVector)object8).add(pkcs_9_at_friendlyName);
                ((ASN1EncodableVector)object8).add(new DERSet(new DERBMPString((String)object14)));
                ((ASN1EncodableVector)object9).add(new DERSequence((ASN1EncodableVector)object8));
            }
            object8 = new SafeBag(pkcs8ShroudedKeyBag, ((EncryptedPrivateKeyInfo)object10).toASN1Primitive(), new DERSet((ASN1EncodableVector)object9));
            aSN1EncodableVector.add((ASN1Encodable)object8);
        }
        byArray = new DERSequence(aSN1EncodableVector).getEncoded("DER");
        object14 = new BEROctetString(byArray);
        object13 = new byte[20];
        this.random.nextBytes((byte[])object13);
        object12 = new ASN1EncodableVector();
        object11 = new PKCS12PBEParams((byte[])object13, 51200);
        algorithmIdentifier = new AlgorithmIdentifier(this.l, ((PKCS12PBEParams)object11).toASN1Primitive());
        object10 = new Hashtable();
        Enumeration enumeration2 = this.e.a();
        while (enumeration2.hasMoreElements()) {
            try {
                object9 = (String)enumeration2.nextElement();
                object8 = this.engineGetCertificate((String)object9);
                boolean bl4 = false;
                object7 = new CertBag(x509Certificate, new DEROctetString(((Certificate)object8).getEncoded()));
                contentInfoArray = new ASN1EncodableVector();
                if (object8 instanceof PKCS12BagAttributeCarrier) {
                    object6 = (PKCS12BagAttributeCarrier)object8;
                    object5 = (DERBMPString)object6.getBagAttribute(pkcs_9_at_friendlyName);
                    if (object5 == null || !((DERBMPString)object5).getString().equals(object9)) {
                        object6.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString((String)object9));
                    }
                    if (object6.getBagAttribute(pkcs_9_at_localKeyId) == null) {
                        object6.setBagAttribute(pkcs_9_at_localKeyId, this.a(((Certificate)object8).getPublicKey()));
                    }
                    object4 = object6.getBagAttributeKeys();
                    while (object4.hasMoreElements()) {
                        object3 = (ASN1ObjectIdentifier)object4.nextElement();
                        object2 = new ASN1EncodableVector();
                        ((ASN1EncodableVector)object2).add((ASN1Encodable)object3);
                        ((ASN1EncodableVector)object2).add(new DERSet(object6.getBagAttribute((ASN1ObjectIdentifier)object3)));
                        contentInfoArray.add(new DERSequence((ASN1EncodableVector)object2));
                        bl4 = true;
                    }
                }
                if (!bl4) {
                    object6 = new ASN1EncodableVector();
                    ((ASN1EncodableVector)object6).add(pkcs_9_at_localKeyId);
                    ((ASN1EncodableVector)object6).add(new DERSet(this.a(((Certificate)object8).getPublicKey())));
                    contentInfoArray.add(new DERSequence((ASN1EncodableVector)object6));
                    object6 = new ASN1EncodableVector();
                    ((ASN1EncodableVector)object6).add(pkcs_9_at_friendlyName);
                    ((ASN1EncodableVector)object6).add(new DERSet(new DERBMPString((String)object9)));
                    contentInfoArray.add(new DERSequence((ASN1EncodableVector)object6));
                }
                object6 = new SafeBag(certBag, ((CertBag)object7).toASN1Primitive(), new DERSet((ASN1EncodableVector)contentInfoArray));
                ((ASN1EncodableVector)object12).add((ASN1Encodable)object6);
                ((Hashtable)object10).put(object8, object8);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        enumeration2 = this.g.a();
        while (enumeration2.hasMoreElements()) {
            try {
                object9 = (String)enumeration2.nextElement();
                object8 = (Certificate)this.g.b((String)object9);
                boolean bl5 = false;
                if (this.e.b((String)object9) != null) continue;
                object7 = new CertBag(x509Certificate, new DEROctetString(((Certificate)object8).getEncoded()));
                contentInfoArray = new ASN1EncodableVector();
                if (object8 instanceof PKCS12BagAttributeCarrier) {
                    object6 = (PKCS12BagAttributeCarrier)object8;
                    object5 = (DERBMPString)object6.getBagAttribute(pkcs_9_at_friendlyName);
                    if (object5 == null || !((DERBMPString)object5).getString().equals(object9)) {
                        object6.setBagAttribute(pkcs_9_at_friendlyName, new DERBMPString((String)object9));
                    }
                    object4 = object6.getBagAttributeKeys();
                    while (object4.hasMoreElements()) {
                        object3 = (ASN1ObjectIdentifier)object4.nextElement();
                        if (((ASN1Primitive)object3).equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                        object2 = new ASN1EncodableVector();
                        ((ASN1EncodableVector)object2).add((ASN1Encodable)object3);
                        ((ASN1EncodableVector)object2).add(new DERSet(object6.getBagAttribute((ASN1ObjectIdentifier)object3)));
                        contentInfoArray.add(new DERSequence((ASN1EncodableVector)object2));
                        bl5 = true;
                    }
                }
                if (!bl5) {
                    object6 = new ASN1EncodableVector();
                    ((ASN1EncodableVector)object6).add(pkcs_9_at_friendlyName);
                    ((ASN1EncodableVector)object6).add(new DERSet(new DERBMPString((String)object9)));
                    contentInfoArray.add(new DERSequence((ASN1EncodableVector)object6));
                }
                object6 = new SafeBag(certBag, ((CertBag)object7).toASN1Primitive(), new DERSet((ASN1EncodableVector)contentInfoArray));
                ((ASN1EncodableVector)object12).add((ASN1Encodable)object6);
                ((Hashtable)object10).put(object8, object8);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        object9 = this.a();
        enumeration2 = this.h.keys();
        while (enumeration2.hasMoreElements()) {
            try {
                object8 = (a)enumeration2.nextElement();
                Certificate certificate = (Certificate)this.h.get(object8);
                if (!object9.contains(certificate) || ((Hashtable)object10).get(certificate) != null) continue;
                object7 = new CertBag(x509Certificate, new DEROctetString(certificate.getEncoded()));
                contentInfoArray = new ASN1EncodableVector();
                if (certificate instanceof PKCS12BagAttributeCarrier) {
                    object6 = (PKCS12BagAttributeCarrier)((Object)certificate);
                    object5 = object6.getBagAttributeKeys();
                    while (object5.hasMoreElements()) {
                        object4 = (ASN1ObjectIdentifier)object5.nextElement();
                        if (((ASN1Primitive)object4).equals(PKCSObjectIdentifiers.pkcs_9_at_localKeyId)) continue;
                        object3 = new ASN1EncodableVector();
                        ((ASN1EncodableVector)object3).add((ASN1Encodable)object4);
                        ((ASN1EncodableVector)object3).add(new DERSet(object6.getBagAttribute((ASN1ObjectIdentifier)object4)));
                        contentInfoArray.add(new DERSequence((ASN1EncodableVector)object3));
                    }
                }
                object6 = new SafeBag(certBag, ((CertBag)object7).toASN1Primitive(), new DERSet((ASN1EncodableVector)contentInfoArray));
                ((ASN1EncodableVector)object12).add((ASN1Encodable)object6);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
            }
        }
        object8 = new DERSequence((ASN1EncodableVector)object12).getEncoded("DER");
        byte[] byArray2 = this.cryptData(true, algorithmIdentifier, cArray, false, (byte[])object8);
        object7 = new EncryptedData(data, algorithmIdentifier, new BEROctetString(byArray2));
        contentInfoArray = new ContentInfo[]{new ContentInfo(data, (ASN1Encodable)object14), new ContentInfo(encryptedData, ((EncryptedData)object7).toASN1Primitive())};
        object6 = new AuthenticatedSafe(contentInfoArray);
        object5 = new ByteArrayOutputStream();
        object4 = bl2 ? new DEROutputStream((OutputStream)object5) : new BEROutputStream((OutputStream)object5);
        ((DEROutputStream)object4).writeObject((ASN1Encodable)object6);
        object3 = ((ByteArrayOutputStream)object5).toByteArray();
        object2 = new ContentInfo(data, new BEROctetString((byte[])object3));
        byte[] byArray3 = new byte[this.o];
        this.random.nextBytes(byArray3);
        byte[] byArray4 = ((ASN1OctetString)((ContentInfo)object2).getContent()).getOctets();
        try {
            object = this.a(this.m.getAlgorithm(), byArray3, this.n, cArray, false, byArray4);
            DigestInfo digestInfo = new DigestInfo(this.m, (byte[])object);
            macData = new MacData(digestInfo, byArray3, this.n);
        }
        catch (Exception exception) {
            throw new IOException("error constructing MAC: " + exception.toString());
        }
        object = new Pfx((ContentInfo)object2, macData);
        object4 = bl2 ? new DEROutputStream(outputStream) : new BEROutputStream(outputStream);
        ((DEROutputStream)object4).writeObject((ASN1Encodable)object);
    }

    private Set a() {
        Object object;
        String string;
        HashSet<Object> hashSet = new HashSet<Object>();
        Enumeration enumeration = this.e.a();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.engineGetCertificateChain(string);
            for (int i2 = 0; i2 != ((Certificate[])object).length; ++i2) {
                hashSet.add(object[i2]);
            }
        }
        enumeration = this.g.a();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.engineGetCertificate(string);
            hashSet.add(object);
        }
        return hashSet;
    }

    private byte[] a(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray, int n2, char[] cArray, boolean bl2, byte[] byArray2) throws Exception {
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n2);
        Mac mac = this.a.createMac(aSN1ObjectIdentifier.getId());
        mac.init(new PKCS12Key(cArray, bl2), pBEParameterSpec);
        mac.update(byArray2);
        return mac.doFinal();
    }

    private static synchronized Provider b() {
        if (Security.getProvider("BC") != null) {
            return Security.getProvider("BC");
        }
        if (p == null) {
            p = new BouncyCastleProvider();
        }
        return p;
    }

    public static class BCPKCS12KeyStore
    extends PKCS12KeyStoreSpi {
        public BCPKCS12KeyStore() {
            super(PKCS12KeyStoreSpi.b(), pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd40BitRC2_CBC);
        }
    }

    public static class BCPKCS12KeyStore3DES
    extends PKCS12KeyStoreSpi {
        public BCPKCS12KeyStore3DES() {
            super(PKCS12KeyStoreSpi.b(), pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    private class a {
        byte[] a;

        a(PublicKey publicKey) {
            this.a = PKCS12KeyStoreSpi.this.a(publicKey).getKeyIdentifier();
        }

        a(byte[] byArray) {
            this.a = byArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.a);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof a)) {
                return false;
            }
            a a2 = (a)object;
            return Arrays.areEqual(this.a, a2.a);
        }
    }

    public static class DefPKCS12KeyStore
    extends PKCS12KeyStoreSpi {
        public DefPKCS12KeyStore() {
            super(null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd40BitRC2_CBC);
        }
    }

    public static class DefPKCS12KeyStore3DES
    extends PKCS12KeyStoreSpi {
        public DefPKCS12KeyStore3DES() {
            super(null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    private static class b {
        private final Map a;

        b() {
            HashMap<ASN1ObjectIdentifier, Integer> hashMap = new HashMap<ASN1ObjectIdentifier, Integer>();
            hashMap.put(new ASN1ObjectIdentifier("1.2.840.113533.7.66.10"), Integers.valueOf(128));
            hashMap.put(PKCSObjectIdentifiers.des_EDE3_CBC, Integers.valueOf(192));
            hashMap.put(NISTObjectIdentifiers.id_aes128_CBC, Integers.valueOf(128));
            hashMap.put(NISTObjectIdentifiers.id_aes192_CBC, Integers.valueOf(192));
            hashMap.put(NISTObjectIdentifiers.id_aes256_CBC, Integers.valueOf(256));
            hashMap.put(NTTObjectIdentifiers.id_camellia128_cbc, Integers.valueOf(128));
            hashMap.put(NTTObjectIdentifiers.id_camellia192_cbc, Integers.valueOf(192));
            hashMap.put(NTTObjectIdentifiers.id_camellia256_cbc, Integers.valueOf(256));
            hashMap.put(CryptoProObjectIdentifiers.gostR28147_gcfb, Integers.valueOf(256));
            this.a = Collections.unmodifiableMap(hashMap);
        }

        public int a(AlgorithmIdentifier algorithmIdentifier) {
            Integer n2 = (Integer)this.a.get(algorithmIdentifier.getAlgorithm());
            if (n2 != null) {
                return n2;
            }
            return -1;
        }
    }

    private static class c {
        private Hashtable a = new Hashtable();
        private Hashtable b = new Hashtable();

        private c() {
        }

        public void a(String string, Object object) {
            String string2 = string == null ? null : Strings.toLowerCase(string);
            String string3 = (String)this.b.get(string2);
            if (string3 != null) {
                this.a.remove(string3);
            }
            this.b.put(string2, string);
            this.a.put(string, object);
        }

        public Enumeration a() {
            return this.a.keys();
        }

        public Object a(String string) {
            String string2 = (String)this.b.remove(string == null ? null : Strings.toLowerCase(string));
            if (string2 == null) {
                return null;
            }
            return this.a.remove(string2);
        }

        public Object b(String string) {
            String string2 = (String)this.b.get(string == null ? null : Strings.toLowerCase(string));
            if (string2 == null) {
                return null;
            }
            return this.a.get(string2);
        }

        public Enumeration b() {
            return this.a.elements();
        }

        /* synthetic */ c(com.aspose.cad.internal.bouncycastle.jcajce.provider.keystore.pkcs12.a a2) {
            this();
        }
    }
}

