/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.dh;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.cad.internal.bouncycastle.crypto.agreement.DHBasicAgreement;
import com.aspose.cad.internal.bouncycastle.crypto.engines.AESEngine;
import com.aspose.cad.internal.bouncycastle.crypto.engines.DESedeEngine;
import com.aspose.cad.internal.bouncycastle.crypto.engines.IESEngine;
import com.aspose.cad.internal.bouncycastle.crypto.generators.DHKeyPairGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.generators.KDF2BytesGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.macs.HMac;
import com.aspose.cad.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.DHKeyParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.DHParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.IESWithCipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.cad.internal.bouncycastle.crypto.parsers.DHIESPublicKeyParser;
import com.aspose.cad.internal.bouncycastle.crypto.util.DigestFactory;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.dh.a;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.DHUtil;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.IESUtil;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.util.BadBlockException;
import com.aspose.cad.internal.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jce.interfaces.IESKey;
import com.aspose.cad.internal.bouncycastle.jce.spec.IESParameterSpec;
import com.aspose.cad.internal.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;

public class IESCipher
extends CipherSpi {
    private final JcaJceHelper a = new BCJcaJceHelper();
    private final int b;
    private IESEngine c;
    private int d = -1;
    private ByteArrayOutputStream e = new ByteArrayOutputStream();
    private AlgorithmParameters f = null;
    private IESParameterSpec g = null;
    private AsymmetricKeyParameter h;
    private SecureRandom i;
    private boolean j = false;
    private AsymmetricKeyParameter k = null;

    public IESCipher(IESEngine iESEngine) {
        this.c = iESEngine;
        this.b = 0;
    }

    public IESCipher(IESEngine iESEngine, int n2) {
        this.c = iESEngine;
        this.b = n2;
    }

    @Override
    public int engineGetBlockSize() {
        if (this.c.getCipher() != null) {
            return this.c.getCipher().getBlockSize();
        }
        return 0;
    }

    @Override
    public int engineGetKeySize(Key key) {
        if (key instanceof DHKey) {
            return ((DHKey)((Object)key)).getParams().getP().bitLength();
        }
        throw new IllegalArgumentException("not a DH key");
    }

    @Override
    public byte[] engineGetIV() {
        if (this.g != null) {
            return this.g.getNonce();
        }
        return null;
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        if (this.f == null && this.g != null) {
            try {
                this.f = this.a.createAlgorithmParameters("IES");
                this.f.init(this.g);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        return this.f;
    }

    @Override
    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        String string2 = Strings.toUpperCase(string);
        if (string2.equals("NONE")) {
            this.j = false;
        } else if (string2.equals("DHAES")) {
            this.j = true;
        } else {
            throw new IllegalArgumentException("can't support mode " + string);
        }
    }

    @Override
    public int engineGetOutputSize(int n2) {
        int n3;
        if (this.h == null) {
            throw new IllegalStateException("cipher not initialised");
        }
        int n4 = this.c.getMac().getMacSize();
        int n5 = this.k == null ? 1 + 2 * (((DHKeyParameters)this.h).getParameters().getP().bitLength() + 7) / 8 : 0;
        if (this.c.getCipher() == null) {
            n3 = n2;
        } else if (this.d == 1 || this.d == 3) {
            n3 = this.c.getCipher().getOutputSize(n2);
        } else if (this.d == 2 || this.d == 4) {
            n3 = this.c.getCipher().getOutputSize(n2 - n4 - n5);
        } else {
            throw new IllegalStateException("cipher not initialised");
        }
        if (this.d == 1 || this.d == 3) {
            return this.e.size() + n4 + n5 + n3;
        }
        if (this.d == 2 || this.d == 4) {
            return this.e.size() - n4 - n5 + n3;
        }
        throw new IllegalStateException("IESCipher not initialised");
    }

    @Override
    public void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase(string);
        if (!(string2.equals("NOPADDING") || string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING"))) {
            throw new NoSuchPaddingException("padding not available with IESCipher");
        }
    }

    @Override
    public void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IESParameterSpec iESParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                iESParameterSpec = algorithmParameters.getParameterSpec(IESParameterSpec.class);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("cannot recognise parameters: " + exception.toString());
            }
        }
        this.f = algorithmParameters;
        this.engineInit(n2, key, iESParameterSpec, secureRandom);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        byte[] byArray;
        if (algorithmParameterSpec == null) {
            byArray = null;
            if (this.b != 0 && n2 == 1) {
                byArray = new byte[this.b];
                secureRandom.nextBytes(byArray);
            }
            this.g = IESUtil.guessParameterSpec(this.c.getCipher(), byArray);
        } else {
            if (!(algorithmParameterSpec instanceof IESParameterSpec)) throw new InvalidAlgorithmParameterException("must be passed IES parameters");
            this.g = (IESParameterSpec)algorithmParameterSpec;
        }
        byArray = this.g.getNonce();
        if (this.b != 0 && (byArray == null || byArray.length != this.b)) {
            throw new InvalidAlgorithmParameterException("NONCE in IES Parameters needs to be " + this.b + " bytes long");
        }
        if (n2 == 1 || n2 == 3) {
            if (key instanceof DHPublicKey) {
                this.h = DHUtil.generatePublicKeyParameter((PublicKey)key);
            } else {
                if (!(key instanceof IESKey)) throw new InvalidKeyException("must be passed recipient's public DH key for encryption");
                IESKey iESKey = (IESKey)key;
                this.h = DHUtil.generatePublicKeyParameter(iESKey.getPublic());
                this.k = DHUtil.generatePrivateKeyParameter(iESKey.getPrivate());
            }
        } else {
            if (n2 != 2 && n2 != 4) throw new InvalidKeyException("must be passed EC key");
            if (key instanceof DHPrivateKey) {
                this.h = DHUtil.generatePrivateKeyParameter((PrivateKey)key);
            } else {
                if (!(key instanceof IESKey)) throw new InvalidKeyException("must be passed recipient's private DH key for decryption");
                IESKey iESKey = (IESKey)key;
                this.k = DHUtil.generatePublicKeyParameter(iESKey.getPublic());
                this.h = DHUtil.generatePrivateKeyParameter(iESKey.getPrivate());
            }
        }
        this.i = secureRandom;
        this.d = n2;
        this.e.reset();
    }

    @Override
    public void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException("cannot handle supplied parameter spec: " + invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    public byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        this.e.write(byArray, n2, n3);
        return null;
    }

    @Override
    public int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        this.e.write(byArray, n2, n3);
        return 0;
    }

    @Override
    public byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        if (n3 != 0) {
            this.e.write(byArray, n2, n3);
        }
        byte[] byArray2 = this.e.toByteArray();
        this.e.reset();
        CipherParameters cipherParameters = new IESWithCipherParameters(this.g.getDerivationV(), this.g.getEncodingV(), this.g.getMacKeySize(), this.g.getCipherKeySize());
        if (this.g.getNonce() != null) {
            cipherParameters = new ParametersWithIV(cipherParameters, this.g.getNonce());
        }
        DHParameters dHParameters = ((DHKeyParameters)this.h).getParameters();
        if (this.k != null) {
            try {
                if (this.d == 1 || this.d == 3) {
                    this.c.init(true, this.k, this.h, cipherParameters);
                } else {
                    this.c.init(false, this.h, this.k, cipherParameters);
                }
                return this.c.processBlock(byArray2, 0, byArray2.length);
            }
            catch (Exception exception) {
                throw new BadBlockException("unable to process block", exception);
            }
        }
        if (this.d == 1 || this.d == 3) {
            DHKeyPairGenerator dHKeyPairGenerator = new DHKeyPairGenerator();
            dHKeyPairGenerator.init(new DHKeyGenerationParameters(this.i, dHParameters));
            EphemeralKeyPairGenerator ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator(dHKeyPairGenerator, new a(this));
            try {
                this.c.init(this.h, cipherParameters, ephemeralKeyPairGenerator);
                return this.c.processBlock(byArray2, 0, byArray2.length);
            }
            catch (Exception exception) {
                throw new BadBlockException("unable to process block", exception);
            }
        }
        if (this.d == 2 || this.d == 4) {
            try {
                this.c.init(this.h, cipherParameters, new DHIESPublicKeyParser(((DHKeyParameters)this.h).getParameters()));
                return this.c.processBlock(byArray2, 0, byArray2.length);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new BadBlockException("unable to process block", invalidCipherTextException);
            }
        }
        throw new IllegalStateException("IESCipher not initialised");
    }

    @Override
    public int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = this.engineDoFinal(byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
        return byArray3.length;
    }

    public static class IES
    extends IESCipher {
        public IES() {
            super(new IESEngine(new DHBasicAgreement(), new KDF2BytesGenerator(DigestFactory.createSHA1()), new HMac(DigestFactory.createSHA1())));
        }
    }

    public static class IESwithAESCBC
    extends IESCipher {
        public IESwithAESCBC() {
            super(new IESEngine(new DHBasicAgreement(), new KDF2BytesGenerator(DigestFactory.createSHA1()), new HMac(DigestFactory.createSHA1()), new PaddedBufferedBlockCipher(new CBCBlockCipher(new AESEngine()))), 16);
        }
    }

    public static class IESwithDESedeCBC
    extends IESCipher {
        public IESwithDESedeCBC() {
            super(new IESEngine(new DHBasicAgreement(), new KDF2BytesGenerator(DigestFactory.createSHA1()), new HMac(DigestFactory.createSHA1()), new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()))), 8);
        }
    }
}

