/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.tls;

import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.prng.RandomGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.tls.ProtocolVersion;
import com.aspose.cad.internal.bouncycastle.crypto.tls.SecurityParameters;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsContext;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsSession;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsUtils;
import com.aspose.cad.internal.bouncycastle.util.Times;
import java.security.SecureRandom;

abstract class a
implements TlsContext {
    private static long a = Times.nanoTime();
    private RandomGenerator b;
    private SecureRandom c;
    private SecurityParameters d;
    private ProtocolVersion e = null;
    private ProtocolVersion f = null;
    private TlsSession g = null;
    private Object h = null;

    private static synchronized long a() {
        return ++a;
    }

    a(SecureRandom secureRandom, SecurityParameters securityParameters) {
        Digest digest = TlsUtils.createHash((short)4);
        byte[] byArray = new byte[digest.getDigestSize()];
        secureRandom.nextBytes(byArray);
        this.b = new DigestRandomGenerator(digest);
        this.b.addSeedMaterial(com.aspose.cad.internal.bouncycastle.crypto.tls.a.a());
        this.b.addSeedMaterial(Times.nanoTime());
        this.b.addSeedMaterial(byArray);
        this.c = secureRandom;
        this.d = securityParameters;
    }

    @Override
    public RandomGenerator getNonceRandomGenerator() {
        return this.b;
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.c;
    }

    @Override
    public SecurityParameters getSecurityParameters() {
        return this.d;
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return this.e;
    }

    void a(ProtocolVersion protocolVersion) {
        this.e = protocolVersion;
    }

    @Override
    public ProtocolVersion getServerVersion() {
        return this.f;
    }

    void b(ProtocolVersion protocolVersion) {
        this.f = protocolVersion;
    }

    @Override
    public TlsSession getResumableSession() {
        return this.g;
    }

    void a(TlsSession tlsSession) {
        this.g = tlsSession;
    }

    @Override
    public Object getUserObject() {
        return this.h;
    }

    @Override
    public void setUserObject(Object object) {
        this.h = object;
    }

    @Override
    public byte[] exportKeyingMaterial(String string, byte[] byArray, int n2) {
        if (byArray != null && !TlsUtils.isValidUint16(byArray.length)) {
            throw new IllegalArgumentException("'context_value' must have length less than 2^16 (or be null)");
        }
        SecurityParameters securityParameters = this.getSecurityParameters();
        byte[] byArray2 = securityParameters.getClientRandom();
        byte[] byArray3 = securityParameters.getServerRandom();
        int n3 = byArray2.length + byArray3.length;
        if (byArray != null) {
            n3 += 2 + byArray.length;
        }
        byte[] byArray4 = new byte[n3];
        int n4 = 0;
        System.arraycopy(byArray2, 0, byArray4, n4, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, n4 += byArray2.length, byArray3.length);
        n4 += byArray3.length;
        if (byArray != null) {
            TlsUtils.writeUint16(byArray.length, byArray4, n4);
            System.arraycopy(byArray, 0, byArray4, n4 += 2, byArray.length);
            n4 += byArray.length;
        }
        if (n4 != n3) {
            throw new IllegalStateException("error in calculation of seed for export");
        }
        return TlsUtils.PRF(this, securityParameters.getMasterSecret(), string, byArray4, n2);
    }
}

