/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.tls;

import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteQueue {
    private static final int a = 1024;
    private byte[] b;
    private int c = 0;
    private int d = 0;
    private boolean e = false;

    public static int nextTwoPow(int n2) {
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        return n2 + 1;
    }

    public ByteQueue() {
        this(1024);
    }

    public ByteQueue(int n2) {
        this.b = n2 == 0 ? TlsUtils.EMPTY_BYTES : new byte[n2];
    }

    public ByteQueue(byte[] byArray, int n2, int n3) {
        this.b = byArray;
        this.c = n2;
        this.d = n3;
        this.e = true;
    }

    public void addData(byte[] byArray, int n2, int n3) {
        if (this.e) {
            throw new IllegalStateException("Cannot add data to read-only buffer");
        }
        if (this.c + this.d + n3 > this.b.length) {
            int n4 = ByteQueue.nextTwoPow(this.d + n3);
            if (n4 > this.b.length) {
                byte[] byArray2 = new byte[n4];
                System.arraycopy(this.b, this.c, byArray2, 0, this.d);
                this.b = byArray2;
            } else {
                System.arraycopy(this.b, this.c, this.b, 0, this.d);
            }
            this.c = 0;
        }
        System.arraycopy(byArray, n2, this.b, this.c + this.d, n3);
        this.d += n3;
    }

    public int available() {
        return this.d;
    }

    public void copyTo(OutputStream outputStream, int n2) throws IOException {
        if (n2 > this.d) {
            throw new IllegalStateException("Cannot copy " + n2 + " bytes, only got " + this.d);
        }
        outputStream.write(this.b, this.c, n2);
    }

    public void read(byte[] byArray, int n2, int n3, int n4) {
        if (byArray.length - n2 < n3) {
            throw new IllegalArgumentException("Buffer size of " + byArray.length + " is too small for a read of " + n3 + " bytes");
        }
        if (this.d - n4 < n3) {
            throw new IllegalStateException("Not enough data to read");
        }
        System.arraycopy(this.b, this.c + n4, byArray, n2, n3);
    }

    public ByteArrayInputStream readFrom(int n2) {
        if (n2 > this.d) {
            throw new IllegalStateException("Cannot read " + n2 + " bytes, only got " + this.d);
        }
        int n3 = this.c;
        this.d -= n2;
        this.c += n2;
        return new ByteArrayInputStream(this.b, n3, n2);
    }

    public void removeData(int n2) {
        if (n2 > this.d) {
            throw new IllegalStateException("Cannot remove " + n2 + " bytes, only got " + this.d);
        }
        this.d -= n2;
        this.c += n2;
    }

    public void removeData(byte[] byArray, int n2, int n3, int n4) {
        this.read(byArray, n2, n3, n4);
        this.removeData(n4 + n3);
    }

    public byte[] removeData(int n2, int n3) {
        byte[] byArray = new byte[n2];
        this.removeData(byArray, 0, n2, n3);
        return byArray;
    }

    public void shrink() {
        if (this.d == 0) {
            this.b = TlsUtils.EMPTY_BYTES;
            this.c = 0;
        } else {
            int n2 = ByteQueue.nextTwoPow(this.d);
            if (n2 < this.b.length) {
                byte[] byArray = new byte[n2];
                System.arraycopy(this.b, this.c, byArray, 0, this.d);
                this.b = byArray;
                this.c = 0;
            }
        }
    }
}

