/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.macs;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.cad.internal.bouncycastle.crypto.Mac;
import com.aspose.cad.internal.bouncycastle.crypto.modes.KGCMBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.params.AEADParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithIV;

public class KGMac
implements Mac {
    private final KGCMBlockCipher a;
    private final int b;

    public KGMac(KGCMBlockCipher kGCMBlockCipher) {
        this.a = kGCMBlockCipher;
        this.b = kGCMBlockCipher.getUnderlyingCipher().getBlockSize() * 8;
    }

    public KGMac(KGCMBlockCipher kGCMBlockCipher, int n2) {
        this.a = kGCMBlockCipher;
        this.b = n2;
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("KGMAC requires ParametersWithIV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        byte[] byArray = parametersWithIV.getIV();
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        this.a.init(true, new AEADParameters(keyParameter, this.b, byArray));
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getUnderlyingCipher().getAlgorithmName() + "-KGMAC";
    }

    @Override
    public int getMacSize() {
        return this.b / 8;
    }

    @Override
    public void update(byte by2) throws IllegalStateException {
        this.a.processAADByte(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalStateException {
        this.a.processAADBytes(byArray, n2, n3);
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        try {
            return this.a.doFinal(byArray, n2);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new IllegalStateException(invalidCipherTextException.toString());
        }
    }

    @Override
    public void reset() {
        this.a.reset();
    }
}

