/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.engines;

import com.aspose.cad.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.engines.a;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.cad.internal.bouncycastle.crypto.params.RSAKeyParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.aspose.cad.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSABlindedEngine
implements AsymmetricBlockCipher {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private a b = new a();
    private RSAKeyParameters c;
    private SecureRandom d;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.b.a(bl2, cipherParameters);
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.c = (RSAKeyParameters)parametersWithRandom.getParameters();
            this.d = parametersWithRandom.getRandom();
        } else {
            this.c = (RSAKeyParameters)cipherParameters;
            this.d = new SecureRandom();
        }
    }

    @Override
    public int getInputBlockSize() {
        return this.b.a();
    }

    @Override
    public int getOutputBlockSize() {
        return this.b.b();
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n2, int n3) {
        BigInteger bigInteger;
        if (this.c == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        BigInteger bigInteger2 = this.b.a(byArray, n2, n3);
        if (this.c instanceof RSAPrivateCrtKeyParameters) {
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)this.c;
            BigInteger bigInteger3 = rSAPrivateCrtKeyParameters.getPublicExponent();
            if (bigInteger3 != null) {
                BigInteger bigInteger4;
                BigInteger bigInteger5 = rSAPrivateCrtKeyParameters.getModulus();
                BigInteger bigInteger6 = BigIntegers.createRandomInRange(a, bigInteger5.subtract(a), this.d);
                BigInteger bigInteger7 = bigInteger6.modPow(bigInteger3, bigInteger5).multiply(bigInteger2).mod(bigInteger5);
                BigInteger bigInteger8 = this.b.b(bigInteger7);
                bigInteger = bigInteger8.multiply(bigInteger4 = bigInteger6.modInverse(bigInteger5)).mod(bigInteger5);
                if (!bigInteger2.equals(bigInteger.modPow(bigInteger3, bigInteger5))) {
                    throw new IllegalStateException("RSA engine faulty decryption/signing detected");
                }
            } else {
                bigInteger = this.b.b(bigInteger2);
            }
        } else {
            bigInteger = this.b.b(bigInteger2);
        }
        return this.b.a(bigInteger);
    }
}

