/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cms;

import com.aspose.cad.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.cad.internal.bouncycastle.cms.KeyTransRecipientId;
import com.aspose.cad.internal.bouncycastle.cms.Recipient;
import com.aspose.cad.internal.bouncycastle.cms.RecipientId;
import com.aspose.cad.internal.bouncycastle.cms.RecipientInformation;
import com.aspose.cad.internal.bouncycastle.util.Iterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RecipientInformationStore
implements Iterable<RecipientInformation> {
    private final List a;
    private final Map b = new HashMap();

    public RecipientInformationStore(RecipientInformation recipientInformation) {
        this.a = new ArrayList(1);
        this.a.add(recipientInformation);
        RecipientId recipientId = recipientInformation.getRID();
        this.b.put(recipientId, this.a);
    }

    public RecipientInformationStore(Collection<RecipientInformation> collection) {
        for (RecipientInformation recipientInformation : collection) {
            RecipientId recipientId = recipientInformation.getRID();
            ArrayList<RecipientInformation> arrayList = (ArrayList<RecipientInformation>)this.b.get(recipientId);
            if (arrayList == null) {
                arrayList = new ArrayList<RecipientInformation>(1);
                this.b.put(recipientId, arrayList);
            }
            arrayList.add(recipientInformation);
        }
        this.a = new ArrayList<RecipientInformation>(collection);
    }

    public RecipientInformation get(RecipientId recipientId) {
        Collection<Recipient> collection = this.getRecipients(recipientId);
        return collection.size() == 0 ? null : (RecipientInformation)((Object)collection.iterator().next());
    }

    public int size() {
        return this.a.size();
    }

    public Collection<RecipientInformation> getRecipients() {
        return new ArrayList<RecipientInformation>(this.a);
    }

    public Collection<Recipient> getRecipients(RecipientId recipientId) {
        Cloneable cloneable;
        if (recipientId instanceof KeyTransRecipientId) {
            cloneable = (KeyTransRecipientId)recipientId;
            X500Name x500Name = ((KeyTransRecipientId)cloneable).getIssuer();
            byte[] byArray = ((KeyTransRecipientId)cloneable).getSubjectKeyIdentifier();
            if (x500Name != null && byArray != null) {
                Collection<Recipient> collection;
                ArrayList<Recipient> arrayList = new ArrayList<Recipient>();
                Collection<Recipient> collection2 = this.getRecipients(new KeyTransRecipientId(x500Name, ((KeyTransRecipientId)cloneable).getSerialNumber()));
                if (collection2 != null) {
                    arrayList.addAll(collection2);
                }
                if ((collection = this.getRecipients(new KeyTransRecipientId(byArray))) != null) {
                    arrayList.addAll(collection);
                }
                return arrayList;
            }
        }
        return (cloneable = (ArrayList)this.b.get(recipientId)) == null ? new ArrayList<Recipient>() : new ArrayList(cloneable);
    }

    @Override
    public Iterator<RecipientInformation> iterator() {
        return this.getRecipients().iterator();
    }
}

