/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cms;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.cad.internal.bouncycastle.asn1.cms.AttributeTable;
import com.aspose.cad.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.cad.internal.bouncycastle.asn1.cms.EncryptedContentInfo;
import com.aspose.cad.internal.bouncycastle.asn1.cms.EnvelopedData;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.cms.CMSException;
import com.aspose.cad.internal.bouncycastle.cms.CMSProcessableByteArray;
import com.aspose.cad.internal.bouncycastle.cms.OriginatorInformation;
import com.aspose.cad.internal.bouncycastle.cms.RecipientInformationStore;
import com.aspose.cad.internal.bouncycastle.cms.h;
import com.aspose.cad.internal.bouncycastle.cms.o;
import com.aspose.cad.internal.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.InputStream;

public class CMSEnvelopedData
implements Encodable {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private AlgorithmIdentifier a;
    private ASN1Set b;
    private OriginatorInformation c;

    public CMSEnvelopedData(byte[] byArray) throws CMSException {
        this(o.a(byArray));
    }

    public CMSEnvelopedData(InputStream inputStream) throws CMSException {
        this(o.a(inputStream));
    }

    public CMSEnvelopedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        try {
            EnvelopedData envelopedData = EnvelopedData.getInstance(contentInfo.getContent());
            if (envelopedData.getOriginatorInfo() != null) {
                this.c = new OriginatorInformation(envelopedData.getOriginatorInfo());
            }
            ASN1Set aSN1Set = envelopedData.getRecipientInfos();
            EncryptedContentInfo encryptedContentInfo = envelopedData.getEncryptedContentInfo();
            this.a = encryptedContentInfo.getContentEncryptionAlgorithm();
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(encryptedContentInfo.getEncryptedContent().getOctets());
            h.c c2 = new h.c(this.a, cMSProcessableByteArray);
            this.recipientInfoStore = h.a(aSN1Set, this.a, c2);
            this.b = envelopedData.getUnprotectedAttrs();
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    private byte[] a(ASN1Encodable aSN1Encodable) throws IOException {
        if (aSN1Encodable != null) {
            return aSN1Encodable.toASN1Primitive().getEncoded();
        }
        return null;
    }

    public OriginatorInformation getOriginatorInfo() {
        return this.c;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.a;
    }

    public String getEncryptionAlgOID() {
        return this.a.getAlgorithm().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.a(this.a.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    public AttributeTable getUnprotectedAttributes() {
        if (this.b == null) {
            return null;
        }
        return new AttributeTable(this.b);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

