/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert.ocsp;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.DERNull;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.CertID;
import com.aspose.cad.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.OCSPException;
import com.aspose.cad.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.cad.internal.bouncycastle.operator.DigestCalculatorProvider;
import com.aspose.cad.internal.bouncycastle.operator.OperatorCreationException;
import java.io.OutputStream;
import java.math.BigInteger;

public class CertificateID {
    public static final AlgorithmIdentifier HASH_SHA1 = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE);
    private final CertID a;

    public CertificateID(CertID certID) {
        if (certID == null) {
            throw new IllegalArgumentException("'id' cannot be null");
        }
        this.a = certID;
    }

    public CertificateID(DigestCalculator digestCalculator, X509CertificateHolder x509CertificateHolder, BigInteger bigInteger) throws OCSPException {
        this.a = CertificateID.a(digestCalculator, x509CertificateHolder, new ASN1Integer(bigInteger));
    }

    public ASN1ObjectIdentifier getHashAlgOID() {
        return this.a.getHashAlgorithm().getAlgorithm();
    }

    public byte[] getIssuerNameHash() {
        return this.a.getIssuerNameHash().getOctets();
    }

    public byte[] getIssuerKeyHash() {
        return this.a.getIssuerKeyHash().getOctets();
    }

    public BigInteger getSerialNumber() {
        return this.a.getSerialNumber().getValue();
    }

    public boolean matchesIssuer(X509CertificateHolder x509CertificateHolder, DigestCalculatorProvider digestCalculatorProvider) throws OCSPException {
        try {
            return CertificateID.a(digestCalculatorProvider.get(this.a.getHashAlgorithm()), x509CertificateHolder, this.a.getSerialNumber()).equals(this.a);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new OCSPException("unable to create digest calculator: " + operatorCreationException.getMessage(), operatorCreationException);
        }
    }

    public CertID toASN1Primitive() {
        return this.a;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CertificateID)) {
            return false;
        }
        CertificateID certificateID = (CertificateID)object;
        return this.a.toASN1Primitive().equals(certificateID.a.toASN1Primitive());
    }

    public int hashCode() {
        return this.a.toASN1Primitive().hashCode();
    }

    public static CertificateID deriveCertificateID(CertificateID certificateID, BigInteger bigInteger) {
        return new CertificateID(new CertID(certificateID.a.getHashAlgorithm(), certificateID.a.getIssuerNameHash(), certificateID.a.getIssuerKeyHash(), new ASN1Integer(bigInteger)));
    }

    private static CertID a(DigestCalculator digestCalculator, X509CertificateHolder x509CertificateHolder, ASN1Integer aSN1Integer) throws OCSPException {
        try {
            OutputStream outputStream = digestCalculator.getOutputStream();
            outputStream.write(x509CertificateHolder.toASN1Structure().getSubject().getEncoded("DER"));
            outputStream.close();
            DEROctetString dEROctetString = new DEROctetString(digestCalculator.getDigest());
            SubjectPublicKeyInfo subjectPublicKeyInfo = x509CertificateHolder.getSubjectPublicKeyInfo();
            outputStream = digestCalculator.getOutputStream();
            outputStream.write(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            outputStream.close();
            DEROctetString dEROctetString2 = new DEROctetString(digestCalculator.getDigest());
            return new CertID(digestCalculator.getAlgorithmIdentifier(), dEROctetString, dEROctetString2, aSN1Integer);
        }
        catch (Exception exception) {
            throw new OCSPException("problem creating ID: " + exception, exception);
        }
    }
}

