/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert.cmp;

import com.aspose.cad.internal.bouncycastle.asn1.cmp.CertStatus;
import com.aspose.cad.internal.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.cert.cmp.CMPException;
import com.aspose.cad.internal.bouncycastle.cert.cmp.a;
import com.aspose.cad.internal.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.aspose.cad.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.cad.internal.bouncycastle.operator.DigestCalculatorProvider;
import com.aspose.cad.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder a;
    private CertStatus b;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, CertStatus certStatus) {
        this.a = digestAlgorithmIdentifierFinder;
        this.b = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.b.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.b.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder x509CertificateHolder, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        DigestCalculator digestCalculator;
        AlgorithmIdentifier algorithmIdentifier = this.a.find(x509CertificateHolder.toASN1Structure().getSignatureAlgorithm());
        if (algorithmIdentifier == null) {
            throw new CMPException("cannot find algorithm for digest from signature");
        }
        try {
            digestCalculator = digestCalculatorProvider.get(algorithmIdentifier);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CMPException("unable to create digester: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        com.aspose.cad.internal.bouncycastle.cert.cmp.a.a(x509CertificateHolder.toASN1Structure(), digestCalculator.getOutputStream());
        return Arrays.areEqual(this.b.getCertHash().getOctets(), digestCalculator.getDigest());
    }
}

