/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.ocsp;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AuthorityInformationAccess;

public class ServiceLocator
extends ASN1Object {
    private final X500Name a;
    private final AuthorityInformationAccess b;

    private ServiceLocator(ASN1Sequence aSN1Sequence) {
        this.a = X500Name.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = aSN1Sequence.size() == 2 ? AuthorityInformationAccess.getInstance(aSN1Sequence.getObjectAt(1)) : null;
    }

    public static ServiceLocator getInstance(Object object) {
        if (object instanceof ServiceLocator) {
            return (ServiceLocator)object;
        }
        if (object != null) {
            return new ServiceLocator(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public X500Name getIssuer() {
        return this.a;
    }

    public AuthorityInformationAccess getLocator() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

