/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.esf;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Attribute;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AttributeCertificate;
import java.util.Enumeration;

public class SignerAttribute
extends ASN1Object {
    private Object[] a;

    public static SignerAttribute getInstance(Object object) {
        if (object instanceof SignerAttribute) {
            return (SignerAttribute)object;
        }
        if (object != null) {
            return new SignerAttribute(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private SignerAttribute(ASN1Sequence aSN1Sequence) {
        int n2 = 0;
        this.a = new Object[aSN1Sequence.size()];
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement());
            if (aSN1TaggedObject.getTagNo() == 0) {
                ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(aSN1TaggedObject, true);
                Attribute[] attributeArray = new Attribute[aSN1Sequence2.size()];
                for (int i2 = 0; i2 != attributeArray.length; ++i2) {
                    attributeArray[i2] = Attribute.getInstance(aSN1Sequence2.getObjectAt(i2));
                }
                this.a[n2] = attributeArray;
            } else if (aSN1TaggedObject.getTagNo() == 1) {
                this.a[n2] = AttributeCertificate.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, true));
            } else {
                throw new IllegalArgumentException("illegal tag: " + aSN1TaggedObject.getTagNo());
            }
            ++n2;
        }
    }

    public SignerAttribute(Attribute[] attributeArray) {
        this.a = new Object[1];
        this.a[0] = attributeArray;
    }

    public SignerAttribute(AttributeCertificate attributeCertificate) {
        this.a = new Object[1];
        this.a[0] = attributeCertificate;
    }

    public Object[] getValues() {
        Object[] objectArray = new Object[this.a.length];
        System.arraycopy(this.a, 0, objectArray, 0, objectArray.length);
        return objectArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.a.length; ++i2) {
            if (this.a[i2] instanceof Attribute[]) {
                aSN1EncodableVector.add(new DERTaggedObject(0, new DERSequence((Attribute[])this.a[i2])));
                continue;
            }
            aSN1EncodableVector.add(new DERTaggedObject(1, (AttributeCertificate)this.a[i2]));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

