/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cms;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.BERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.cms.EncryptedContentInfo;
import com.aspose.cad.internal.bouncycastle.asn1.cms.OriginatorInfo;

public class AuthEnvelopedData
extends ASN1Object {
    private ASN1Integer a;
    private OriginatorInfo b;
    private ASN1Set c;
    private EncryptedContentInfo d;
    private ASN1Set e;
    private ASN1OctetString f;
    private ASN1Set g;

    public AuthEnvelopedData(OriginatorInfo originatorInfo, ASN1Set aSN1Set, EncryptedContentInfo encryptedContentInfo, ASN1Set aSN1Set2, ASN1OctetString aSN1OctetString, ASN1Set aSN1Set3) {
        this.a = new ASN1Integer(0L);
        this.b = originatorInfo;
        this.c = aSN1Set;
        if (this.c.size() == 0) {
            throw new IllegalArgumentException("AuthEnvelopedData requires at least 1 RecipientInfo");
        }
        this.d = encryptedContentInfo;
        this.e = aSN1Set2;
        if (!(encryptedContentInfo.getContentType().equals(CMSObjectIdentifiers.data) || aSN1Set2 != null && aSN1Set2.size() != 0)) {
            throw new IllegalArgumentException("authAttrs must be present with non-data content");
        }
        this.f = aSN1OctetString;
        this.g = aSN1Set3;
    }

    private AuthEnvelopedData(ASN1Sequence aSN1Sequence) {
        int n2 = 0;
        ASN1Primitive aSN1Primitive = aSN1Sequence.getObjectAt(n2++).toASN1Primitive();
        this.a = (ASN1Integer)aSN1Primitive;
        if (this.a.getValue().intValue() != 0) {
            throw new IllegalArgumentException("AuthEnvelopedData version number must be 0");
        }
        if ((aSN1Primitive = aSN1Sequence.getObjectAt(n2++).toASN1Primitive()) instanceof ASN1TaggedObject) {
            this.b = OriginatorInfo.getInstance((ASN1TaggedObject)aSN1Primitive, false);
            aSN1Primitive = aSN1Sequence.getObjectAt(n2++).toASN1Primitive();
        }
        this.c = ASN1Set.getInstance(aSN1Primitive);
        if (this.c.size() == 0) {
            throw new IllegalArgumentException("AuthEnvelopedData requires at least 1 RecipientInfo");
        }
        aSN1Primitive = aSN1Sequence.getObjectAt(n2++).toASN1Primitive();
        this.d = EncryptedContentInfo.getInstance(aSN1Primitive);
        if ((aSN1Primitive = aSN1Sequence.getObjectAt(n2++).toASN1Primitive()) instanceof ASN1TaggedObject) {
            this.e = ASN1Set.getInstance((ASN1TaggedObject)aSN1Primitive, false);
            aSN1Primitive = aSN1Sequence.getObjectAt(n2++).toASN1Primitive();
        } else if (!(this.d.getContentType().equals(CMSObjectIdentifiers.data) || this.e != null && this.e.size() != 0)) {
            throw new IllegalArgumentException("authAttrs must be present with non-data content");
        }
        this.f = ASN1OctetString.getInstance(aSN1Primitive);
        if (aSN1Sequence.size() > n2) {
            aSN1Primitive = aSN1Sequence.getObjectAt(n2).toASN1Primitive();
            this.g = ASN1Set.getInstance((ASN1TaggedObject)aSN1Primitive, false);
        }
    }

    public static AuthEnvelopedData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return AuthEnvelopedData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static AuthEnvelopedData getInstance(Object object) {
        if (object == null || object instanceof AuthEnvelopedData) {
            return (AuthEnvelopedData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new AuthEnvelopedData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid AuthEnvelopedData: " + object.getClass().getName());
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.b;
    }

    public ASN1Set getRecipientInfos() {
        return this.c;
    }

    public EncryptedContentInfo getAuthEncryptedContentInfo() {
        return this.d;
    }

    public ASN1Set getAuthAttrs() {
        return this.e;
    }

    public ASN1OctetString getMac() {
        return this.f;
    }

    public ASN1Set getUnauthAttrs() {
        return this.g;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.b));
        }
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        if (this.e != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.e));
        }
        aSN1EncodableVector.add(this.f);
        if (this.g != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, this.g));
        }
        return new BERSequence(aSN1EncodableVector);
    }
}

