/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cmc;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.crmf.PKIPublicationInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.util.Arrays;

public class CMCPublicationInfo
extends ASN1Object {
    private final AlgorithmIdentifier a;
    private final ASN1Sequence b;
    private final PKIPublicationInfo c;

    public CMCPublicationInfo(AlgorithmIdentifier algorithmIdentifier, byte[][] byArray, PKIPublicationInfo pKIPublicationInfo) {
        this.a = algorithmIdentifier;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            aSN1EncodableVector.add(new DEROctetString(Arrays.clone(byArray[i2])));
        }
        this.b = new DERSequence(aSN1EncodableVector);
        this.c = pKIPublicationInfo;
    }

    private CMCPublicationInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
        this.c = PKIPublicationInfo.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public static CMCPublicationInfo getInstance(Object object) {
        if (object instanceof CMCPublicationInfo) {
            return (CMCPublicationInfo)object;
        }
        if (object != null) {
            return new CMCPublicationInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.a;
    }

    public byte[][] getCertHashes() {
        byte[][] byArrayArray = new byte[this.b.size()][];
        for (int i2 = 0; i2 != byArrayArray.length; ++i2) {
            byArrayArray[i2] = Arrays.clone(ASN1OctetString.getInstance(this.b.getObjectAt(i2)).getOctets());
        }
        return byArrayArray;
    }

    public PKIPublicationInfo getPubInfo() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

