/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.bc;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncryptedObjectStoreData
extends ASN1Object {
    private final AlgorithmIdentifier a;
    private final ASN1OctetString b;

    public EncryptedObjectStoreData(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.a = algorithmIdentifier;
        this.b = new DEROctetString(byArray);
    }

    private EncryptedObjectStoreData(ASN1Sequence aSN1Sequence) {
        this.a = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public static EncryptedObjectStoreData getInstance(Object object) {
        if (object instanceof EncryptedObjectStoreData) {
            return (EncryptedObjectStoreData)object;
        }
        if (object != null) {
            return new EncryptedObjectStoreData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1OctetString getEncryptedContent() {
        return this.b;
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

