/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.exporters.cadapsentitiesexporter.cadaps3d;

import com.aspose.cad.exporters.cadapsentitiesexporter.cadaps3d.Point3D;
import com.aspose.cad.internal.Exceptions.InvalidOperationException;
import com.aspose.cad.internal.F.B;
import com.aspose.cad.internal.F.aW;
import com.aspose.cad.internal.F.aa;
import com.aspose.cad.internal.F.an;
import com.aspose.cad.internal.F.bD;
import com.aspose.cad.internal.au.A;
import com.aspose.cad.internal.eL.d;

public class TransformationMatrix
implements an {
    private double[][] a = new double[4][4];

    public TransformationMatrix() {
        this.identity();
    }

    public TransformationMatrix(double[] dArray, boolean bl2) {
        int n2 = dArray.length == 12 ? 1 : 0;
        int n3 = bl2 ? 1 : 0;
        for (int i2 = 0; i2 < 3 + n3; ++i2) {
            for (int i3 = 0; i3 < 3 + n2 + n3; ++i3) {
                if (bl2) {
                    this.a[i3][i2] = dArray[i2 * (3 + n2 + n3) + i3];
                    continue;
                }
                this.a[i2][i3] = dArray[i2 * (3 + n2 + n3) + i3];
            }
        }
        this.a[3][3] = 1.0;
    }

    public double[][] getMatrix() {
        return this.a;
    }

    public void setMatrix(double[][] dArray) {
        this.a = dArray;
    }

    public static TransformationMatrix copy(TransformationMatrix transformationMatrix) {
        TransformationMatrix transformationMatrix2 = new TransformationMatrix();
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                transformationMatrix2.getMatrix()[i2][i3] = transformationMatrix.getMatrix()[i2][i3];
            }
        }
        return transformationMatrix2;
    }

    public static TransformationMatrix scale(double d2, double d3, double d4) {
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        transformationMatrix.a[0][0] = d2;
        transformationMatrix.a[1][1] = d3;
        transformationMatrix.a[2][2] = d4;
        return transformationMatrix;
    }

    public static TransformationMatrix fromAxis(Point3D point3D, Point3D point3D2, Point3D point3D3) {
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        transformationMatrix.a[0][0] = point3D.getX();
        transformationMatrix.a[1][0] = point3D.getY();
        transformationMatrix.a[2][0] = point3D.getZ();
        transformationMatrix.a[0][1] = point3D2.getX();
        transformationMatrix.a[1][1] = point3D2.getY();
        transformationMatrix.a[2][1] = point3D2.getZ();
        transformationMatrix.a[0][2] = point3D3.getX();
        transformationMatrix.a[1][2] = point3D3.getY();
        transformationMatrix.a[2][2] = point3D3.getZ();
        return transformationMatrix;
    }

    public static TransformationMatrix rotateX(double d2) {
        d2 = d2 * Math.PI / 180.0;
        double d3 = bD.g(d2);
        double d4 = bD.h(d2);
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        transformationMatrix.a[1][1] = d4;
        transformationMatrix.a[1][2] = -d3;
        transformationMatrix.a[2][1] = d3;
        transformationMatrix.a[2][2] = d4;
        return transformationMatrix;
    }

    public static TransformationMatrix rotateY(double d2) {
        d2 = d2 * Math.PI / 180.0;
        double d3 = bD.g(d2);
        double d4 = bD.h(d2);
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        transformationMatrix.a[0][0] = d4;
        transformationMatrix.a[0][2] = d3;
        transformationMatrix.a[2][0] = -d3;
        transformationMatrix.a[2][2] = d4;
        return transformationMatrix;
    }

    public static TransformationMatrix rotateZ(double d2) {
        d2 = d2 * Math.PI / 180.0;
        double d3 = bD.g(d2);
        double d4 = bD.h(d2);
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        transformationMatrix.a[0][0] = d4;
        transformationMatrix.a[0][1] = -d3;
        transformationMatrix.a[1][0] = d3;
        transformationMatrix.a[1][1] = d4;
        return transformationMatrix;
    }

    public static TransformationMatrix topView() {
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        transformationMatrix.a[1][1] = 0.0;
        transformationMatrix.a[2][2] = 0.0;
        transformationMatrix.a[1][2] = -1.0;
        return transformationMatrix;
    }

    public static TransformationMatrix frontView() {
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        transformationMatrix.a[2][2] = 0.0;
        return transformationMatrix;
    }

    public static TransformationMatrix sideView() {
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        transformationMatrix.a[0][0] = 0.0;
        transformationMatrix.a[2][2] = 0.0;
        transformationMatrix.a[0][2] = -1.0;
        return transformationMatrix;
    }

    public static TransformationMatrix op_Multiply(TransformationMatrix transformationMatrix, double d2) {
        TransformationMatrix transformationMatrix2 = new TransformationMatrix();
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                transformationMatrix2.a[i2][i3] = transformationMatrix.a[i2][i3] * d2;
            }
        }
        return transformationMatrix2;
    }

    public static TransformationMatrix op_Addition(TransformationMatrix transformationMatrix, TransformationMatrix transformationMatrix2) {
        TransformationMatrix transformationMatrix3 = new TransformationMatrix();
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                transformationMatrix3.a[i2][i3] = transformationMatrix.a[i2][i3] + transformationMatrix2.a[i2][i3];
            }
        }
        return transformationMatrix3;
    }

    public static TransformationMatrix perspective(double d2, double d3, double d4, double d5, double d6) {
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        transformationMatrix.a[0][0] = 1.0 / bD.i(d2 / 2.0) / d3;
        transformationMatrix.a[0][1] = 0.0;
        transformationMatrix.a[0][2] = 0.0;
        transformationMatrix.a[0][3] = 0.0;
        transformationMatrix.a[1][0] = 0.0;
        transformationMatrix.a[1][1] = 1.0 / bD.i(d2 / 2.0);
        transformationMatrix.a[1][2] = 0.0;
        transformationMatrix.a[1][3] = 0.0;
        transformationMatrix.a[2][0] = 0.0;
        transformationMatrix.a[2][1] = 0.0;
        transformationMatrix.a[2][2] = (d4 + d5) / (d4 - d5);
        transformationMatrix.a[2][3] = 2.0 * d4 * d5 / (d4 - d5);
        transformationMatrix.a[3][0] = 0.0;
        transformationMatrix.a[3][1] = 0.0;
        transformationMatrix.a[3][2] = -1.0 / d6;
        transformationMatrix.a[3][3] = 1.0;
        return transformationMatrix;
    }

    public static TransformationMatrix transpose(TransformationMatrix transformationMatrix) {
        TransformationMatrix transformationMatrix2 = new TransformationMatrix();
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                transformationMatrix2.a[i2][i3] = transformationMatrix.a[i3][i2];
            }
        }
        return transformationMatrix2;
    }

    public static TransformationMatrix axonometric(double d2, double d3) {
        double d4;
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        double d5 = bD.g(d2 * Math.PI / 180.0);
        double d6 = bD.h(d2 * Math.PI / 180.0);
        double d7 = bD.g(d3 * Math.PI / 180.0);
        transformationMatrix.a[0][0] = d4 = bD.h(d3 * Math.PI / 180.0);
        transformationMatrix.a[0][2] = d7;
        transformationMatrix.a[1][0] = d5 * d7;
        transformationMatrix.a[1][1] = d6;
        transformationMatrix.a[1][2] = -d5 * d4;
        transformationMatrix.a[2][2] = 0.0;
        return transformationMatrix;
    }

    public static TransformationMatrix translate(double d2, double d3, double d4) {
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        transformationMatrix.a[0][3] = d2;
        transformationMatrix.a[1][3] = d3;
        transformationMatrix.a[2][3] = d4;
        return transformationMatrix;
    }

    public static TransformationMatrix op_Multiply(TransformationMatrix transformationMatrix, TransformationMatrix transformationMatrix2) {
        TransformationMatrix transformationMatrix3 = new TransformationMatrix();
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                double d2 = 0.0;
                for (int i4 = 0; i4 < 4; ++i4) {
                    d2 += transformationMatrix.a[i2][i4] * transformationMatrix2.a[i4][i3];
                }
                transformationMatrix3.a[i2][i3] = d2;
            }
        }
        return transformationMatrix3;
    }

    public double[] vectorMultiply(double[] dArray) {
        double[] dArray2 = new double[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                int n2 = i2;
                dArray2[n2] = dArray2[n2] + this.a[i2][i3] * dArray[i3];
            }
        }
        return dArray2;
    }

    public static TransformationMatrix getWCS(Point3D point3D) {
        Point3D point3D2 = new Point3D(0.0, 1.0, 0.0, 1.0);
        Point3D point3D3 = new Point3D(0.0, 0.0, 1.0, 1.0);
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        Point3D point3D4 = bD.a(point3D.getX()) < 0.015625 && bD.a(point3D.getY()) < 0.015625 ? Point3D.crossProduct(point3D2, point3D) : Point3D.crossProduct(point3D3, point3D);
        point3D4 = point3D4.normalize();
        Point3D point3D5 = Point3D.crossProduct(point3D, point3D4).normalize();
        transformationMatrix.getMatrix()[0][0] = point3D4.getX();
        transformationMatrix.getMatrix()[0][1] = point3D4.getY();
        transformationMatrix.getMatrix()[0][2] = point3D4.getZ();
        transformationMatrix.getMatrix()[1][0] = -point3D5.getX();
        transformationMatrix.getMatrix()[1][1] = -point3D5.getY();
        transformationMatrix.getMatrix()[1][2] = -point3D5.getZ();
        transformationMatrix.getMatrix()[2][0] = -point3D.getX();
        transformationMatrix.getMatrix()[2][1] = -point3D.getY();
        transformationMatrix.getMatrix()[2][2] = -point3D.getZ();
        transformationMatrix.getMatrix()[3][0] = 0.0;
        transformationMatrix.getMatrix()[3][1] = 0.0;
        transformationMatrix.getMatrix()[3][2] = 0.0;
        return transformationMatrix;
    }

    public static TransformationMatrix ucsToWcs(Point3D point3D, Point3D point3D2) {
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        transformationMatrix.getMatrix()[0][0] = point3D.getX();
        transformationMatrix.getMatrix()[0][1] = point3D.getY();
        transformationMatrix.getMatrix()[0][2] = point3D.getZ();
        transformationMatrix.getMatrix()[1][0] = -point3D2.getX();
        transformationMatrix.getMatrix()[1][1] = -point3D2.getY();
        transformationMatrix.getMatrix()[1][2] = -point3D2.getZ();
        transformationMatrix.getMatrix()[2][0] = 0.0;
        transformationMatrix.getMatrix()[2][1] = 0.0;
        transformationMatrix.getMatrix()[2][2] = 0.0;
        transformationMatrix.getMatrix()[3][0] = 0.0;
        transformationMatrix.getMatrix()[3][1] = 0.0;
        transformationMatrix.getMatrix()[3][2] = 0.0;
        return TransformationMatrix.op_Multiply(transformationMatrix, TransformationMatrix.scale(1.0, -1.0, 1.0));
    }

    public static TransformationMatrix oCStoWCS(Point3D point3D) {
        Point3D point3D2 = new Point3D(0.0, 1.0, 0.0, 1.0);
        Point3D point3D3 = new Point3D(0.0, 0.0, 1.0, 1.0);
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        Point3D point3D4 = bD.a(point3D.getX()) < 0.015625 && bD.a(point3D.getY()) < 0.015625 ? Point3D.crossProduct(point3D2, point3D) : Point3D.crossProduct(point3D3, point3D);
        point3D4 = point3D4.normalize();
        Point3D point3D5 = Point3D.crossProduct(point3D, point3D4).normalize();
        transformationMatrix.a[0][0] = point3D4.getX();
        transformationMatrix.a[0][1] = point3D5.getX();
        transformationMatrix.a[0][2] = point3D.getX();
        transformationMatrix.a[0][3] = 0.0;
        transformationMatrix.a[1][0] = point3D4.getY();
        transformationMatrix.a[1][1] = point3D5.getY();
        transformationMatrix.a[1][2] = point3D.getY();
        transformationMatrix.a[1][3] = 0.0;
        transformationMatrix.a[2][0] = point3D4.getZ();
        transformationMatrix.a[2][1] = point3D5.getZ();
        transformationMatrix.a[2][2] = point3D.getZ();
        transformationMatrix.a[2][3] = 0.0;
        transformationMatrix.a[3][0] = 0.0;
        transformationMatrix.a[3][1] = 0.0;
        transformationMatrix.a[3][2] = 0.0;
        transformationMatrix.a[3][3] = 1.0;
        return transformationMatrix;
    }

    public TransformationMatrix invert() {
        int n2 = 4;
        double[][] dArray = new double[n2][n2];
        TransformationMatrix transformationMatrix = (TransformationMatrix)this.deepClone();
        int[] nArray = TransformationMatrix.a(transformationMatrix.a);
        for (int i2 = 0; i2 < n2; ++i2) {
            double[] dArray2 = new double[n2];
            dArray2[i2] = 1.0;
            double[] dArray3 = TransformationMatrix.a(transformationMatrix.a, nArray, dArray2);
            for (int i3 = 0; i3 < dArray3.length; ++i3) {
                dArray[i3][i2] = dArray3[i3];
            }
        }
        TransformationMatrix transformationMatrix2 = new TransformationMatrix();
        transformationMatrix2.a = dArray;
        return transformationMatrix2;
    }

    @Override
    public Object deepClone() {
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            System.arraycopy(this.a[i2], 0, transformationMatrix.a[i2], 0, this.a[i2].length);
        }
        return transformationMatrix;
    }

    String toFormattedString() {
        A a2 = new A();
        String string = "{0}\t{1}\t{2}\t{3}\n";
        for (int i2 = 0; i2 < 4; ++i2) {
            a2.a(string, d.h(this.a[i2][0]), d.h(this.a[i2][1]), d.h(this.a[i2][2]), d.h(this.a[i2][3]));
        }
        return a2.toString();
    }

    public double determinant() {
        int n2;
        int n3;
        double d2 = 0.0;
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 0; n2 < 4; ++n2) {
                transformationMatrix.getMatrix()[n3][n2] = this.getMatrix()[n3][n2];
            }
        }
        for (n3 = 0; n3 < 3; ++n3) {
            for (n2 = n3 + 1; n2 < 4; ++n2) {
                d2 = transformationMatrix.getMatrix()[n2][n3] / transformationMatrix.getMatrix()[n3][n3];
                for (int i2 = n3; i2 < 4; ++i2) {
                    transformationMatrix.getMatrix()[n2][i2] = transformationMatrix.getMatrix()[n2][i2] - d2 * transformationMatrix.getMatrix()[n3][i2];
                }
            }
        }
        d2 = 1.0;
        for (n3 = 0; n3 < 4; ++n3) {
            d2 *= transformationMatrix.getMatrix()[n3][n3];
        }
        return d2;
    }

    protected void identity() {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                this.a[i2][i3] = i2 == i3 ? 1.0 : 0.0;
            }
        }
    }

    void printMatrix() {
        for (int i2 = 0; i2 < 4; ++i2) {
            String string = aW.a;
            for (int i3 = 0; i3 < 4; ++i3) {
                string = aW.a(string, aW.a(new String[]{aa.a(this.a[i2][i3], "0.000"), "\t\t"}));
            }
            B.b(string);
        }
    }

    private static double[] a(double[][] dArray, int[] nArray, double[] dArray2) {
        int n2;
        int n3;
        int n4 = d.e(bD.d(bD.s(dArray.length * dArray[0].length))) - 1;
        double[] dArray3 = new double[n4 + 1];
        double[] dArray4 = new double[n4 + 1];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n3 = 0; n3 <= n4; ++n3) {
            d2 = 0.0;
            for (n2 = 0; n2 <= n3 - 1; ++n2) {
                d4 = n3 == n2 ? 1.0 : dArray[n3][n2];
                d2 += d4 * dArray4[n2];
            }
            dArray4[n3] = dArray2[nArray[n3]] - d2;
        }
        for (n3 = n4; n3 >= 0; --n3) {
            d3 = 0.0;
            for (n2 = n3 + 1; n2 <= n4; ++n2) {
                d3 += dArray[n3][n2] * dArray3[n2];
            }
            dArray3[n3] = (dArray4[n3] - d3) / dArray[n3][n3];
        }
        return dArray3;
    }

    private static int[] a(double[][] dArray) {
        int n2;
        int n3 = d.e(bD.d(bD.s(dArray.length * dArray[0].length))) - 1;
        int[] nArray = new int[n3 + 1];
        double d2 = 0.0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n2 = 0; n2 <= n3; ++n2) {
            nArray[n2] = n2;
        }
        for (n2 = 0; n2 <= n3; ++n2) {
            int n7;
            d2 = 0.0;
            for (n7 = n2; n7 <= n3; ++n7) {
                if (!(bD.a(dArray[n7][n2]) > d2)) continue;
                d2 = bD.a(dArray[n7][n2]);
                n4 = n7;
            }
            if (bD.a(d2) < 1.0E-10) {
                throw new InvalidOperationException("singular matrix");
            }
            n5 = nArray[n2];
            nArray[n2] = n6 = nArray[n4];
            nArray[n4] = n5;
            for (n7 = 0; n7 <= n3; ++n7) {
                d3 = dArray[n2][n7];
                dArray[n2][n7] = d4 = dArray[n4][n7];
                dArray[n4][n7] = d3;
            }
            for (n7 = n2 + 1; n7 <= n3; ++n7) {
                dArray[n7][n2] = dArray[n7][n2] / dArray[n2][n2];
                for (int i2 = n2 + 1; i2 <= n3; ++i2) {
                    dArray[n7][i2] = dArray[n7][i2] - dArray[n7][n2] * dArray[n2][i2];
                }
            }
        }
        return nArray;
    }
}

