/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.complexbarcode;

import com.aspose.barcode.BarCodeException;
import com.aspose.barcode.complexbarcode.Address;
import com.aspose.barcode.complexbarcode.AddressType;
import com.aspose.barcode.complexbarcode.AlternativeScheme;
import com.aspose.barcode.complexbarcode.IComplexCodetext;
import com.aspose.barcode.complexbarcode.QrBillStandardVersion;
import com.aspose.barcode.complexbarcode.SwissQRBill;
import com.aspose.barcode.complexbarcode.yy;
import com.aspose.barcode.generation.BaseEncodeType;
import com.aspose.barcode.generation.EncodeTypes;
import com.aspose.barcode.internal.bbr.hhq;
import com.aspose.barcode.internal.bbr.kkd;
import com.aspose.barcode.internal.bbr.kke;
import com.aspose.barcode.internal.ccr.jj;
import com.aspose.barcode.internal.oot.ii;
import com.aspose.barcode.internal.oot.nn;
import com.aspose.barcode.internal.zzt.ttd;

public final class SwissQRCodetext
implements IComplexCodetext {
    private SwissQRBill a;
    private static final nn b = SwissQRCodetext.a();

    public SwissQRBill getBill() {
        return this.a;
    }

    public SwissQRCodetext(SwissQRBill bill) {
        this.a = bill;
    }

    public SwissQRCodetext() {
        this.a = new SwissQRBill();
    }

    @Override
    public String getConstructedCodetext() {
        SwissQRCodetext.a(this.a);
        ttd ttd2 = new ttd();
        ttd2.a("SPC\n");
        ttd2.a("0200\n");
        ttd2.a("1");
        this.a(this.a.getAccount(), ttd2);
        this.a(this.a.getCreditor(), ttd2);
        ttd2.a("\n\n\n\n\n\n\n");
        if (SwissQRCodetext.a(this.a.getAmount())) {
            this.a(SwissQRCodetext.a(new kkd(Double.toString(this.a.getAmount()))), ttd2);
        } else {
            this.a("", ttd2);
        }
        this.a(this.a.getCurrency(), ttd2);
        this.a(this.a.getDebtor(), ttd2);
        String string = "NON";
        if (this.a.getReference() != null) {
            if (kke.b(this.a.getReference(), "RF")) {
                string = "SCOR";
            } else if (this.a.getReference().length() > 0) {
                string = "QRR";
            }
        }
        this.a(string, ttd2);
        this.a(this.a.getReference(), ttd2);
        this.a(this.a.getUnstructuredMessage(), ttd2);
        this.a("EPD", ttd2);
        if (!kke.b(this.a.getBillInformation())) {
            this.a(this.a.getBillInformation(), ttd2);
        }
        if (this.a.getAlternativeSchemes() != null && this.a.getAlternativeSchemes().size() > 0) {
            this.a(this.a.getAlternativeSchemes().get(0).getInstruction(), ttd2);
            if (this.a.getAlternativeSchemes().size() > 1) {
                this.a(this.a.getAlternativeSchemes().get(1).getInstruction(), ttd2);
            }
        }
        return ttd2.toString();
    }

    private static void a(SwissQRBill swissQRBill) {
        if (kke.b(swissQRBill.getAccount()) || !yy.a(swissQRBill.getAccount())) {
            SwissQRCodetext.b("Account must be a valid IBAN.");
        }
        if (kke.b(swissQRBill.getCreditor().getName())) {
            SwissQRCodetext.b("Creditor's name is a mandatory field and can't be empty.");
        }
        if (swissQRBill.getCreditor().getType() == AddressType.STRUCTURED) {
            if (kke.b(swissQRBill.getCreditor().getPostalCode())) {
                SwissQRCodetext.b("Creditor's PostalCode is a mandatory field in structured address mode and can't be empty.");
            }
            if (swissQRBill.getCreditor().getPostalCode().length() > 16) {
                SwissQRCodetext.b("Creditor's PostalCode is maximun lenght is 16 characters.");
            }
            if (kke.b(swissQRBill.getCreditor().getTown())) {
                SwissQRCodetext.b("Creditor's Town is a mandatory field in structured address mode and can't be empty.");
            }
        }
        if (swissQRBill.getCreditor().getCountryCode().length() != 2) {
            SwissQRCodetext.b("Creditor's CountryCode is a mandatory field and must be valid two-letter ISO country code.");
        }
        if (!swissQRBill.getCurrency().equals("CHF") && !swissQRBill.getCurrency().equals("EUR")) {
            SwissQRCodetext.b("Currency is a mandatory field and valid values are \"CHF\" and \"EUR\"");
        }
        if (swissQRBill.getDebtor() != null && swissQRBill.getDebtor().getType() != AddressType.UNDETERMINED) {
            if (kke.b(swissQRBill.getDebtor().getName())) {
                SwissQRCodetext.b("Debtor's name is a mandatory field and can't be empty.");
            }
            if (swissQRBill.getDebtor().getType() == AddressType.STRUCTURED) {
                if (kke.b(swissQRBill.getDebtor().getPostalCode())) {
                    SwissQRCodetext.b("Debtor's PostalCode is a mandatory field in structured address mode and can't be empty.");
                }
                if (swissQRBill.getDebtor().getPostalCode().length() > 16) {
                    SwissQRCodetext.b("Debtor's PostalCode is maximun lenght is 16 characters.");
                }
                if (kke.b(swissQRBill.getDebtor().getTown())) {
                    SwissQRCodetext.b("Debtor's Town is a mandatory field in structured address mode and can't be empty.");
                }
            }
            if (swissQRBill.getDebtor().getCountryCode().length() != 2) {
                SwissQRCodetext.b("Debtor's CountryCode is a mandatory field and must be valid two-letter ISO country code.");
            }
        }
    }

    @Override
    public void initFromString(String constructedCodetext) {
        int n;
        String[] stringArray = SwissQRCodetext.a(constructedCodetext);
        if (stringArray.length < 31 || stringArray.length > 34) {
            SwissQRCodetext.b();
        }
        if (!"SPC".equals(stringArray[0])) {
            SwissQRCodetext.b();
        }
        if (!"0200".equals(stringArray[1])) {
            SwissQRCodetext.b();
        }
        if (!"1".equals(stringArray[2])) {
            SwissQRCodetext.b();
        }
        SwissQRBill swissQRBill = new SwissQRBill();
        swissQRBill.setVersion(QrBillStandardVersion.V2_0);
        swissQRBill.setAccount(stringArray[3]);
        swissQRBill.setCreditor(SwissQRCodetext.a(stringArray, 4, false));
        if (stringArray[18].length() > 0) {
            kkd[] kkdArray = new kkd[1];
            if (kkd.a(stringArray[18], kkdArray)) {
                swissQRBill.setAmount(kkd.D(kkdArray[0]));
            } else {
                SwissQRCodetext.b();
            }
        } else {
            swissQRBill.setAmount(0.0);
        }
        swissQRBill.setCurrency(stringArray[19]);
        swissQRBill.setDebtor(SwissQRCodetext.a(stringArray, 20, true));
        swissQRBill.setReference(stringArray[28]);
        swissQRBill.setUnstructuredMessage(stringArray[29]);
        if (!"EPD".equals(stringArray[30])) {
            SwissQRCodetext.b();
        }
        if (stringArray.length > 31) {
            swissQRBill.setBillInformation(stringArray[31]);
        }
        if ((n = stringArray.length - 32) > 0) {
            for (int i = 0; i < n; ++i) {
                AlternativeScheme alternativeScheme = new AlternativeScheme();
                alternativeScheme.setInstruction(stringArray[32 + i]);
                swissQRBill.getAlternativeSchemes().add(alternativeScheme);
            }
        }
        this.a = swissQRBill;
    }

    @Override
    public BaseEncodeType getBarcodeType() {
        return EncodeTypes.QR;
    }

    private void a(Address address, ttd ttd2) {
        if (address != null && !address.a()) {
            this.a(address.getType() == AddressType.STRUCTURED ? "S" : "K", ttd2);
            this.a(address.getName(), ttd2);
            this.a(address.getType() == AddressType.STRUCTURED ? address.getStreet() : address.getAddressLine1(), ttd2);
            this.a(address.getType() == AddressType.STRUCTURED ? address.getHouseNo() : address.getAddressLine2(), ttd2);
            this.a(address.getPostalCode(), ttd2);
            this.a(address.getTown(), ttd2);
            this.a(address.getCountryCode(), ttd2);
        } else {
            ttd2.a("\n\n\n\n\n\n\n");
        }
    }

    private void a(String string, ttd ttd2) {
        if (string == null) {
            string = "";
        }
        ttd2.a('\n').a(string);
    }

    private static boolean a(double d) {
        return d >= 0.01 && d <= 9.9999999999E8;
    }

    private static String a(kkd kkd2) {
        return kkd2.a("n", (hhq)b);
    }

    private static nn a() {
        nn nn2 = ii.e().w();
        nn2.b(2);
        nn2.d(".");
        nn2.e("");
        return nn2;
    }

    private static Address a(String[] stringArray, int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = stringArray[n].length() == 0 && stringArray[n + 1].length() == 0 && stringArray[n + 2].length() == 0 && stringArray[n + 3].length() == 0 && stringArray[n + 4].length() == 0 && stringArray[n + 5].length() == 0 && stringArray[n + 6].length() == 0;
        if (bl2 && bl) {
            return null;
        }
        Address address = new Address();
        boolean bl4 = "S".equals(stringArray[n]);
        address.setName(stringArray[n + 1]);
        if (bl4) {
            address.setStreet(stringArray[n + 2]);
            address.setHouseNo(stringArray[n + 3]);
        } else {
            address.setAddressLine1(stringArray[n + 2]);
            address.setAddressLine2(stringArray[n + 3]);
        }
        if (stringArray[n + 4].length() > 0) {
            address.setPostalCode(stringArray[n + 4]);
        }
        if (stringArray[n + 5].length() > 0) {
            address.setTown(stringArray[n + 5]);
        }
        address.setCountryCode(stringArray[n + 6]);
        return address;
    }

    private static String[] a(String string) {
        int n;
        jj<String> jj2 = new jj<String>(32);
        int n2 = 0;
        while ((n = kke.b(string, '\n', n2)) >= 0) {
            int n3 = n;
            if (n3 > n2 && string.charAt(n3 - 1) == '\r') {
                --n3;
            }
            jj2.b(kke.b(string, n2, n3 - n2));
            n2 = n + 1;
        }
        jj2.b(kke.b(string, n2, string.length() - n2));
        return jj2.toArray(new String[0]);
    }

    private static void b(String string) {
        throw new BarCodeException(string);
    }

    private static void b() {
        SwissQRCodetext.b("");
    }
}

