/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.barcode.barcoderecognition;

import com.aspose.barcode.barcoderecognition.BarCodeResult;
import com.aspose.barcode.barcoderecognition.BarcodeSettings;
import com.aspose.barcode.barcoderecognition.BaseDecodeType;
import com.aspose.barcode.barcoderecognition.ChecksumValidation;
import com.aspose.barcode.barcoderecognition.CustomerInformationInterpretingType;
import com.aspose.barcode.barcoderecognition.DecodeType;
import com.aspose.barcode.barcoderecognition.MultyDecodeType;
import com.aspose.barcode.barcoderecognition.ProcessorSettings;
import com.aspose.barcode.barcoderecognition.QualitySettings;
import com.aspose.barcode.barcoderecognition.SingleDecodeType;
import com.aspose.barcode.internal.bbf.yy;
import com.aspose.barcode.internal.ccf.ww;
import com.aspose.barcode.internal.ccr.rrd;
import com.aspose.barcode.internal.gg.dd;
import com.aspose.barcode.internal.gg.ii;
import com.aspose.barcode.internal.kkr.kk;
import com.aspose.barcode.internal.kkr.tt;
import com.aspose.barcode.internal.llr.kke;
import com.aspose.barcode.internal.qqt.lld;
import com.aspose.barcode.internal.uut.ff;
import com.aspose.barcode.internal.uut.hh;
import com.aspose.barcode.internal.uut.oo;
import com.aspose.barcode.internal.uut.vv;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@rrd(a=true)
public class BarCodeReader {
    private static final ProcessorSettings processorSettings = new ProcessorSettings(true);
    private ii _readerImplementation = new ii();

    boolean isLicensed() {
        return this._readerImplementation.a().a();
    }

    public static ProcessorSettings getProcessorSettings() {
        return processorSettings;
    }

    public int getTimeout() {
        return this._readerImplementation.b();
    }

    public void setTimeout(int value) {
        this._readerImplementation.a(value);
    }

    @Deprecated
    public ChecksumValidation getChecksumValidation() {
        return this._readerImplementation.c.getChecksumValidation();
    }

    @Deprecated
    public void setChecksumValidation(ChecksumValidation value) {
        this._readerImplementation.c.setChecksumValidation(value);
    }

    @Deprecated
    public void setChecksumValidation(int value) {
        this.setChecksumValidation(ChecksumValidation.values()[value]);
    }

    @Deprecated
    public boolean getStripFNC() {
        return this._readerImplementation.c.getStripFNC();
    }

    @Deprecated
    public void setStripFNC(boolean value) {
        this._readerImplementation.c.setStripFNC(value);
    }

    @Deprecated
    public CustomerInformationInterpretingType getCustomerInformationInterpretingType() {
        return this._readerImplementation.c.getAustraliaPost().getCustomerInformationInterpretingType();
    }

    @Deprecated
    public void setCustomerInformationInterpretingType(CustomerInformationInterpretingType value) {
        this._readerImplementation.c.getAustraliaPost().setCustomerInformationInterpretingType(value);
    }

    public void setCustomerInformationInterpretingType(int value) {
        this.setCustomerInformationInterpretingType(CustomerInformationInterpretingType.values()[value]);
    }

    public void abort() {
        ii ii2 = this._readerImplementation;
        try {
            if (null != ii2) {
                ii2.e();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public BarCodeResult[] getFoundBarCodes() {
        return this._readerImplementation.d;
    }

    public int getFoundCount() {
        return this._readerImplementation.d.length;
    }

    public BarCodeResult[] readBarCodes() {
        this._readerImplementation.f();
        return this._readerImplementation.d;
    }

    public final QualitySettings getQualitySettings() {
        return this._readerImplementation.d();
    }

    public final void setQualitySettings(QualitySettings value) {
        if (null != value) {
            this._readerImplementation.a(value);
        }
    }

    public BarcodeSettings getBarcodeSettings() {
        return this._readerImplementation.c;
    }

    @Deprecated
    public boolean getDetectEncoding() {
        return this._readerImplementation.c.getDetectEncoding();
    }

    @Deprecated
    public void setDetectEncoding(boolean value) {
        this._readerImplementation.c.setDetectEncoding(value);
    }

    public BarCodeReader() {
        this._readerImplementation = new ii();
        this.setBarCodeReadType(DecodeType.ALL_SUPPORTED_TYPES);
    }

    public final void setBarCodeImage(BufferedImage value, Rectangle[] areas) {
        lld[] lldArray = new lld[areas.length];
        for (int i = 0; i < areas.length; ++i) {
            lldArray[i] = lld.a(areas[i]);
        }
        this.setBarCodeImageInternal(BarCodeReader.convertBufferedImageToBitmap(value), lldArray);
    }

    public final void setBarCodeImage(BufferedImage value, Rectangle area) {
        this.setBarCodeImageInternal(BarCodeReader.convertBufferedImageToBitmap(value), lld.a(area));
    }

    public final void setBarCodeImage(InputStream stream) {
        this.setBarCodeImageInternal(vv.b(stream));
    }

    final void setBarCodeImageInternal(com.aspose.barcode.internal.qqt.ww value) {
        if (this._readerImplementation == null) {
            this._readerImplementation = new ii();
        }
        com.aspose.barcode.internal.qqt.ww ww2 = BarCodeReader.copyBitmap(value);
        yy yy2 = new yy(ww2);
        this._readerImplementation.a(ww2);
        yy2.a();
    }

    final void setBarCodeImageInternal(com.aspose.barcode.internal.qqt.ww value, lld[] areas) {
        if (this._readerImplementation == null) {
            this._readerImplementation = new ii();
        }
        com.aspose.barcode.internal.qqt.ww ww2 = BarCodeReader.copyBitmap(value);
        yy yy2 = new yy(ww2, areas);
        this._readerImplementation.a(ww2, areas);
        yy2.a();
    }

    final void setBarCodeImageInternal(com.aspose.barcode.internal.qqt.ww value, lld area) {
        if (this._readerImplementation == null) {
            this._readerImplementation = new ii();
        }
        com.aspose.barcode.internal.qqt.ww ww2 = BarCodeReader.copyBitmap(value);
        yy yy2 = new yy(ww2, area);
        this._readerImplementation.a(ww2, area.m());
        yy2.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static com.aspose.barcode.internal.qqt.ww getBitmapFromMemoryFile(String fileName) {
        com.aspose.barcode.internal.qqt.ww ww2 = null;
        byte[] byArray = null;
        ff ff2 = new ff(fileName, 3, 1, 1);
        try {
            byArray = new byte[(int)ff2.f()];
            ff2.a(byArray, 0, (int)ff2.f());
        }
        finally {
            if (ff2 != null) {
                ff2.c();
            }
        }
        hh hh2 = new hh(byArray);
        hh2.a(0L);
        ww2 = new com.aspose.barcode.internal.qqt.ww(hh2);
        return ww2;
    }

    public void setBarCodeImage(BufferedImage value) {
        this.setBarCodeImageInternal(BarCodeReader.convertBufferedImageToBitmap(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBarCodeImage(String filename) {
        com.aspose.barcode.internal.qqt.ww ww2;
        if (kke.b(filename) || !com.aspose.barcode.internal.uut.yy.c(filename)) {
            throw new IllegalArgumentException("Wrong filename passed.");
        }
        if (this._readerImplementation == null) {
            this._readerImplementation = new ii();
        }
        ff ff2 = new ff(filename, 3);
        try {
            ww2 = ww.a(ff2);
        }
        catch (kk kk2) {
            throw new IllegalArgumentException("Wrong filename passed.");
        }
        try {
            oo oo2 = new oo(filename);
            com.aspose.barcode.internal.bbf.ii.a().a((double)oo2.c() / 1048576.0);
            this._readerImplementation.a(BarCodeReader.copyBitmap(ww2));
        }
        finally {
            if (ww2 != null) {
                ww2.c();
            }
        }
        ff2.l();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setBarCodeImageInternal(vv stream) {
        if (stream == null) {
            throw new tt("stream");
        }
        if (this._readerImplementation == null) {
            this._readerImplementation = new ii();
        }
        com.aspose.barcode.internal.bbf.dd dd2 = new com.aspose.barcode.internal.bbf.dd(stream);
        com.aspose.barcode.internal.qqt.ww ww2 = new com.aspose.barcode.internal.qqt.ww(stream);
        try {
            this._readerImplementation.a(BarCodeReader.copyBitmap(ww2));
        }
        finally {
            if (ww2 != null) {
                ww2.c();
            }
        }
        dd2.a();
    }

    public void setBarCodeReadType(SingleDecodeType ... barcodeTypes) {
        this._readerImplementation.a(new MultyDecodeType(barcodeTypes));
    }

    public void setBarCodeReadType(BaseDecodeType type) {
        this._readerImplementation.a(type);
    }

    BarCodeReader(com.aspose.barcode.internal.qqt.ww image) {
        if (image == null) {
            throw new tt("image");
        }
        this._readerImplementation = new ii();
        this.setBarCodeReadType(DecodeType.ALL_SUPPORTED_TYPES);
        this.setBarCodeImageInternal(image);
    }

    private static com.aspose.barcode.internal.qqt.ww convertBufferedImageToBitmap(BufferedImage bufferedImage) {
        com.aspose.barcode.internal.qqt.ww ww2 = new com.aspose.barcode.internal.qqt.ww(bufferedImage.getWidth(), bufferedImage.getHeight());
        for (int i = 0; i < ww2.t(); ++i) {
            for (int j = 0; j < ww2.k(); ++j) {
                ww2.a(i, j, com.aspose.barcode.internal.qqt.yy.a(bufferedImage.getRGB(i, j)));
            }
        }
        return ww2;
    }

    public BarCodeReader(BufferedImage image) {
        this(BarCodeReader.convertBufferedImageToBitmap(image));
    }

    public BarCodeReader(BufferedImage image, BaseDecodeType decodeType) {
        this(BarCodeReader.convertBufferedImageToBitmap(image), decodeType);
    }

    public BarCodeReader(BufferedImage image, BaseDecodeType ... decodeTypes) {
        this(BarCodeReader.convertBufferedImageToBitmap(image), decodeTypes);
    }

    BarCodeReader(com.aspose.barcode.internal.qqt.ww image, BaseDecodeType ... decodeTypes) {
        this(image, (BaseDecodeType)new MultyDecodeType(decodeTypes));
    }

    BarCodeReader(com.aspose.barcode.internal.qqt.ww image, BaseDecodeType type) {
        if (image == null) {
            throw new tt("image");
        }
        this._readerImplementation = new ii();
        this.setBarCodeReadType(type);
        this.setBarCodeImageInternal(image);
    }

    private static com.aspose.barcode.internal.qqt.ww copyBitmap(com.aspose.barcode.internal.qqt.ww originalBitmap) {
        return dd.c(originalBitmap);
    }

    public BarCodeReader(BufferedImage image, Rectangle area, BaseDecodeType ... decodeTypes) {
        this(BarCodeReader.convertBufferedImageToBitmap(image), lld.a(area), decodeTypes);
    }

    BarCodeReader(com.aspose.barcode.internal.qqt.ww image, lld area, BaseDecodeType ... decodeTypes) {
        this(image, area.m(), (BaseDecodeType)new MultyDecodeType(decodeTypes));
    }

    BarCodeReader(com.aspose.barcode.internal.qqt.ww image, lld[] areas, BaseDecodeType type) {
        if (image == null) {
            throw new tt("image");
        }
        this._readerImplementation = new ii();
        this.setBarCodeReadType(type);
        this.setBarCodeImageInternal(image, areas);
    }

    public BarCodeReader(BufferedImage image, Rectangle[] areas, BaseDecodeType type) {
        this(BarCodeReader.convertBufferedImageToBitmap(image), BarCodeReader.convertRectangleAwtArrayToMsArray(areas), type);
    }

    BarCodeReader(com.aspose.barcode.internal.qqt.ww image, lld area, BaseDecodeType type) {
        if (image == null) {
            throw new tt("image");
        }
        this._readerImplementation = new ii();
        this.setBarCodeReadType(type);
        this.setBarCodeImageInternal(image, area.m());
    }

    private static lld[] convertRectangleAwtArrayToMsArray(Rectangle[] areas) {
        lld[] lldArray = new lld[areas.length];
        for (int i = 0; i < lldArray.length; ++i) {
            lldArray[i] = lld.a(areas[i]);
        }
        return lldArray;
    }

    public BarCodeReader(String filename) {
        this(filename, (BaseDecodeType)DecodeType.ALL_SUPPORTED_TYPES);
    }

    public BarCodeReader(String filename, BaseDecodeType type) {
        if (kke.b(filename) || !com.aspose.barcode.internal.uut.yy.c(filename)) {
            throw new IllegalArgumentException("Wrong filename passed.");
        }
        this._readerImplementation = new ii();
        this.setBarCodeReadType(type);
        this.setBarCodeImage(filename);
    }

    public BarCodeReader(String filename, BaseDecodeType ... decodeTypes) {
        this(filename, (BaseDecodeType)new MultyDecodeType(decodeTypes));
    }

    BarCodeReader(vv stream) {
        this(stream, (BaseDecodeType)DecodeType.ALL_SUPPORTED_TYPES);
    }

    public BarCodeReader(InputStream stream) {
        this(vv.b(stream));
    }

    public BarCodeReader(InputStream stream, BaseDecodeType type) {
        this(vv.b(stream), type);
    }

    BarCodeReader(vv stream, BaseDecodeType type) {
        if (stream == null) {
            throw new tt("stream");
        }
        this._readerImplementation = new ii();
        this.setBarCodeImageInternal(stream);
        this.setBarCodeReadType(type);
    }

    public BarCodeReader(InputStream stream, BaseDecodeType ... decodeTypes) {
        this(vv.b(stream), decodeTypes);
    }

    BarCodeReader(vv stream, BaseDecodeType ... decodeTypes) {
        this(stream, (BaseDecodeType)new MultyDecodeType(decodeTypes));
    }

    public void dispose() {
        this.disposeAllResources();
    }

    private void disposeAllResources() {
        if (this._readerImplementation != null) {
            this._readerImplementation.a(true);
            this._readerImplementation = null;
        }
    }

    public BaseDecodeType getBarCodeDecodeType() {
        return this._readerImplementation.c();
    }

    public boolean exportToXml(String xmlFile) {
        com.aspose.barcode.internal.mmq.ww ww2 = new com.aspose.barcode.internal.mmq.ww(this);
        return ww2.a(xmlFile);
    }

    public boolean exportToXml(OutputStream xmlStream) throws IOException {
        com.aspose.barcode.internal.mmq.ww ww2 = new com.aspose.barcode.internal.mmq.ww(this);
        hh hh2 = new hh();
        boolean bl = ww2.a(hh2);
        if (bl) {
            ((vv)hh2).a(0L);
            byte[] byArray = new byte[(int)((vv)hh2).f()];
            ((vv)hh2).a(byArray, 0, byArray.length);
            xmlStream.write(byArray);
        }
        return bl;
    }

    public static BarCodeReader importFromXml(String xmlFile) {
        BarCodeReader barCodeReader = new BarCodeReader();
        com.aspose.barcode.internal.mmq.ww ww2 = new com.aspose.barcode.internal.mmq.ww(barCodeReader);
        ww2.b(xmlFile);
        return barCodeReader;
    }

    public static BarCodeReader importFromXml(InputStream xmlStream) {
        BarCodeReader barCodeReader = new BarCodeReader();
        com.aspose.barcode.internal.mmq.ww ww2 = new com.aspose.barcode.internal.mmq.ww(barCodeReader);
        ww2.b(vv.b(xmlStream));
        return barCodeReader;
    }
}

