/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed.utils;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class Charsets {
    public static final int BOM_UTF_8 = 19;
    public static final int BOM_UTF_16BE = 34;
    public static final int BOM_UTF_16LE = 50;
    public static final int BOM_UTF_32BE = 68;
    public static final int BOM_UTF_32LE = 84;
    public static final int BOM_UNSUPPORTED = 0;
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    public static final Charset ASCII = Charset.forName("US-ASCII");

    /*
     * WARNING - void declaration
     */
    public static int parseByteOrderMark(byte[] arr, int start, int len) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = Math.min(len, arr.length - start);
        if (n6 >= 4) {
            long l2 = 0xFF & arr[start];
            long l3 = 0xFF & arr[start + 1];
            long l4 = 0xFF & arr[start + 2];
            long l5 = 0xFF & arr[start + 3];
            long l6 = l2 << 24 | l3 << 16 | l4 << 8 | l5;
            if (l6 == 65279L) {
                return 68;
            }
            if (l6 == -131072L) {
                return 84;
            }
        }
        if (n6 >= 3 && (n5 = (n4 = 0xFF & arr[start]) << 16 | (n3 = 0xFF & arr[start + 1]) << 8 | (n2 = 0xFF & arr[start + 2])) == 0xEFBBBF) {
            return 19;
        }
        if (n6 >= 2) {
            void var1_1;
            byte[] byArray;
            int n7 = 0xFF & arr[start];
            n3 = 0xFF & byArray[var1_1 + true];
            int n8 = n7 << 8 | n3;
            if (n8 == 65279) {
                return 34;
            }
            if (n8 == 65534) {
                return 50;
            }
        }
        return 0;
    }

    public static int getBOMLength(int bom) {
        return bom & 0xF;
    }

    public static Charset charsetFromBOM(int bom) {
        switch (bom) {
            case 19: {
                return UTF_8;
            }
            case 34: {
                return UTF_16BE;
            }
            case 50: {
                return UTF_16LE;
            }
        }
        return ASCII;
    }

    /*
     * WARNING - void declaration
     */
    public static int getBytes(Charset charset, String str, int charIdx, int charCount, byte[] buffer, int bufferIdx) {
        Charset charset2;
        void var2_2;
        void var3_3;
        CharBuffer charBuffer = CharBuffer.wrap(str, charIdx, (int)(var3_3 + var2_2));
        return Charsets.a(charset2, charBuffer, buffer, bufferIdx);
    }

    /*
     * WARNING - void declaration
     */
    public static int getBytes(Charset charset, char[] str, int charIdx, int charCount, byte[] buffer, int bufferIdx) {
        Charset charset2;
        void var2_2;
        void var3_3;
        CharBuffer charBuffer = CharBuffer.wrap(str, charIdx, (int)(var3_3 + var2_2));
        return Charsets.a(charset2, charBuffer, buffer, bufferIdx);
    }

    private static int a(Charset comparable, CharBuffer charBuffer, byte[] byArray, int n2) {
        int n3 = Math.min(((Buffer)((Object)(comparable = ((Charset)comparable).encode(charBuffer)))).limit(), byArray.length - n2);
        if (n3 > 0) {
            ((ByteBuffer)comparable).get(byArray, n2, n3);
        }
        return n3;
    }
}

