/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed.utils;

import com.aspose.threed.utils.MetaClass;
import com.aspose.threed.utils.Pure;
import java.nio.ByteBuffer;

public class BitUtils {
    public static final int SHORT_BYTES = 2;
    public static final int INTEGER_BYTES = 4;
    public static final int LONG_BYTES = 8;
    public static final int DOUBLE_BYTES = 8;
    public static final int FLOAT_BYTES = 4;

    /*
     * WARNING - void declaration
     */
    public static int getInt32(byte[] array, int offset) {
        void var1_1;
        byte[] byArray;
        return (array[offset + 3] & 0xFF) << 24 | (array[offset + 2] & 0xFF) << 16 | (array[offset + 1] & 0xFF) << 8 | byArray[var1_1] & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public static long getInt64(byte[] array, int offset) {
        long l2 = 0L;
        int n2 = 0;
        var1_1 += 7;
        while (n2 < 8) {
            void var1_1;
            l2 <<= 8;
            l2 |= (long)(array[var1_1] & 0xFF);
            ++n2;
            --var1_1;
        }
        return l2;
    }

    public static long getInt64(byte[] array) {
        return BitUtils.getInt64(array, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static short getInt16(byte[] array, int offset) {
        void var1_1;
        byte[] byArray;
        return (short)((array[offset + 1] & 0xFF) << 8 | byArray[var1_1] & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    public static double getDouble(byte[] array, int offset) {
        void var1_1;
        long l2 = BitUtils.getInt64(array, (int)var1_1);
        return Double.longBitsToDouble(l2);
    }

    /*
     * WARNING - void declaration
     */
    public static float getFloat(byte[] array, int offset) {
        void var1_2;
        int n2 = BitUtils.getInt32(array, (int)var1_2);
        return Float.intBitsToFloat(n2);
    }

    public static int hashCode(boolean value) {
        if (value) {
            return 1;
        }
        return 0;
    }

    public static int hashCode(double value) {
        long l2 = Double.doubleToLongBits(value);
        return (int)(l2 ^ l2 >>> 32);
    }

    public static int hashCode(float value) {
        return Float.floatToIntBits(value);
    }

    public static int sizeof(MetaClass<?> type) {
        MetaClass<?> metaClass;
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        return BitUtils.sizeof(metaClass.classOf());
    }

    public static int sizeof(Class<?> type) {
        Class<?> clazz;
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (type == Byte.TYPE || type == Boolean.TYPE) {
            return 1;
        }
        if (type == Character.TYPE || type == Short.TYPE) {
            return 2;
        }
        if (type == Integer.TYPE || type == Float.TYPE) {
            return 4;
        }
        if (type == Double.TYPE || clazz == Long.TYPE) {
            return 8;
        }
        throw new IllegalArgumentException("Cannot get size of non-primitive type");
    }

    public static byte[] toBytes(Object val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot convert null to bytes");
        }
        Class<?> clazz = val.getClass();
        if (clazz == Integer.class) {
            return BitUtils.toBytes(((Number)val).intValue());
        }
        if (clazz == Short.class) {
            return BitUtils.toBytes(((Number)val).shortValue());
        }
        if (clazz == Long.class) {
            return BitUtils.toBytes(((Number)val).longValue());
        }
        if (clazz == Byte.class) {
            return BitUtils.toBytes(((Number)val).byteValue());
        }
        if (clazz == Float.class) {
            return BitUtils.toBytes(((Number)val).floatValue());
        }
        if (clazz == Double.class) {
            return BitUtils.toBytes(((Number)val).doubleValue());
        }
        if (clazz == int[].class) {
            return BitUtils.toBytes((int[])val);
        }
        if (clazz == short[].class) {
            return BitUtils.toBytes((short[])val);
        }
        if (clazz == long[].class) {
            return BitUtils.toBytes((long[])val);
        }
        if (clazz == byte[].class) {
            return (byte[])val;
        }
        if (clazz == float[].class) {
            return BitUtils.toBytes((float[])val);
        }
        if (clazz == double[].class) {
            Object object;
            return BitUtils.toBytes((double[])object);
        }
        throw new IllegalArgumentException("Cannot convert unsupported type to bytes");
    }

    public static byte[] toBytes(byte val) {
        byte by2;
        return new byte[]{by2};
    }

    public static byte[] toBytes(short val) {
        short s2;
        byte[] byArray = new byte[2];
        BitUtils.toBytes(byArray, 0, s2);
        return byArray;
    }

    public static byte[] toBytes(int val) {
        int n2;
        byte[] byArray = new byte[4];
        BitUtils.toBytes(byArray, 0, n2);
        return byArray;
    }

    public static byte[] toBytes(long val) {
        long l2;
        byte[] byArray = new byte[8];
        BitUtils.toBytes(byArray, 0, l2);
        return byArray;
    }

    public static byte[] toBytes(float val) {
        float f2;
        byte[] byArray = new byte[4];
        BitUtils.toBytes(byArray, 0, f2);
        return byArray;
    }

    public static byte[] toBytes(double val) {
        double d2;
        byte[] byArray = new byte[8];
        BitUtils.toBytes(byArray, 0, d2);
        return byArray;
    }

    public static byte[] toBytes(boolean[] vals) {
        byte[] byArray = new byte[vals.length];
        int n2 = 0;
        int n3 = 0;
        while (n2 < vals.length) {
            byArray[n3] = (byte)(vals[n2] ? 1 : 0);
            ++n2;
            ++n3;
        }
        return byArray;
    }

    public static byte[] toBytes(short[] vals) {
        byte[] byArray = new byte[vals.length << 1];
        int n2 = 0;
        int n3 = 0;
        while (n2 < vals.length) {
            BitUtils.toBytes(byArray, n3, vals[n2]);
            ++n2;
            n3 += 2;
        }
        return byArray;
    }

    public static byte[] toBytes(int[] vals) {
        byte[] byArray = new byte[vals.length << 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < vals.length) {
            BitUtils.toBytes(byArray, n3, vals[n2]);
            ++n2;
            n3 += 4;
        }
        return byArray;
    }

    public static byte[] toBytes(long[] vals) {
        byte[] byArray = new byte[vals.length << 3];
        int n2 = 0;
        int n3 = 0;
        while (n2 < vals.length) {
            BitUtils.toBytes(byArray, n3, vals[n2]);
            ++n2;
            n3 += 8;
        }
        return byArray;
    }

    public static byte[] toBytes(float[] vals) {
        byte[] byArray = new byte[vals.length << 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < vals.length) {
            BitUtils.toBytes(byArray, n3, vals[n2]);
            ++n2;
            n3 += 4;
        }
        return byArray;
    }

    public static byte[] toBytes(double[] vals) {
        byte[] byArray = new byte[vals.length << 3];
        int n2 = 0;
        int n3 = 0;
        while (n2 < vals.length) {
            BitUtils.toBytes(byArray, n3, vals[n2]);
            ++n2;
            n3 += 8;
        }
        return byArray;
    }

    public static byte[] toBytes(@Pure ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        byte[] byArray = new byte[buffer.remaining()];
        byteBuffer.get(byArray, 0, byArray.length);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static void toBytes(byte[] array, int offset, short[] val, int off, int len) {
        void var3_3;
        int n2 = offset;
        int n3 = off + len;
        while (var3_3 < n3) {
            BitUtils.toBytes(array, n2, val[var3_3]);
            n2 += 2;
            ++var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void toBytes(byte[] array, int offset, short val) {
        void var2_2;
        array[offset] = (byte)val;
        var0[var1_1 + true] = (byte)(var2_2 >> 8);
    }

    /*
     * WARNING - void declaration
     */
    public static void toBytes(byte[] array, int offset, Integer[] val, int off, int len) {
        void var3_3;
        int n2 = offset;
        int n3 = off + len;
        while (var3_3 < n3) {
            BitUtils.toBytes(array, n2, val[var3_3]);
            n2 += 4;
            ++var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void toBytes(byte[] array, int offset, int[] val, int off, int len) {
        void var3_3;
        int n2 = offset;
        int n3 = off + len;
        while (var3_3 < n3) {
            BitUtils.toBytes(array, n2, val[var3_3]);
            n2 += 4;
            ++var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void toBytes(byte[] array, int offset, int val) {
        void var2_2;
        array[offset] = (byte)val;
        array[offset + 1] = (byte)(val >> 8);
        array[offset + 2] = (byte)(val >> 16);
        var0[var1_1 + 3] = (byte)(var2_2 >>> 24);
    }

    /*
     * WARNING - void declaration
     */
    public static void toBytes(byte[] array, int offset, long[] val, int off, int len) {
        void var3_3;
        int n2 = offset;
        int n3 = off + len;
        while (var3_3 < n3) {
            BitUtils.toBytes(array, n2, val[var3_3]);
            n2 += 8;
            ++var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void toBytes(byte[] array, int offset, long val) {
        void var2_2;
        array[offset] = (byte)(val & 0xFFL);
        array[offset + 1] = (byte)(val >> 8 & 0xFFL);
        array[offset + 2] = (byte)(val >> 16 & 0xFFL);
        array[offset + 3] = (byte)(val >> 24 & 0xFFL);
        array[offset + 4] = (byte)(val >> 32 & 0xFFL);
        array[offset + 5] = (byte)(val >> 40 & 0xFFL);
        array[offset + 6] = (byte)(val >> 48 & 0xFFL);
        var0[var1_1 + 7] = (byte)(var2_2 >> 56 & 0xFFL);
    }

    /*
     * WARNING - void declaration
     */
    public static void toBytes(byte[] array, int offset, float[] val, int off, int len) {
        void var3_3;
        int n2 = offset;
        int n3 = off + len;
        while (var3_3 < n3) {
            BitUtils.toBytes(array, n2, val[var3_3]);
            n2 += 4;
            ++var3_3;
        }
    }

    public static void toBytes(byte[] array, int offset, float f2) {
        int n2 = Float.floatToRawIntBits(f2);
        array[offset] = (byte)n2;
        array[offset + 1] = (byte)(n2 >> 8);
        array[offset + 2] = (byte)(n2 >> 16);
        var0[var1_1 + 3] = (byte)(n2 >>> 24);
    }

    /*
     * WARNING - void declaration
     */
    public static void toBytes(byte[] array, int offset, Double[] val, int off, int len) {
        void var3_3;
        int n2 = offset;
        int n3 = off + len;
        while (var3_3 < n3) {
            BitUtils.toBytes(array, n2, val[var3_3]);
            n2 += 8;
            ++var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void toBytes(byte[] array, int offset, double[] val, int off, int len) {
        void var3_3;
        int n2 = offset;
        int n3 = off + len;
        while (var3_3 < n3) {
            BitUtils.toBytes(array, n2, val[var3_3]);
            n2 += 8;
            ++var3_3;
        }
    }

    public static void toBytes(byte[] array, int offset, double d2) {
        long l2 = Double.doubleToRawLongBits(d2);
        array[offset] = (byte)(l2 & 0xFFL);
        array[offset + 1] = (byte)(l2 >> 8 & 0xFFL);
        array[offset + 2] = (byte)(l2 >> 16 & 0xFFL);
        array[offset + 3] = (byte)(l2 >> 24 & 0xFFL);
        array[offset + 4] = (byte)(l2 >> 32 & 0xFFL);
        array[offset + 5] = (byte)(l2 >> 40 & 0xFFL);
        array[offset + 6] = (byte)(l2 >> 48 & 0xFFL);
        var0[var1_1 + 7] = (byte)(l2 >> 56 & 0xFFL);
    }

    /*
     * WARNING - void declaration
     */
    public static void fromBytes(byte[] bytes, int offset, double[] val, int off, int len) {
        int n2 = offset;
        for (int i2 = 0; i2 < len; ++i2) {
            void var3_3;
            val[var3_3] = BitUtils.getDouble(bytes, n2);
            ++var3_3;
            n2 += 8;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void fromBytes(byte[] bytes, int offset, float[] val, int off, int len) {
        int n2 = offset;
        for (int i2 = 0; i2 < len; ++i2) {
            void var3_3;
            val[var3_3] = BitUtils.getFloat(bytes, n2);
            ++var3_3;
            n2 += 4;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void fromBytes(byte[] bytes, int offset, int[] val, int off, int len) {
        int n2 = offset;
        for (int i2 = 0; i2 < len; ++i2) {
            void var3_3;
            val[var3_3] = BitUtils.getInt32(bytes, n2);
            ++var3_3;
            n2 += 4;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void fromBytes(byte[] bytes, int offset, long[] val, int off, int len) {
        int n2 = offset;
        for (int i2 = 0; i2 < len; ++i2) {
            void var3_3;
            val[var3_3] = BitUtils.getInt64(bytes, n2);
            ++var3_3;
            n2 += 8;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int compareUnsigned(int x2, int y2) {
        void var1_1;
        return Integer.compare(x2 + Integer.MIN_VALUE, (int)(var1_1 + Integer.MIN_VALUE));
    }

    /*
     * WARNING - void declaration
     */
    public static int compareUnsigned(byte x2, byte y2) {
        void var1_1;
        byte by2;
        return Integer.compare(0xFF & by2, 0xFF & var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int compareUnsigned(short x2, short y2) {
        void var1_1;
        short s2;
        return Integer.compare(0xFFFF & s2, 0xFFFF & var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int compareUnsigned(long x2, long y2) {
        void var2_1;
        return Long.compare(x2 + Long.MIN_VALUE, (long)(var2_1 + Long.MIN_VALUE));
    }
}

