/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.Entity;
import com.aspose.threed.FVector2;
import com.aspose.threed.FVector3;
import com.aspose.threed.FVector4;
import com.aspose.threed.Geometry;
import com.aspose.threed.MappingMode;
import com.aspose.threed.Mesh;
import com.aspose.threed.PointCloud;
import com.aspose.threed.PolygonModifier;
import com.aspose.threed.Vector2;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.Vertex;
import com.aspose.threed.VertexDeclaration;
import com.aspose.threed.VertexElement;
import com.aspose.threed.VertexElementType;
import com.aspose.threed.VertexElementUserData;
import com.aspose.threed.VertexField;
import com.aspose.threed.VertexFieldSemantic;
import com.aspose.threed.da;
import com.aspose.threed.fv;
import com.aspose.threed.kE;
import com.aspose.threed.nn;
import com.aspose.threed.no;
import com.aspose.threed.np;
import com.aspose.threed.nq;
import com.aspose.threed.ph;
import com.aspose.threed.pi;
import com.aspose.threed.utils.AsposeUtils;
import com.aspose.threed.utils.Stream;
import com.aspose.threed.utils.StringUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;

public class TriMesh
extends Entity
implements Iterable<Vertex> {
    VertexDeclaration decl;
    private int numUnmergedVertices;
    np storage;
    private Vertex lastVertex;
    private TreeMap<Vertex, Integer> vertexIndices;
    fv faceIndices;

    /*
     * WARNING - void declaration
     */
    public TriMesh(String name, VertexDeclaration declaration) {
        super((String)((Object)triMesh));
        void var2_3;
        TriMesh triMesh;
        triMesh = this;
        try {
            triMesh.lastVertex = null;
            triMesh.vertexIndices = new TreeMap();
            triMesh.faceIndices = new fv();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.decl = declaration;
        var2_3.a();
        this.storage = TriMesh.a(this.decl) ? new no() : new nn();
        this.storage.b = this.decl;
    }

    private static boolean a(VertexDeclaration vertexDeclaration) {
        for (int i2 = 0; i2 < vertexDeclaration.getCount(); ++i2) {
            VertexField vertexField = vertexDeclaration.b.get(i2);
            int n2 = vertexField.a;
            if ((n2 >>= 4) == 1) continue;
            return false;
        }
        return true;
    }

    public VertexDeclaration getVertexDeclaration() {
        return this.decl;
    }

    public int getVerticesCount() {
        return this.storage.d;
    }

    public int getIndicesCount() {
        return this.faceIndices.size();
    }

    public int getUnmergedVerticesCount() {
        return this.numUnmergedVertices;
    }

    public int getCapacity() {
        return this.storage.c;
    }

    public int getVerticesSizeInBytes() {
        return this.storage.d * this.decl.a;
    }

    public static TriMesh fromMesh(VertexDeclaration declaration, Mesh mesh) {
        TriMesh triMesh;
        Iterable<VertexField> iterable;
        boolean bl2 = declaration.a(VertexFieldSemantic.POSITION) != null;
        if (!bl2) {
            throw new IllegalStateException(da.l());
        }
        if (!mesh.c()) {
            mesh = PolygonModifier.triangulate(mesh);
        }
        iterable = new TriMesh("", (VertexDeclaration)iterable);
        void var2_5 = triMesh;
        triMesh = iterable;
        boolean bl3 = false;
        TriMesh triMesh2 = iterable;
        ph ph2 = new ph((Geometry)var2_5);
        triMesh2.a((Mesh)var2_5, ph2, false);
        return iterable;
    }

    static TriMesh a(PointCloud object, boolean bl2) {
        VertexDeclaration vertexDeclaration = VertexDeclaration.fromGeometry((Geometry)object, true);
        Object object2 = vertexDeclaration;
        object2 = object;
        object = vertexDeclaration;
        boolean bl3 = vertexDeclaration.a(VertexFieldSemantic.POSITION) != null;
        if (!bl3) {
            throw new IllegalStateException(da.l());
        }
        object = new TriMesh("", (VertexDeclaration)object);
        ph ph2 = new ph((Geometry)object2);
        ((TriMesh)object).a((PointCloud)object2, ph2, false);
        return object;
    }

    private void a(PointCloud pointCloud, ph ph2, boolean bl2) {
        VertexDeclaration vertexDeclaration = this.decl;
        VertexElement[] vertexElementArray = new VertexElement[vertexDeclaration.b.size()];
        int n2 = 0;
        VertexField vertexField = null;
        for (VertexField vertexField2 : vertexDeclaration.b) {
            TriMesh.a(vertexField2);
            if (vertexField2.b == VertexFieldSemantic.POSITION) {
                if (vertexField != null) {
                    throw new IllegalStateException(da.m());
                }
                vertexField = vertexField2;
                ++n2;
                continue;
            }
            VertexElement vertexElement = TriMesh.a(ph2, vertexField2.b, vertexField2.c, vertexField2.f);
            if (vertexElement != null && vertexElement.c == MappingMode.CONTROL_POINT) {
                vertexElementArray[n2] = vertexElement;
            }
            ++n2;
        }
        int n3 = pointCloud.controlPoints.b;
        this.storage.a(n3);
        this.faceIndices.b(n3);
        this.storage.a(pointCloud, vertexField, vertexElementArray);
    }

    private void a(Mesh mesh, ph ph2, boolean bl2) {
        VertexDeclaration vertexDeclaration = this.decl;
        VertexElement[] vertexElementArray = new VertexElement[vertexDeclaration.b.size()];
        int n2 = 0;
        VertexField vertexField = null;
        for (VertexField vertexField2 : vertexDeclaration.b) {
            TriMesh.a(vertexField2);
            if (vertexField2.b == VertexFieldSemantic.POSITION) {
                if (vertexField != null) {
                    throw new IllegalStateException(da.m());
                }
                vertexField = vertexField2;
                ++n2;
                continue;
            }
            VertexElement vertexElement = TriMesh.a(ph2, vertexField2.b, vertexField2.c, vertexField2.f);
            if (vertexElement != null) {
                if ((vertexElement = pi.a(vertexElement, mesh, vertexField2.f)) instanceof VertexElementUserData) {
                    vertexElement = ((VertexElementUserData)vertexElement).a(vertexField2.f);
                }
                vertexElementArray[n2] = vertexElement;
            }
            ++n2;
        }
        int n3 = mesh.polygons.size() * 3;
        this.storage.a(n3);
        this.faceIndices.b(n3);
        this.storage.a(this, mesh, vertexField, vertexElementArray, bl2);
    }

    final void a(Mesh mesh, ph ph2) {
        this.a(mesh, ph2, false);
    }

    public static TriMesh copyFrom(TriMesh input, VertexDeclaration vd) {
        if (input == null) {
            throw new IllegalArgumentException("Argument input cannot be null");
        }
        if (vd == null) {
            throw new IllegalArgumentException("Argument vd cannot be null");
        }
        TriMesh triMesh = new TriMesh("", vd);
        new TriMesh("", vd).storage.d = input.storage.d;
        triMesh.storage.a(input.storage.d);
        triMesh.faceIndices.a(input.faceIndices);
        for (int i2 = 0; i2 < vd.b.size(); ++i2) {
            VertexField vertexField = vd.b.get(i2);
            VertexField vertexField2 = input.getVertexDeclaration().a(vertexField.b);
            if (vertexField2 == null) continue;
            TriMesh.a(triMesh, vertexField, input, vertexField2);
        }
        return triMesh;
    }

    private static boolean a(TriMesh triMesh, VertexField vertexField, TriMesh triMesh2, VertexField vertexField2) {
        float[] fArray = new float[4];
        int n2 = vertexField.a >> 4;
        int n3 = vertexField2.a >> 4;
        int n4 = vertexField2.a & 0xF;
        int n5 = vertexField.a & 0xF;
        if (n2 != 2 && n2 != 1) {
            return false;
        }
        if (n3 != 2 && n3 != 1) {
            return false;
        }
        if (vertexField.b == VertexFieldSemantic.POSITION) {
            fArray[3] = 1.0f;
        }
        for (n2 = 0; n2 < triMesh.storage.d; ++n2) {
            triMesh2.storage.a(n2, vertexField2, fArray, n4);
            triMesh.storage.b(n2, vertexField, fArray, n5);
        }
        return true;
    }

    private static void a(VertexField vertexField) {
        int n2 = vertexField.a;
        int n3 = n2 >> 4;
        n2 &= 0xF;
        switch (vertexField.b) {
            case BINORMAL: 
            case NORMAL: 
            case POSITION: 
            case SPECULAR: 
            case TANGENT: 
            case VERTEX_COLOR: {
                if (n2 != 3 && n2 != 4) {
                    throw new ClassCastException(StringUtils.format(da.n(), vertexField.b.toString()));
                }
                if ((n3 & 3) != 0) break;
                throw new ClassCastException(StringUtils.format(da.o(), vertexField.b.toString()));
            }
            case UV: {
                if ((n3 & 3) != 0) break;
                throw new ClassCastException(StringUtils.format(da.o(), vertexField.b.toString()));
            }
            case EDGE_CREASE: 
            case VERTEX_CREASE: 
            case WEIGHT: {
                if ((n3 & 3) != 0) break;
                throw new ClassCastException(StringUtils.format(da.o(), vertexField.b.toString()));
            }
            case VISIBILITY: {
                if ((n3 & 3) == 0) break;
                throw new ClassCastException(StringUtils.format(da.p(), vertexField.b.toString()));
            }
        }
    }

    private static VertexElement a(ph ph2, VertexFieldSemantic enum_, int n2, String string) {
        if (enum_ == VertexFieldSemantic.USER_DATA && string != null && string.length() != 0) {
            int n3 = ph2.a(VertexElementType.USER_DATA);
            for (n2 = 0; n2 < n3; ++n2) {
                VertexElement vertexElement = ph2.a(VertexElementType.USER_DATA, n2);
                vertexElement = vertexElement instanceof VertexElementUserData ? (VertexElementUserData)vertexElement : null;
                if (vertexElement == null || ((VertexElementUserData)vertexElement).getData() == null || !AsposeUtils.equals(string, vertexElement.getName())) continue;
                return vertexElement;
            }
            return null;
        }
        enum_ = VertexDeclaration.b((VertexFieldSemantic)enum_);
        return ph2.a((VertexElementType)enum_, n2);
    }

    /*
     * WARNING - void declaration
     */
    public static TriMesh fromMesh(Mesh mesh, boolean useFloat) {
        Mesh mesh2;
        void var1_1;
        if (!mesh.c()) {
            mesh = PolygonModifier.triangulate(mesh);
        }
        VertexDeclaration vertexDeclaration = VertexDeclaration.fromGeometry(mesh, (boolean)var1_1);
        return TriMesh.fromMesh(vertexDeclaration, mesh2);
    }

    public static TriMesh fromMesh(Mesh mesh) {
        return TriMesh.fromMesh(mesh, true);
    }

    public Vertex beginVertex() {
        if (this.lastVertex != null) {
            throw new IllegalStateException(da.q());
        }
        if (this.storage.c == this.storage.d) {
            this.storage.a(this.storage.c << 1);
        }
        this.lastVertex = this.storage.b(this.storage.d);
        return this.lastVertex;
    }

    public void endVertex() {
        int n2;
        Integer[] integerArray = new Integer[1];
        if (this.lastVertex == null) {
            throw new IllegalStateException(da.r());
        }
        if (!AsposeUtils.tryGetValue(this.vertexIndices, this.lastVertex, integerArray)) {
            if (integerArray[0] != null) {
                integerArray[0].intValue();
            }
            n2 = this.lastVertex.a;
            this.vertexIndices.put(this.lastVertex, n2);
            ++this.storage.d;
        } else {
            n2 = integerArray[0] == null ? 0 : integerArray[0];
        }
        ++this.numUnmergedVertices;
        this.faceIndices.c(n2);
        this.lastVertex = null;
    }

    /*
     * WARNING - void declaration
     */
    public void writeVerticesTo(Stream stream) throws IOException {
        void var1_1;
        if (this.storage.d == 0) {
            return;
        }
        this.storage.a((Stream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void write16bIndicesTo(Stream stream) throws IOException {
        void var1_1;
        int[] nArray = this.faceIndices.b();
        short[] sArray = new short[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            sArray[i2] = (short)nArray[i2];
        }
        kE.a((Stream)var1_1, (Object)sArray);
    }

    /*
     * WARNING - void declaration
     */
    public void write32bIndicesTo(Stream stream) throws IOException {
        void var1_1;
        int[] nArray = this.faceIndices.b();
        kE.a((Stream)var1_1, (Object)nArray);
    }

    public byte[] verticesToArray() {
        return this.storage.a();
    }

    @Deprecated
    public void indicesToArray(short[][] result) {
        result[0] = this.getShortIndices();
    }

    public short[] getShortIndices() {
        int[] nArray = this.faceIndices.b();
        short[] sArray = new short[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            sArray[i2] = (short)nArray[i2];
        }
        return sArray;
    }

    public int[] getIntIndices() {
        return this.faceIndices.b();
    }

    @Deprecated
    public void indicesToArray(int[][] result) {
        result[0] = this.faceIndices.b();
    }

    public String toString() {
        int n2 = this.decl.a * this.storage.d;
        return String.format("%d vertices in %d bytes", this.storage.d, n2);
    }

    /*
     * WARNING - void declaration
     */
    public static TriMesh fromRawData(VertexDeclaration vd, byte[] vertices, int[] indices, boolean generateVertexMapping) {
        void var3_3;
        void var2_2;
        void var1_1;
        Iterable<VertexField> iterable;
        if (vd == null) {
            throw new IllegalArgumentException("Argument vd cannot be null");
        }
        if (vd.b.isEmpty()) {
            throw new IllegalArgumentException("Vertex declaration cannot be undefined");
        }
        if (vertices == null) {
            throw new IllegalArgumentException("Argument vertices cannot be null");
        }
        if (indices == null) {
            throw new IllegalArgumentException("Argument indices cannot be null");
        }
        int n2 = vertices.length / vd.getSize();
        iterable = new TriMesh("", (VertexDeclaration)iterable);
        v0.numUnmergedVertices = n2;
        ((TriMesh)iterable).storage.d = n2;
        ((TriMesh)iterable).storage.a(n2);
        ((TriMesh)iterable).storage.a((byte[])var1_1);
        ((TriMesh)iterable).faceIndices.c((int[])var2_2);
        if (var3_3 != false) {
            super.b();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public void loadVerticesFromBytes(byte[] verticesInBytes) {
        void var1_1;
        if (verticesInBytes == null) {
            throw new IllegalArgumentException("Argument verticesInBytes cannot be null");
        }
        if (verticesInBytes.length % this.storage.b.a != 0) {
            throw new IllegalArgumentException("Length of bytes must be an integer multiple of vertex size");
        }
        this.storage.a((byte[])var1_1);
    }

    private void b() {
        for (int i2 = 0; i2 < this.storage.d; ++i2) {
            Vertex vertex = this.storage.b(i2);
            this.vertexIndices.put(vertex, i2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Vector4 readVector4(int idx, VertexField field) {
        void var2_2;
        void var1_1;
        return this.storage.a((int)var1_1, (VertexField)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public FVector4 readFVector4(int idx, VertexField field) {
        void var2_2;
        void var1_1;
        return this.storage.b((int)var1_1, (VertexField)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Vector3 readVector3(int idx, VertexField field) {
        void var2_2;
        void var1_1;
        return this.storage.c((int)var1_1, (VertexField)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public FVector3 readFVector3(int idx, VertexField field) {
        void var2_2;
        void var1_1;
        return this.storage.d((int)var1_1, (VertexField)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Vector2 readVector2(int idx, VertexField field) {
        void var2_2;
        void var1_1;
        return this.storage.e((int)var1_1, (VertexField)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public FVector2 readFVector2(int idx, VertexField field) {
        void var2_2;
        void var1_1;
        return this.storage.f((int)var1_1, (VertexField)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public double readDouble(int idx, VertexField field) {
        void var2_2;
        void var1_1;
        return this.storage.g((int)var1_1, (VertexField)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public float readFloat(int idx, VertexField field) {
        void var2_2;
        void var1_1;
        return this.storage.h((int)var1_1, (VertexField)var2_2);
    }

    @Override
    public Iterator<Vertex> iterator() {
        return new nq(this);
    }
}

