/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.A3DObject;
import com.aspose.threed.LambertMaterial;
import com.aspose.threed.Material;
import com.aspose.threed.MathUtils;
import com.aspose.threed.PbrSpecularMaterial;
import com.aspose.threed.Property;
import com.aspose.threed.PropertyCollection;
import com.aspose.threed.ShaderMaterial;
import com.aspose.threed.TextureBase;
import com.aspose.threed.TextureSlot;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.utils.AsposeUtils;
import java.awt.Color;
import java.util.ArrayList;

public class PbrMaterial
extends Material {
    private Vector3 albedo = new Vector3();
    private double occlusionFactor;
    private double metallicFactor;
    private double roughnessFactor;
    private Vector3 emissiveColor = new Vector3();

    public double getTransparency() {
        return this._transparencyFactor;
    }

    /*
     * WARNING - void declaration
     */
    public void setTransparency(double value) {
        void var1_1;
        this._transparencyFactor = MathUtils.clamp((double)var1_1, 0.0, 1.0);
    }

    public TextureBase getNormalTexture() {
        return this.getTexture("NormalMap");
    }

    /*
     * WARNING - void declaration
     */
    public void setNormalTexture(TextureBase value) {
        void var1_1;
        this.setTexture("NormalMap", (TextureBase)var1_1);
    }

    public TextureBase getSpecularTexture() {
        return this.getTexture("SpecularColor");
    }

    /*
     * WARNING - void declaration
     */
    public void setSpecularTexture(TextureBase value) {
        void var1_1;
        this.setTexture("SpecularColor", (TextureBase)var1_1);
    }

    public TextureBase getAlbedoTexture() {
        return this.getTexture("DiffuseColor");
    }

    /*
     * WARNING - void declaration
     */
    public void setAlbedoTexture(TextureBase value) {
        void var1_1;
        this.setTexture("DiffuseColor", (TextureBase)var1_1);
    }

    public Vector3 getAlbedo() {
        return this.albedo.clone();
    }

    /*
     * WARNING - void declaration
     */
    public void setAlbedo(Vector3 value) {
        void var1_1;
        this.albedo.copyFrom((Vector3)var1_1);
    }

    public TextureBase getOcclusionTexture() {
        return this.getTexture("Occlusion");
    }

    /*
     * WARNING - void declaration
     */
    public void setOcclusionTexture(TextureBase value) {
        void var1_1;
        this.setTexture("Occlusion", (TextureBase)var1_1);
    }

    public double getOcclusionFactor() {
        return this.occlusionFactor;
    }

    /*
     * WARNING - void declaration
     */
    public void setOcclusionFactor(double value) {
        void var1_1;
        this.occlusionFactor = var1_1;
    }

    public double getMetallicFactor() {
        return this.metallicFactor;
    }

    /*
     * WARNING - void declaration
     */
    public void setMetallicFactor(double value) {
        void var1_1;
        this.metallicFactor = var1_1;
    }

    public double getRoughnessFactor() {
        return this.roughnessFactor;
    }

    /*
     * WARNING - void declaration
     */
    public void setRoughnessFactor(double value) {
        void var1_1;
        this.roughnessFactor = var1_1;
    }

    public TextureBase getMetallicRoughness() {
        return this.getTexture("MetallicRoughness");
    }

    /*
     * WARNING - void declaration
     */
    public void setMetallicRoughness(TextureBase value) {
        void var1_1;
        this.setTexture("MetallicRoughness", (TextureBase)var1_1);
    }

    public TextureBase getEmissiveTexture() {
        return this.getTexture("EmissiveColor");
    }

    /*
     * WARNING - void declaration
     */
    public void setEmissiveTexture(TextureBase value) {
        void var1_1;
        this.setTexture("EmissiveColor", (TextureBase)var1_1);
    }

    public Vector3 getEmissiveColor() {
        return this.emissiveColor.clone();
    }

    /*
     * WARNING - void declaration
     */
    public void setEmissiveColor(Vector3 value) {
        void var1_1;
        this.emissiveColor.copyFrom((Vector3)var1_1);
    }

    public PbrMaterial() {
        this.shadingModel = "Pbr";
    }

    /*
     * WARNING - void declaration
     */
    public PbrMaterial(Color albedo) {
        this();
        void var1_1;
        this.setAlbedo(new Vector3((Color)var1_1));
    }

    public static PbrMaterial fromMaterial(Material material) {
        Material material2;
        if (material == null) {
            return null;
        }
        PbrMaterial pbrMaterial = new PbrMaterial();
        new PbrMaterial().name = material.getName();
        pbrMaterial.culling = material.culling;
        pbrMaterial.setOcclusionFactor(1.0);
        if (material.textureSlots != null) {
            pbrMaterial.textureSlots = new ArrayList<TextureSlot>(material.textureSlots);
        }
        pbrMaterial._transparencyFactor = material._transparencyFactor;
        if (material instanceof ShaderMaterial) {
            if (material.getProperties().a("3dsMax") != null) {
                Iterable<TextureSlot> iterable = material;
                material = pbrMaterial;
                Property property = ((PropertyCollection)(iterable = ((A3DObject)((Object)iterable)).getProperties())).a("3dsMax|Parameters|roughness");
                if (property != null && AsposeUtils.castableToNumber(property.getValue())) {
                    ((PbrMaterial)material).setRoughnessFactor(AsposeUtils.asNumber(property.getValue()).doubleValue());
                }
                if ((property = ((PropertyCollection)iterable).a("3dsMax|Parameters|metalness")) != null && AsposeUtils.castableToNumber(property.getValue())) {
                    ((PbrMaterial)material).setMetallicFactor(AsposeUtils.asNumber(property.getValue()).doubleValue());
                }
                if ((property = ((PropertyCollection)iterable).a("3dsMax|Parameters|transparency")) != null && AsposeUtils.castableToNumber(property.getValue())) {
                    ((PbrMaterial)material).setTransparency(AsposeUtils.asNumber(property.getValue()).doubleValue());
                }
                if ((property = ((PropertyCollection)iterable).a("3dsMax|Parameters|base_color")) != null && property.getValue() instanceof Vector4) {
                    ((PbrMaterial)material).setAlbedo(new Vector3((Vector4)property.getValue()));
                } else {
                    property = ((PropertyCollection)iterable).a("DiffuseColor");
                    if (property != null && property.getValue() instanceof Vector3) {
                        ((PbrMaterial)material).setAlbedo((Vector3)property.getValue());
                    }
                }
                property = ((PropertyCollection)iterable).a("EmissiveColor");
                if (property != null && property.getValue() instanceof Vector3) {
                    ((PbrMaterial)material).setEmissiveColor((Vector3)property.getValue());
                }
            }
        } else if (material instanceof LambertMaterial) {
            material2 = (LambertMaterial)material;
            pbrMaterial.setAlbedo(((LambertMaterial)material2).diffuse);
            pbrMaterial.setEmissiveColor(((LambertMaterial)material2).emissive);
            pbrMaterial.setOcclusionFactor(1.0);
        } else if (material2 instanceof PbrSpecularMaterial) {
            material2 = (PbrSpecularMaterial)material2;
            pbrMaterial.setAlbedo(((PbrSpecularMaterial)material2).getDiffuse());
            pbrMaterial.setEmissiveColor(((PbrSpecularMaterial)material2).getEmissiveColor());
            pbrMaterial.setOcclusionFactor(1.0);
        }
        return pbrMaterial;
    }
}

