/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed.utils;

import com.aspose.threed.utils.MemoryStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Stream
implements Closeable {
    public static final int SEEK_SET = 0;
    public static final int SEEK_CURRENT = 1;
    public static final int SEEK_END = 2;

    protected Stream() {
    }

    public int readByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            byArray[i2] = (byte)this.readByte();
        }
        return n3;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            this.writeByte(byArray[i2]);
        }
    }

    public void writeByte(int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long seek(long l2, int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public long getLength() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setLength(long l2) throws IOException {
        throw new UnsupportedOperationException();
    }

    public InputStream getInputStream() {
        return new a(this);
    }

    public OutputStream getOutputStream() {
        return new c(this);
    }

    public static Stream wrap(OutputStream outputStream) throws IOException {
        return new b(outputStream);
    }

    public static Stream wrap(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        while ((n2 = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return new MemoryStream(byteArrayOutputStream.toByteArray());
    }

    static final class b
    extends MemoryStream {
        private OutputStream a;

        public b(OutputStream outputStream) {
            this.a = outputStream;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void close() throws IOException {
            try (OutputStream outputStream = this.a;){
                if (this.data != null) {
                    outputStream.write(this.data, 0, this.cursor);
                }
                if (outputStream == null) return;
            }
        }
    }

    final class c
    extends OutputStream {
        private /* synthetic */ Stream a;

        c(Stream stream) {
            this.a = stream;
        }

        @Override
        public final void write(int n2) throws IOException {
            this.a.writeByte(n2);
        }

        @Override
        public final void write(byte[] byArray, int n2, int n3) throws IOException {
            this.a.write(byArray, n2, n3);
        }

        @Override
        public final void flush() throws IOException {
            this.a.flush();
        }
    }

    final class a
    extends InputStream {
        private /* synthetic */ Stream a;

        a(Stream stream) {
            this.a = stream;
        }

        @Override
        public final int read() throws IOException {
            return this.a.readByte();
        }

        @Override
        public final int read(byte[] byArray, int n2, int n3) throws IOException {
            return this.a.read(byArray, n2, n3);
        }

        @Override
        public final long skip(long l2) throws IOException {
            this.a.seek(l2, 1);
            return l2;
        }
    }
}

