/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed.utils;

import com.aspose.threed.utils.Stream;
import java.io.IOException;
import java.io.OutputStream;

public class MemoryStream
extends Stream
implements AutoCloseable {
    protected byte[] data;
    protected int cursor;
    protected int size;

    public MemoryStream() {
    }

    public MemoryStream(int n2) {
        this.data = new byte[n2];
    }

    public MemoryStream(byte[] byArray) {
        this.data = byArray;
        this.size = byArray.length;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getBuffer() {
        return this.data;
    }

    private void a(int n2) {
        if (this.data != null && this.data.length >= n2) {
            return;
        }
        int n3 = this.data == null ? 0 : this.data.length;
        if (n3 == 0) {
            n3 = 4096;
        }
        while (n3 < n2) {
            n3 <<= 1;
        }
        this.setCapacity(n3);
    }

    public void setCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[n2];
        if (this.data != null) {
            System.arraycopy(this.data, 0, byArray, 0, Math.min(n2, this.data.length));
        }
        this.data = byArray;
        if (this.size > n2) {
            this.size = n2;
        }
    }

    @Override
    public long getLength() {
        return this.size;
    }

    @Override
    public void setLength(long l2) {
        this.a((int)l2);
        this.size = (int)l2;
        if (this.cursor > this.size) {
            MemoryStream memoryStream = this;
            int n2 = memoryStream.size;
            MemoryStream memoryStream2 = memoryStream;
            memoryStream.cursor = n2;
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public int readByte() throws IOException {
        if (this.cursor >= this.data.length) {
            return -1;
        }
        this.a();
        int n2 = this.cursor;
        MemoryStream memoryStream = this;
        int n3 = memoryStream.cursor + 1;
        MemoryStream memoryStream2 = memoryStream;
        memoryStream.cursor = n3;
        return this.data[n2];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] object, int n2, int n3) throws IOException {
        this.a();
        n3 = Math.max(0, Math.min(Math.min(this.size - n2, n3), Math.min(this.size - this.cursor, n3)));
        if (n3 == 0) {
            return 0;
        }
        System.arraycopy(this.data, this.cursor, object, n2, n3);
        MemoryStream memoryStream = this;
        n2 = memoryStream.cursor + n3;
        object = memoryStream;
        memoryStream.cursor = n2;
        return n3;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.a();
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] object, int n2, int n3) throws IOException {
        this.a();
        MemoryStream memoryStream = this;
        memoryStream.a(memoryStream.cursor + n3);
        System.arraycopy(object, n2, this.data, this.cursor, n3);
        MemoryStream memoryStream2 = this;
        n2 = memoryStream2.cursor + n3;
        object = memoryStream2;
        memoryStream2.cursor = n2;
        if (this.cursor > this.size) {
            this.size = this.cursor;
        }
    }

    @Override
    public void writeByte(int n2) throws IOException {
        this.a();
        MemoryStream memoryStream = this;
        memoryStream.a(memoryStream.cursor + 1);
        this.data[this.cursor] = (byte)n2;
        MemoryStream memoryStream2 = this;
        int n3 = memoryStream2.cursor + 1;
        MemoryStream memoryStream3 = memoryStream2;
        memoryStream2.cursor = n3;
        ++this.size;
    }

    @Override
    public long seek(long l2, int n2) throws IOException {
        switch (n2) {
            case 0: {
                int n3 = (int)l2;
                MemoryStream memoryStream = this;
                this.cursor = n3;
                break;
            }
            case 1: {
                MemoryStream memoryStream = this;
                int n4 = memoryStream.cursor + (int)l2;
                MemoryStream memoryStream2 = memoryStream;
                memoryStream.cursor = n4;
                break;
            }
            case 2: {
                MemoryStream memoryStream = this;
                int n5 = memoryStream.size + (int)l2;
                MemoryStream memoryStream3 = memoryStream;
                memoryStream.cursor = n5;
            }
        }
        return this.cursor;
    }

    private void a() {
        if (this.cursor < 0 || this.cursor > this.size) {
            throw new IllegalStateException("Invalid cursor");
        }
    }

    public byte[] toArray() {
        byte[] byArray = new byte[this.size];
        if (this.size == 0) {
            return byArray;
        }
        System.arraycopy(this.data, 0, byArray, 0, this.size);
        return byArray;
    }

    @Override
    public void close() throws IOException {
    }

    public void copyTo(Stream stream) throws IOException {
        if (this.size > 0) {
            stream.write(this.data, 0, this.size);
        }
    }

    public void copyTo(OutputStream outputStream) throws IOException {
        if (this.size > 0) {
            outputStream.write(this.data, 0, this.size);
        }
    }
}

