/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed.utils;

import java.nio.charset.Charset;

public class Charsets {
    public static final int BOM_UTF_8 = 19;
    public static final int BOM_UTF_16BE = 34;
    public static final int BOM_UTF_16LE = 50;
    public static final int BOM_UTF_32BE = 68;
    public static final int BOM_UTF_32LE = 84;
    public static final int BOM_UNSUPPORTED = 0;
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    public static final Charset ASCII = Charset.forName("US-ASCII");

    public static int parseByteOrderMark(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if ((n3 = Math.min(n3, byArray.length - n2)) >= 4) {
            long l2 = 0xFF & byArray[n2];
            long l3 = 0xFF & byArray[n2 + 1];
            long l4 = 0xFF & byArray[n2 + 2];
            long l5 = 0xFF & byArray[n2 + 3];
            long l6 = l2 << 24 | l3 << 16 | l4 << 8 | l5;
            if (l6 == 65279L) {
                return 68;
            }
            if (l6 == -131072L) {
                return 84;
            }
        }
        if (n3 >= 3 && (n7 = (n6 = 0xFF & byArray[n2]) << 16 | (n5 = 0xFF & byArray[n2 + 1]) << 8 | (n4 = 0xFF & byArray[n2 + 2])) == 0xEFBBBF) {
            return 19;
        }
        if (n3 >= 2) {
            int n8 = 0xFF & byArray[n2];
            n5 = 0xFF & byArray[n2 + 1];
            int n9 = n8 << 8 | n5;
            if (n9 == 65279) {
                return 34;
            }
            if (n9 == 65534) {
                return 50;
            }
        }
        return 0;
    }

    public static int getBOMLength(int n2) {
        return n2 & 0xF;
    }

    public static Charset charsetFromBOM(int n2) {
        switch (n2) {
            case 19: {
                return UTF_8;
            }
            case 34: {
                return UTF_16BE;
            }
            case 50: {
                return UTF_16LE;
            }
        }
        return ASCII;
    }
}

