/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed.utils;

import com.aspose.threed.utils.MetaClass;
import com.aspose.threed.utils.Pure;
import java.nio.ByteBuffer;

public class BitUtils {
    public static final int SHORT_BYTES = 2;
    public static final int INTEGER_BYTES = 4;
    public static final int LONG_BYTES = 8;
    public static final int DOUBLE_BYTES = 8;
    public static final int FLOAT_BYTES = 4;

    public static int getInt32(byte[] byArray, int n2) {
        return (byArray[n2 + 3] & 0xFF) << 24 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2] & 0xFF;
    }

    public static long getInt64(byte[] byArray, int n2) {
        long l2 = 0L;
        int n3 = 0;
        n2 += 7;
        while (n3 < 8) {
            l2 <<= 8;
            l2 |= (long)(byArray[n2] & 0xFF);
            ++n3;
            --n2;
        }
        return l2;
    }

    public static long getInt64(byte[] byArray) {
        return BitUtils.getInt64(byArray, 0);
    }

    public static short getInt16(byte[] byArray, int n2) {
        return (short)((byArray[n2 + 1] & 0xFF) << 8 | byArray[n2] & 0xFF);
    }

    public static double getDouble(byte[] byArray, int n2) {
        long l2 = BitUtils.getInt64(byArray, n2);
        return Double.longBitsToDouble(l2);
    }

    public static float getFloat(byte[] byArray, int n2) {
        int n3 = BitUtils.getInt32(byArray, n2);
        return Float.intBitsToFloat(n3);
    }

    public static int hashCode(boolean bl2) {
        if (bl2) {
            return 1;
        }
        return 0;
    }

    public static int hashCode(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        return (int)(l2 ^ l2 >>> 32);
    }

    public static int hashCode(float f2) {
        return Float.floatToIntBits(f2);
    }

    public static int sizeof(MetaClass<?> metaClass) {
        if (metaClass == null) {
            throw new IllegalArgumentException("Null type");
        }
        return BitUtils.sizeof(metaClass.classOf());
    }

    public static int sizeof(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (clazz == Byte.TYPE || clazz == Boolean.TYPE) {
            return 1;
        }
        if (clazz == Character.TYPE || clazz == Short.TYPE) {
            return 2;
        }
        if (clazz == Integer.TYPE || clazz == Float.TYPE) {
            return 4;
        }
        if (clazz == Double.TYPE || clazz == Long.TYPE) {
            return 8;
        }
        throw new IllegalArgumentException("Cannot get size of non-primitive type");
    }

    public static byte[] toBytes(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot convert null to bytes");
        }
        Class<?> clazz = object.getClass();
        if (clazz == Integer.class) {
            return BitUtils.toBytes(((Number)object).intValue());
        }
        if (clazz == Short.class) {
            return BitUtils.toBytes(((Number)object).shortValue());
        }
        if (clazz == Long.class) {
            return BitUtils.toBytes(((Number)object).longValue());
        }
        if (clazz == Byte.class) {
            return BitUtils.toBytes(((Number)object).byteValue());
        }
        if (clazz == Float.class) {
            return BitUtils.toBytes(((Number)object).floatValue());
        }
        if (clazz == Double.class) {
            return BitUtils.toBytes(((Number)object).doubleValue());
        }
        if (clazz == int[].class) {
            return BitUtils.toBytes((int[])object);
        }
        if (clazz == short[].class) {
            return BitUtils.toBytes((short[])object);
        }
        if (clazz == long[].class) {
            return BitUtils.toBytes((long[])object);
        }
        if (clazz == byte[].class) {
            return (byte[])object;
        }
        if (clazz == float[].class) {
            return BitUtils.toBytes((float[])object);
        }
        if (clazz == double[].class) {
            return BitUtils.toBytes((double[])object);
        }
        throw new IllegalArgumentException("Cannot convert unsupported type to bytes");
    }

    public static byte[] toBytes(byte by2) {
        return new byte[]{by2};
    }

    public static byte[] toBytes(short s2) {
        byte[] byArray = new byte[2];
        BitUtils.toBytes(byArray, 0, s2);
        return byArray;
    }

    public static byte[] toBytes(int n2) {
        byte[] byArray = new byte[4];
        BitUtils.toBytes(byArray, 0, n2);
        return byArray;
    }

    public static byte[] toBytes(long l2) {
        byte[] byArray = new byte[8];
        BitUtils.toBytes(byArray, 0, l2);
        return byArray;
    }

    public static byte[] toBytes(float f2) {
        byte[] byArray = new byte[4];
        BitUtils.toBytes(byArray, 0, f2);
        return byArray;
    }

    public static byte[] toBytes(double d2) {
        byte[] byArray = new byte[8];
        BitUtils.toBytes(byArray, 0, d2);
        return byArray;
    }

    public static byte[] toBytes(boolean[] blArray) {
        byte[] byArray = new byte[blArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n2 < blArray.length) {
            byArray[n3] = (byte)(blArray[n2] ? 1 : 0);
            ++n2;
            ++n3;
        }
        return byArray;
    }

    public static byte[] toBytes(short[] sArray) {
        byte[] byArray = new byte[sArray.length << 1];
        int n2 = 0;
        int n3 = 0;
        while (n2 < sArray.length) {
            BitUtils.toBytes(byArray, n3, sArray[n2]);
            ++n2;
            n3 += 2;
        }
        return byArray;
    }

    public static byte[] toBytes(int[] nArray) {
        byte[] byArray = new byte[nArray.length << 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < nArray.length) {
            BitUtils.toBytes(byArray, n3, nArray[n2]);
            ++n2;
            n3 += 4;
        }
        return byArray;
    }

    public static byte[] toBytes(long[] lArray) {
        byte[] byArray = new byte[lArray.length << 3];
        int n2 = 0;
        int n3 = 0;
        while (n2 < lArray.length) {
            BitUtils.toBytes(byArray, n3, lArray[n2]);
            ++n2;
            n3 += 8;
        }
        return byArray;
    }

    public static byte[] toBytes(float[] fArray) {
        byte[] byArray = new byte[fArray.length << 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < fArray.length) {
            BitUtils.toBytes(byArray, n3, fArray[n2]);
            ++n2;
            n3 += 4;
        }
        return byArray;
    }

    public static byte[] toBytes(double[] dArray) {
        byte[] byArray = new byte[dArray.length << 3];
        int n2 = 0;
        int n3 = 0;
        while (n2 < dArray.length) {
            BitUtils.toBytes(byArray, n3, dArray[n2]);
            ++n2;
            n3 += 8;
        }
        return byArray;
    }

    public static byte[] toBytes(@Pure ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray, 0, byArray.length);
        return byArray;
    }

    public static void toBytes(byte[] byArray, int n2, short[] sArray, int n3, int n4) {
        n4 = n3 + n4;
        while (n3 < n4) {
            BitUtils.toBytes(byArray, n2, sArray[n3]);
            n2 += 2;
            ++n3;
        }
    }

    public static void toBytes(byte[] byArray, int n2, short s2) {
        byArray[n2] = (byte)s2;
        byArray[n2 + 1] = (byte)(s2 >> 8);
    }

    public static void toBytes(byte[] byArray, int n2, Integer[] integerArray, int n3, int n4) {
        n4 = n3 + n4;
        while (n3 < n4) {
            BitUtils.toBytes(byArray, n2, integerArray[n3]);
            n2 += 4;
            ++n3;
        }
    }

    public static void toBytes(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        n4 = n3 + n4;
        while (n3 < n4) {
            BitUtils.toBytes(byArray, n2, nArray[n3]);
            n2 += 4;
            ++n3;
        }
    }

    public static void toBytes(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)n3;
        byArray[n2 + 1] = (byte)(n3 >> 8);
        byArray[n2 + 2] = (byte)(n3 >> 16);
        byArray[n2 + 3] = (byte)(n3 >>> 24);
    }

    public static void toBytes(byte[] byArray, int n2, long[] lArray, int n3, int n4) {
        n4 = n3 + n4;
        while (n3 < n4) {
            BitUtils.toBytes(byArray, n2, lArray[n3]);
            n2 += 8;
            ++n3;
        }
    }

    public static void toBytes(byte[] byArray, int n2, long l2) {
        byArray[n2] = (byte)(l2 & 0xFFL);
        byArray[n2 + 1] = (byte)(l2 >> 8 & 0xFFL);
        byArray[n2 + 2] = (byte)(l2 >> 16 & 0xFFL);
        byArray[n2 + 3] = (byte)(l2 >> 24 & 0xFFL);
        byArray[n2 + 4] = (byte)(l2 >> 32 & 0xFFL);
        byArray[n2 + 5] = (byte)(l2 >> 40 & 0xFFL);
        byArray[n2 + 6] = (byte)(l2 >> 48 & 0xFFL);
        byArray[n2 + 7] = (byte)(l2 >> 56 & 0xFFL);
    }

    public static void toBytes(byte[] byArray, int n2, float[] fArray, int n3, int n4) {
        n4 = n3 + n4;
        while (n3 < n4) {
            BitUtils.toBytes(byArray, n2, fArray[n3]);
            n2 += 4;
            ++n3;
        }
    }

    public static void toBytes(byte[] byArray, int n2, float f2) {
        int n3 = Float.floatToRawIntBits(f2);
        byArray[n2] = (byte)n3;
        byArray[n2 + 1] = (byte)(n3 >> 8);
        byArray[n2 + 2] = (byte)(n3 >> 16);
        byArray[n2 + 3] = (byte)(n3 >>> 24);
    }

    public static void toBytes(byte[] byArray, int n2, Double[] doubleArray, int n3, int n4) {
        n4 = n3 + n4;
        while (n3 < n4) {
            BitUtils.toBytes(byArray, n2, doubleArray[n3]);
            n2 += 8;
            ++n3;
        }
    }

    public static void toBytes(byte[] byArray, int n2, double[] dArray, int n3, int n4) {
        n4 = n3 + n4;
        while (n3 < n4) {
            BitUtils.toBytes(byArray, n2, dArray[n3]);
            n2 += 8;
            ++n3;
        }
    }

    public static void toBytes(byte[] byArray, int n2, double d2) {
        long l2 = Double.doubleToRawLongBits(d2);
        byArray[n2] = (byte)(l2 & 0xFFL);
        byArray[n2 + 1] = (byte)(l2 >> 8 & 0xFFL);
        byArray[n2 + 2] = (byte)(l2 >> 16 & 0xFFL);
        byArray[n2 + 3] = (byte)(l2 >> 24 & 0xFFL);
        byArray[n2 + 4] = (byte)(l2 >> 32 & 0xFFL);
        byArray[n2 + 5] = (byte)(l2 >> 40 & 0xFFL);
        byArray[n2 + 6] = (byte)(l2 >> 48 & 0xFFL);
        byArray[n2 + 7] = (byte)(l2 >> 56 & 0xFFL);
    }

    public static void fromBytes(byte[] byArray, int n2, double[] dArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            dArray[n3] = BitUtils.getDouble(byArray, n2);
            ++n3;
            n2 += 8;
        }
    }

    public static void fromBytes(byte[] byArray, int n2, float[] fArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            fArray[n3] = BitUtils.getFloat(byArray, n2);
            ++n3;
            n2 += 4;
        }
    }

    public static void fromBytes(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[n3] = BitUtils.getInt32(byArray, n2);
            ++n3;
            n2 += 4;
        }
    }

    public static void fromBytes(byte[] byArray, int n2, long[] lArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            lArray[n3] = BitUtils.getInt64(byArray, n2);
            ++n3;
            n2 += 8;
        }
    }

    public static int compareUnsigned(int n2, int n3) {
        return Integer.compare(n2 + Integer.MIN_VALUE, n3 + Integer.MIN_VALUE);
    }

    public static int compareUnsigned(byte by2, byte by3) {
        return Integer.compare(0xFF & by2, 0xFF & by3);
    }

    public static int compareUnsigned(short s2, short s3) {
        return Integer.compare(0xFFFF & s2, 0xFFFF & s3);
    }

    public static int compareUnsigned(long l2, long l3) {
        return Long.compare(l2 + Long.MIN_VALUE, l3 + Long.MIN_VALUE);
    }
}

