/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed.utils;

import com.aspose.threed.utils.BitUtils;
import com.aspose.threed.utils.Stream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;

public class BinaryWriter
implements Closeable,
DataOutput {
    private Stream a;
    private Charset b;
    private byte[] c = new byte[8];
    private CharsetEncoder d;
    private CharBuffer e = CharBuffer.allocate(1);
    private ByteBuffer f = ByteBuffer.wrap(this.c);

    public BinaryWriter(Stream stream) {
        this(stream, StandardCharsets.UTF_8);
    }

    public BinaryWriter(Stream stream, Charset charset) {
        this.a = stream;
        this.b = charset;
        this.d = charset.newEncoder();
    }

    public Stream getBaseStream() {
        return this.a;
    }

    @Override
    public void close() throws IOException {
        this.a.close();
    }

    @Override
    public void write(int n2) throws IOException {
        this.a.writeByte(n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.a.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.a.write(byArray, n2, n3);
    }

    @Override
    public void writeBoolean(boolean bl2) throws IOException {
        this.write(bl2 ? 1 : 0);
    }

    @Override
    public void writeByte(int n2) throws IOException {
        this.write(n2);
    }

    @Override
    public void writeShort(int n2) throws IOException {
        this.c[0] = (byte)n2;
        this.c[1] = (byte)(n2 >>> 8);
        this.a.write(this.c, 0, 2);
    }

    @Override
    public void writeChar(int n2) throws IOException {
        Buffer buffer = this.e;
        ((Buffer)buffer).clear();
        this.e.put((char)n2);
        buffer = this.e;
        ((Buffer)buffer).flip();
        buffer = this.f;
        ((Buffer)buffer).clear();
        this.d.encode(this.e, this.f, false);
        buffer = this.f;
        ((Buffer)buffer).flip();
        BinaryWriter binaryWriter = this;
        binaryWriter.writeBytes(binaryWriter.f);
    }

    @Override
    public void writeInt(int n2) throws IOException {
        BitUtils.toBytes(this.c, 0, n2);
        this.a.write(this.c, 0, 4);
    }

    @Override
    public void writeLong(long l2) throws IOException {
        BitUtils.toBytes(this.c, 0, l2);
        this.a.write(this.c, 0, 8);
    }

    @Override
    public void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    @Override
    public void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    @Override
    public void writeBytes(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a.writeByte((byte)string.charAt(i2));
        }
    }

    public void writeBytes(ByteBuffer object) throws IOException {
        int n2 = ((Buffer)object).limit();
        int n3 = ((ByteBuffer)object).arrayOffset();
        object = ((ByteBuffer)object).array();
        this.a.write((byte[])object, n3, n2);
    }

    @Override
    public void writeChars(String object) throws IOException {
        ByteBuffer byteBuffer = this.d.encode(CharBuffer.wrap((CharSequence)object));
        int n2 = ((String)object).length();
        object = this;
        if (n2 == 0) {
            ((BinaryWriter)object).writeByte(0);
        } else {
            int n3 = 0;
            byte[] byArray = ((BinaryWriter)object).c;
            while (n2 != 0) {
                byArray[n3++] = (byte)(n2 & 0x7F | 0x80);
                n2 >>= 7;
            }
            int n4 = n3 - 1;
            byArray[n4] = (byte)(byArray[n4] & 0x7F);
            ((BinaryWriter)object).write(byArray, 0, n3);
        }
        this.writeBytes(byteBuffer);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.writeChars(string);
    }

    public void flush() throws IOException {
        this.a.flush();
    }
}

