/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed.utils;

import com.aspose.threed.utils.Stream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;

public class BinaryReader
implements Closeable,
DataInput {
    private Stream a;
    private byte[] b = new byte[8];
    private Charset c;
    private ByteBuffer d;
    private CharBuffer e;
    private CharsetDecoder f;
    private int g;

    public BinaryReader(Stream stream) {
        this(stream, StandardCharsets.UTF_8);
    }

    public BinaryReader(Stream stream, Charset charset) {
        this.a = stream;
        this.c = charset;
    }

    public Stream getBaseStream() {
        return this.a;
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.a.read(byArray);
    }

    @Override
    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n3;
        while (n4 > 0) {
            int n5 = this.read(byArray, n2, n3);
            if (n5 == 0 && n4 > 0) {
                throw new IOException("Insufficient data to read.");
            }
            n4 -= n5;
            n2 += n5;
        }
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.a.read(byArray, n2, n3);
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        this.a.seek(n2, 1);
        return 0;
    }

    private void a(int n2) throws IOException {
        BinaryReader binaryReader = this;
        binaryReader.readFully(binaryReader.b, 0, n2);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.a(1);
        return this.b[0] != 0;
    }

    @Override
    public byte readByte() throws IOException {
        this.a(1);
        return this.b[0];
    }

    public byte[] readBytes(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        this.a.read(byArray);
        return byArray;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.a(1);
        return this.b[0] & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        this.a(2);
        return (short)(this.b[1] << 8 | this.b[0] & 0xFF);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.a(2);
        return (this.b[1] & 0xFF) << 8 | this.b[0] & 0xFF;
    }

    @Override
    public char readChar() throws IOException {
        Object object = this;
        if (((BinaryReader)object).f == null) {
            ((BinaryReader)object).f = ((BinaryReader)object).c.newDecoder();
            ((BinaryReader)object).g = (int)((BinaryReader)object).c.newEncoder().maxBytesPerChar();
            ((BinaryReader)object).d = ByteBuffer.allocate(((BinaryReader)object).g);
            ((BinaryReader)object).e = CharBuffer.allocate(10);
        }
        Buffer buffer = this.d;
        ((Buffer)buffer).clear();
        int n2 = 0;
        buffer = this.d;
        ((Buffer)buffer).position(n2);
        buffer = this.e;
        ((Buffer)buffer).clear();
        object = this.d.array();
        for (int i2 = 0; i2 < this.g; ++i2) {
            object[i2] = this.readByte();
            n2 = i2 + 1;
            buffer = this.d;
            ((Buffer)buffer).limit(n2);
            this.f.decode(this.d, this.e, false);
            if (this.e.position() != 1) continue;
            buffer = this.e;
            ((Buffer)buffer).flip();
            return this.e.get();
        }
        return '\uffff';
    }

    @Override
    public int readInt() throws IOException {
        this.a(4);
        return (this.b[3] & 0xFF) << 24 | (this.b[2] & 0xFF) << 16 | (this.b[1] & 0xFF) << 8 | this.b[0] & 0xFF;
    }

    @Override
    public long readLong() throws IOException {
        this.a(8);
        return (long)(this.b[7] & 0xFF) << 56 | (long)(this.b[6] & 0xFF) << 48 | (long)(this.b[5] & 0xFF) << 40 | (long)(this.b[4] & 0xFF) << 32 | (long)(this.b[3] & 0xFF) << 24 | (long)(this.b[2] & 0xFF) << 16 | (long)(this.b[1] & 0xFF) << 8 | (long)(this.b[0] & 0xFF);
    }

    @Override
    public float readFloat() throws IOException {
        int n2 = this.readInt();
        return Float.intBitsToFloat(n2);
    }

    @Override
    public double readDouble() throws IOException {
        long l2 = this.readLong();
        return Double.longBitsToDouble(l2);
    }

    @Override
    public String readLine() throws IOException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String readUTF() throws IOException {
        byte by2;
        BinaryReader binaryReader = this;
        int n2 = 0;
        int n3 = 0;
        do {
            by2 = binaryReader.readByte();
            n2 |= (by2 & 0x7F) << n3;
            n3 += 7;
        } while ((by2 & 0x80) != 0);
        int n4 = n2;
        char[] cArray = new char[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            cArray[n3] = this.readChar();
        }
        return new String(cArray);
    }

    @Override
    public void close() throws IOException {
    }
}

