/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed.utils;

import com.aspose.threed.utils.Out;
import com.aspose.threed.utils.Stream;
import com.aspose.threed.utils.StringNumber;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class AsposeUtils {
    private static TimeZone a = TimeZone.getTimeZone("UTC");

    public static <T> T defaultValue(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (clazz == Byte.TYPE) {
            return (T)Byte.valueOf((byte)0);
        }
        if (clazz == Short.TYPE) {
            return (T)Short.valueOf((short)0);
        }
        if (clazz == Integer.TYPE) {
            return (T)Integer.valueOf(0);
        }
        if (clazz == Long.TYPE) {
            return (T)Long.valueOf(0L);
        }
        if (clazz == Boolean.TYPE) {
            return (T)Boolean.FALSE;
        }
        if (clazz == Character.TYPE) {
            return (T)Character.valueOf('\u0000');
        }
        if (clazz == Float.TYPE) {
            return (T)Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return (T)Double.valueOf(0.0);
        }
        throw new IllegalStateException(String.format("Unsupported java primitive type %s", clazz.toString()));
    }

    public static boolean isEOF(BufferedReader bufferedReader) {
        throw new RuntimeException();
    }

    public static <T> T create(Class<?> clazz, Object ... objectArray) {
        throw new RuntimeException("Not implemented");
    }

    public static String getFileExtension(String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (c2 == '/' || c2 == '\\') {
                return "";
            }
            if (c2 != '.') continue;
            return string.substring(i2);
        }
        return "";
    }

    public static String getFileName(String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '/' && c2 != '\\') continue;
            return string.substring(i2 + 1);
        }
        return string;
    }

    public static boolean isPathRooted(String string) {
        if (string == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        if (string.length() == 0) {
            return false;
        }
        if (AsposeUtils.a(string.charAt(0))) {
            return true;
        }
        return string.length() >= 3 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':' && AsposeUtils.a(string.charAt(2));
    }

    public static String combineFileName(String string, String string2) {
        int n2;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (AsposeUtils.isPathRooted(string2)) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 1);
        if (string.length() > 0) {
            n2 = string.length();
            String string3 = string;
            if (AsposeUtils.a(string3.charAt(string3.length() - 1))) {
                --n2;
            }
            stringBuilder.append(string, 0, n2);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('/');
        }
        if (string2.length() > 0) {
            n2 = 0;
            if (AsposeUtils.a(string2.charAt(0))) {
                ++n2;
            }
            stringBuilder.append(string2, n2, string2.length());
        }
        return stringBuilder.toString();
    }

    private static boolean a(char c2) {
        return c2 == '/' || c2 == '\\';
    }

    public static String getDirectoryName(String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (c2 != '/' && c2 != '\\') continue;
            return string.substring(0, i2);
        }
        return "";
    }

    public static String getFileNameWithoutExtension(String string) {
        int n2;
        if (string == null) {
            return null;
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            int n3 = string.charAt(n2);
            if (n3 != 47 && n3 != 92) continue;
            n3 = string.lastIndexOf(46);
            if (n3 == -1 || n3 < n2) {
                return string.substring(n2 + 1);
            }
            return string.substring(n2 + 1, n3);
        }
        n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static Number asNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof String) {
            return new StringNumber((String)object);
        }
        return null;
    }

    public static boolean castableToNumber(Object object) {
        if (object instanceof Number) {
            return true;
        }
        return object instanceof String;
    }

    public static byte[] toArray(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Invalid input stream");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        AsposeUtils.copyTo(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static int copyTo(Stream stream, Stream stream2) throws IOException {
        int n2;
        if (stream == null) {
            throw new IllegalArgumentException("Invalid input stream");
        }
        if (stream2 == null) {
            throw new IllegalArgumentException("Invalid output stream");
        }
        byte[] byArray = new byte[10240];
        int n3 = 0;
        while ((n2 = stream.read(byArray)) > 0) {
            n3 += n2;
            stream2.write(byArray, 0, n2);
        }
        return n3;
    }

    public static int copyTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        if (inputStream == null) {
            throw new IllegalArgumentException("Invalid input stream");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Invalid output stream");
        }
        byte[] byArray = new byte[10240];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray)) > 0) {
            n3 += n2;
            outputStream.write(byArray, 0, n2);
        }
        return n3;
    }

    public static <E> void copyTo(Collection<E> object, E[] EArray, int n2, int n3) {
        if (object instanceof List) {
            List list = (List)object;
            for (int i2 = 0; i2 < n3; ++i2) {
                EArray[n2 + i2] = list.get(i2);
            }
            return;
        }
        int n4 = n2;
        int n5 = n3;
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (n5-- <= 0) break;
            EArray[n4++] = e2;
        }
    }

    public static <E> void copyTo(Collection<E> collection, E[] EArray, int n2) {
        AsposeUtils.copyTo(collection, EArray, n2, collection.size());
    }

    public static Calendar toUTC(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance(a);
        calendar2.setTimeInMillis(calendar.getTimeInMillis());
        return calendar2;
    }

    public static <K, V> boolean tryGetValue(Map<K, V> map, K k2, @Out V[] VArray) {
        VArray[0] = map.get(k2);
        return VArray[0] != null;
    }

    public static void safeClose(AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static boolean equals(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (stringBuilder == stringBuilder2) {
            return true;
        }
        if (stringBuilder.length() != stringBuilder2.length()) {
            return false;
        }
        int n2 = stringBuilder.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringBuilder.charAt(i2) == stringBuilder2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static String readString(Path object) throws IOException {
        if (object == null || !Files.exists((Path)object, new LinkOption[0])) {
            throw new IllegalArgumentException("Invalid path");
        }
        object = Files.readAllBytes((Path)object);
        return StandardCharsets.UTF_8.decode(ByteBuffer.wrap((byte[])object)).toString();
    }

    public static int charsFromBytes(Charset comparable, byte[] object, int n2, int n3, char[] cArray, int n4) {
        object = ByteBuffer.wrap(object, n2, n3);
        comparable = ((Charset)comparable).decode((ByteBuffer)object);
        int n5 = Math.min(((Buffer)((Object)comparable)).limit(), cArray.length - n4);
        ((CharBuffer)comparable).get(cArray, 0, n5);
        return n5;
    }

    public static List<String> parseCommandLineArguments(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            AsposeUtils.a(arrayList, stringArray[i2]);
        }
        return arrayList;
    }

    private static void a(List<String> list, String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2;
            int n3 = string.charAt(i2);
            if (n3 == 39 || n3 == 34) {
                n2 = n3;
                int n4 = ++i2;
                while (i2 < string.length()) {
                    char c2 = string.charAt(i2);
                    n3 = c2;
                    if (c2 == n2) break;
                    ++i2;
                }
                String string2 = string.substring(n4, i2);
                list.add(string2);
                continue;
            }
            if (Character.isWhitespace((char)n3)) continue;
            n2 = i2;
            while (i2 < string.length()) {
                char c3 = string.charAt(i2);
                n3 = c3;
                if (Character.isWhitespace(c3)) break;
                ++i2;
            }
            String string3 = string.substring(n2, i2);
            list.add(string3);
        }
    }
}

