/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.FVector4;
import com.aspose.threed.Vector3;
import com.aspose.threed.utils.BitUtils;
import com.aspose.threed.utils.Struct;
import java.awt.Color;
import java.io.Serializable;

public final class Vector4
implements Struct<Vector4>,
Serializable,
Comparable<Vector4> {
    public double x;
    public double y;
    public double z;
    public double w;
    static final long serialVersionUID = 274364910L;

    public Vector4(Color color) {
        this.x = (float)color.getRed() / 255.0f;
        this.y = (float)color.getGreen() / 255.0f;
        this.z = (float)color.getBlue() / 255.0f;
        this.w = (float)color.getAlpha() / 255.0f;
    }

    public Vector4(Vector3 vector3, double d2) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
        this.w = d2;
    }

    public Vector4(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
        this.w = 1.0;
    }

    public Vector4(FVector4 fVector4) {
        this.x = fVector4.x;
        this.y = fVector4.y;
        this.z = fVector4.z;
        this.w = fVector4.w;
    }

    public Vector4(double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = 1.0;
    }

    public Vector4(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = d5;
    }

    public static Vector4 add(Vector4 vector4, Vector4 vector42) {
        return new Vector4(vector4.x + vector42.x, vector4.y + vector42.y, vector4.z + vector42.z, vector4.w + vector42.w);
    }

    public static Vector4 sub(Vector4 vector4, Vector4 vector42) {
        return new Vector4(vector4.x - vector42.x, vector4.y - vector42.y, vector4.z - vector42.z, vector4.w - vector42.w);
    }

    public static Vector4 mul(Vector4 vector4, Vector4 vector42) {
        return new Vector4(vector4.x * vector42.x, vector4.y * vector42.y, vector4.z * vector42.z, vector4.w * vector42.w);
    }

    public static Vector4 mul(Vector4 vector4, double d2) {
        return new Vector4(vector4.x * d2, vector4.y * d2, vector4.z * d2, vector4.w * d2);
    }

    public static FVector4 create(Vector4 vector4) {
        return new FVector4((float)vector4.x, (float)vector4.y, (float)vector4.z, (float)vector4.w);
    }

    public final void set(double d2, double d3, double d4) {
        this.set(d2, d3, d4, 1.0);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Vector4)) {
            return false;
        }
        Object object2 = object = ((Vector4)object).clone();
        object = this;
        return ((Vector4)object).x == ((Vector4)object2).x && ((Vector4)object).y == ((Vector4)object2).y && ((Vector4)object).z == ((Vector4)object2).z && ((Vector4)object).w == ((Vector4)object2).w;
    }

    public final void set(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = d5;
    }

    public final String toString() {
        return String.format("(%.0f %.0f %.0f %.0f)", this.x, this.y, this.z, this.w);
    }

    final boolean a(Vector4 vector4) {
        double d2;
        double d3 = this.x - vector4.x;
        double d4 = this.y - vector4.y;
        double d5 = this.z - vector4.z;
        double d6 = this.w - vector4.w;
        double d7 = d3;
        double d8 = d4;
        double d9 = d5;
        double d10 = d6;
        double d11 = d7 * d7 + d8 * d8 + d9 * d9 + d10 * d10;
        return d2 < 1.0E-8;
    }

    @Override
    public final int compareTo(Vector4 vector4) {
        int n2 = Double.compare(this.x, vector4.x);
        if (n2 != 0) {
            return n2;
        }
        n2 = Double.compare(this.y, vector4.y);
        if (n2 != 0) {
            return n2;
        }
        n2 = Double.compare(this.z, vector4.z);
        if (n2 != 0) {
            return n2;
        }
        return Double.compare(this.w, vector4.w);
    }

    public Vector4() {
    }

    private Vector4(Vector4 vector4) {
        this.x = vector4.x;
        this.y = vector4.y;
        this.z = vector4.z;
        this.w = vector4.w;
    }

    @Override
    public final Vector4 clone() {
        return new Vector4(this);
    }

    @Override
    public final void copyFrom(Vector4 vector4) {
        if (vector4 == null) {
            return;
        }
        this.x = vector4.x;
        this.y = vector4.y;
        this.z = vector4.z;
        this.w = vector4.w;
    }

    public final int hashCode() {
        return BitUtils.hashCode(this.x) ^ BitUtils.hashCode(this.y) ^ BitUtils.hashCode(this.z) ^ BitUtils.hashCode(this.w);
    }
}

