/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.FVector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.a;
import com.aspose.threed.utils.BitUtils;
import com.aspose.threed.utils.Struct;
import java.awt.Color;
import java.io.Serializable;

public final class Vector3
implements Struct<Vector3>,
Serializable,
Comparable<Vector3> {
    public double x;
    public double y;
    public double z;
    public static final Vector3 ORIGIN = new Vector3(0.0, 0.0, 0.0);
    public static final Vector3 UNIT_SCALE = new Vector3(1.0, 1.0, 1.0);
    public static final Vector3 X_AXIS = new Vector3(1.0, 0.0, 0.0);
    public static final Vector3 Y_AXIS = new Vector3(0.0, 1.0, 0.0);
    public static final Vector3 Z_AXIS = new Vector3(0.0, 0.0, 1.0);
    static final long serialVersionUID = 1033879797L;

    public Vector3(double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    public Vector3(FVector3 fVector3) {
        this.x = fVector3.x;
        this.y = fVector3.y;
        this.z = fVector3.z;
    }

    public Vector3(Color color) {
        this.x = (float)color.getRed() / 255.0f;
        this.y = (float)color.getGreen() / 255.0f;
        this.z = (float)color.getBlue() / 255.0f;
    }

    public Vector3(double d2) {
        this.z = d2;
        this.y = d2;
        this.x = d2;
    }

    public Vector3(Vector4 vector4) {
        this.x = vector4.x;
        this.y = vector4.y;
        this.z = vector4.z;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Vector3)) {
            return false;
        }
        object = ((Vector3)object).clone();
        return this.x == ((Vector3)object).x && this.y == ((Vector3)object).y && this.z == ((Vector3)object).z;
    }

    public static FVector3 create(Vector3 vector3) {
        return new FVector3((float)vector3.x, (float)vector3.y, (float)vector3.z);
    }

    final void a(Vector3 vector3) {
        if (vector3.x < this.x) {
            this.x = vector3.x;
        }
        if (vector3.y < this.y) {
            this.y = vector3.y;
        }
        if (vector3.z < this.z) {
            this.z = vector3.z;
        }
    }

    final void a(double d2, double d3, double d4) {
        if (d2 < this.x) {
            this.x = d2;
        }
        if (d3 < this.y) {
            this.y = d3;
        }
        if (d4 < this.z) {
            this.z = d4;
        }
    }

    final void b(Vector3 vector3) {
        if (vector3.x > this.x) {
            this.x = vector3.x;
        }
        if (vector3.y > this.y) {
            this.y = vector3.y;
        }
        if (vector3.z > this.z) {
            this.z = vector3.z;
        }
    }

    final void b(double d2, double d3, double d4) {
        if (d2 > this.x) {
            this.x = d2;
        }
        if (d3 > this.y) {
            this.y = d3;
        }
        if (d4 > this.z) {
            this.z = d4;
        }
    }

    public final double dot(Vector3 vector3) {
        return this.x * vector3.x + this.y * vector3.y + this.z * vector3.z;
    }

    public final Vector3 normalize() {
        double d2;
        double d3 = this.getLength();
        if (d2 > 0.0) {
            double d4 = 1.0 / d3;
            return new Vector3(this.x * d4, this.y * d4, this.z * d4);
        }
        return this.clone();
    }

    public final double getLength2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    static double c(double d2, double d3, double d4) {
        double d5 = d2;
        double d6 = d3;
        double d7 = d4;
        return Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
    }

    final boolean a(Vector3 vector3, double d2) {
        double d3 = this.x - vector3.x;
        double d4 = this.y - vector3.y;
        double d5 = this.z - vector3.z;
        if (Math.abs(d3) > d2) {
            return false;
        }
        if (Math.abs(d4) > d2) {
            return false;
        }
        return !(Math.abs(d5) > d2);
    }

    public final double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    final boolean a() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public final Vector3 sin() {
        return new Vector3(Math.sin(this.x), Math.sin(this.y), Math.sin(this.z));
    }

    public final Vector3 cos() {
        return new Vector3(Math.cos(this.x), Math.cos(this.y), Math.cos(this.z));
    }

    public final Vector3 cross(Vector3 vector3) {
        return new Vector3(this.y * vector3.z - this.z * vector3.y, this.z * vector3.x - this.x * vector3.z, this.x * vector3.y - this.y * vector3.x);
    }

    final Vector3 d(double d2, double d3, double d4) {
        return new Vector3(this.y * d4 - this.z * d3, this.z * d2 - this.x * d4, this.x * d3 - this.y * d2);
    }

    public static Vector3 negative(Vector3 vector3) {
        return new Vector3(-vector3.x, -vector3.y, -vector3.z);
    }

    public static Vector3 sub(Vector3 vector3, Vector3 vector32) {
        return new Vector3(vector3.x - vector32.x, vector3.y - vector32.y, vector3.z - vector32.z);
    }

    public static Vector3 add(Vector3 vector3, Vector3 vector32) {
        return new Vector3(vector3.x + vector32.x, vector3.y + vector32.y, vector3.z + vector32.z);
    }

    public static Vector3 mul(Vector3 vector3, Vector3 vector32) {
        return new Vector3(vector3.x * vector32.x, vector3.y * vector32.y, vector3.z * vector32.z);
    }

    public static Vector3 mul(double d2, Vector3 vector3) {
        return new Vector3(d2 * vector3.x, d2 * vector3.y, d2 * vector3.z);
    }

    public static Vector3 mul(Vector3 vector3, double d2) {
        return new Vector3(vector3.x * d2, vector3.y * d2, vector3.z * d2);
    }

    public static Vector3 div(Vector3 vector3, double d2) {
        double d3 = 1.0 / d2;
        return new Vector3(vector3.x * d3, vector3.y * d3, vector3.z * d3);
    }

    public static boolean op_eq(Vector3 vector3, Vector3 vector32) {
        return vector3.x == vector32.x && vector3.y == vector32.y && vector3.z == vector32.z;
    }

    public static boolean op_ne(Vector3 vector3, Vector3 vector32) {
        return vector3.x != vector32.x || vector3.y != vector32.y || vector3.z != vector32.z;
    }

    public final void set(double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    public final String toString() {
        return String.format("(%.0f %.0f %.0f)", this.x, this.y, this.z);
    }

    final boolean c(Vector3 vector3) {
        double d2 = Math.abs(this.x - vector3.x);
        double d3 = Math.abs(this.y - vector3.y);
        double d4 = Math.abs(this.z - vector3.z);
        return d2 < 1.0E-10 && d3 < 1.0E-10 && d4 < 1.0E-10;
    }

    public final double angleBetween(Vector3 vector3, Vector3 vector32) {
        Vector3 vector33;
        double d2 = this.dot(vector3) / Math.sqrt(this.getLength2() * vector3.getLength2());
        if (a.a(Math.abs(d2) - 1.0)) {
            if (d2 > 0.0) {
                return 0.0;
            }
            return Math.PI;
        }
        double d3 = Math.acos(d2);
        vector3 = this.cross(vector3);
        if (vector33.dot(vector32) > 0.0) {
            return d3;
        }
        return Math.PI * 2 - d3;
    }

    public final double angleBetween(Vector3 vector3) {
        double d2 = this.dot(vector3) / Math.sqrt(this.getLength2() * vector3.getLength2());
        if (a.a(Math.abs(d2) - 1.0)) {
            if (d2 > 0.0) {
                return 0.0;
            }
            return Math.PI;
        }
        return Math.acos(d2);
    }

    @Override
    public final int compareTo(Vector3 vector3) {
        int n2 = Double.compare(this.x, vector3.x);
        if (n2 != 0) {
            return n2;
        }
        n2 = Double.compare(this.y, vector3.y);
        if (n2 != 0) {
            return n2;
        }
        n2 = Double.compare(this.z, vector3.z);
        return n2;
    }

    public Vector3() {
    }

    private Vector3(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
    }

    @Override
    public final Vector3 clone() {
        return new Vector3(this);
    }

    @Override
    public final void copyFrom(Vector3 vector3) {
        if (vector3 == null) {
            return;
        }
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
    }

    public final int hashCode() {
        return BitUtils.hashCode(this.x) ^ BitUtils.hashCode(this.y) ^ BitUtils.hashCode(this.z);
    }
}

