/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.FVector2;
import com.aspose.threed.utils.BitUtils;
import com.aspose.threed.utils.Struct;
import java.io.Serializable;

public final class Vector2
implements Struct<Vector2>,
Serializable,
Comparable<Vector2> {
    static final Vector2 a = new Vector2(0.0, 0.0);
    public double x;
    public double y;
    static final long serialVersionUID = -532204144L;

    public Vector2(double d2) {
        this.x = d2;
        this.y = d2;
    }

    public Vector2(FVector2 fVector2) {
        this.x = fVector2.x;
        this.y = fVector2.y;
    }

    public static FVector2 create(Vector2 vector2) {
        return new FVector2((float)vector2.x, (float)vector2.y);
    }

    public final double getU() {
        return this.x;
    }

    public final void setU(double d2) {
        this.x = d2;
    }

    public final double getV() {
        return this.y;
    }

    public final void setV(double d2) {
        this.y = d2;
    }

    public Vector2(double d2, double d3) {
        this.x = d2;
        this.y = d3;
    }

    public final double dot(Vector2 vector2) {
        return this.x * vector2.x + this.y * vector2.y;
    }

    public final double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    final double a() {
        return this.x * this.x + this.y * this.y;
    }

    final boolean b() {
        return this.x == 0.0 && this.y == 0.0;
    }

    final boolean a(Vector2 vector2, double d2) {
        double d3 = this.x - vector2.x;
        double d4 = this.y - vector2.y;
        if (Math.abs(d3) > 1.0E-10) {
            return false;
        }
        return !(Math.abs(d4) > 1.0E-10);
    }

    public static Vector2 add(Vector2 vector2, Vector2 vector22) {
        return new Vector2(vector2.x + vector22.x, vector2.y + vector22.y);
    }

    public static Vector2 sub(Vector2 vector2, Vector2 vector22) {
        return new Vector2(vector2.x - vector22.x, vector2.y - vector22.y);
    }

    public static Vector2 div(Vector2 vector2, double d2) {
        return new Vector2(vector2.x / d2, vector2.y / d2);
    }

    public static Vector2 mul(Vector2 vector2, double d2) {
        return new Vector2(vector2.x * d2, vector2.y * d2);
    }

    public static Vector2 mul(double d2, Vector2 vector2) {
        return new Vector2(d2 * vector2.x, d2 * vector2.y);
    }

    public static boolean op_eq(Vector2 vector2, Vector2 vector22) {
        return vector2.equals(vector22);
    }

    public static boolean op_ne(Vector2 vector2, Vector2 vector22) {
        return !vector2.equals(vector22);
    }

    public final boolean equals(Vector2 vector2) {
        return this.x == vector2.x && this.y == vector2.y;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Vector2)) {
            return false;
        }
        object = ((Vector2)object).clone();
        return this.x == ((Vector2)object).x && this.y == ((Vector2)object).y;
    }

    final void a(Vector2 vector2) {
        if (vector2.x < this.x) {
            this.x = vector2.x;
        }
        if (vector2.y < this.y) {
            this.y = vector2.y;
        }
    }

    final void b(Vector2 vector2) {
        if (vector2.x > this.x) {
            this.x = vector2.x;
        }
        if (vector2.y > this.y) {
            this.y = vector2.y;
        }
    }

    public final String toString() {
        return String.format("(%.0f %.0f)", this.x, this.y);
    }

    public final double cross(Vector2 vector2) {
        return this.x * vector2.y - this.y * vector2.x;
    }

    public final Vector2 normalize() {
        double d2 = 1.0 / this.getLength();
        return new Vector2(this.x * d2, this.y * d2);
    }

    @Override
    public final int compareTo(Vector2 vector2) {
        int n2 = Double.compare(this.x, vector2.x);
        if (n2 != 0) {
            return n2;
        }
        n2 = Double.compare(this.y, vector2.y);
        return n2;
    }

    public Vector2() {
    }

    private Vector2(Vector2 vector2) {
        this.x = vector2.x;
        this.y = vector2.y;
    }

    @Override
    public final Vector2 clone() {
        return new Vector2(this);
    }

    @Override
    public final void copyFrom(Vector2 vector2) {
        if (vector2 == null) {
            return;
        }
        this.x = vector2.x;
        this.y = vector2.y;
    }

    public final int hashCode() {
        return BitUtils.hashCode(this.x) ^ BitUtils.hashCode(this.y);
    }
}

