/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.Entity;
import com.aspose.threed.FVector2;
import com.aspose.threed.FVector3;
import com.aspose.threed.FVector4;
import com.aspose.threed.Geometry;
import com.aspose.threed.MappingMode;
import com.aspose.threed.Mesh;
import com.aspose.threed.PointCloud;
import com.aspose.threed.PolygonModifier;
import com.aspose.threed.Vector2;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.Vertex;
import com.aspose.threed.VertexDeclaration;
import com.aspose.threed.VertexElement;
import com.aspose.threed.VertexElementType;
import com.aspose.threed.VertexField;
import com.aspose.threed.VertexFieldSemantic;
import com.aspose.threed.b;
import com.aspose.threed.cH;
import com.aspose.threed.eX;
import com.aspose.threed.lq;
import com.aspose.threed.lr;
import com.aspose.threed.ls;
import com.aspose.threed.lt;
import com.aspose.threed.mw;
import com.aspose.threed.mx;
import com.aspose.threed.utils.AsposeUtils;
import com.aspose.threed.utils.Stream;
import com.aspose.threed.utils.StringUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;

public class TriMesh
extends Entity
implements Iterable<Vertex> {
    VertexDeclaration decl;
    private int numUnmergedVertices;
    ls storage;
    private Vertex lastVertex;
    private TreeMap<Vertex, Integer> vertexIndices;
    eX faceIndices;

    public TriMesh(String object, VertexDeclaration vertexDeclaration) {
        super((String)object);
        object = this;
        try {
            ((TriMesh)object).lastVertex = null;
            ((TriMesh)object).vertexIndices = new TreeMap();
            ((TriMesh)object).faceIndices = new eX();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.decl = vertexDeclaration;
        vertexDeclaration.a();
        this.storage = TriMesh.a(this.decl) ? new lr() : new lq();
        this.storage.b = this.decl;
    }

    private static boolean a(VertexDeclaration vertexDeclaration) {
        for (int i2 = 0; i2 < vertexDeclaration.getCount(); ++i2) {
            VertexField vertexField = vertexDeclaration.b.get(i2);
            int n2 = vertexField.a;
            if ((n2 >>= 4) == 1) continue;
            return false;
        }
        return true;
    }

    public VertexDeclaration getVertexDeclaration() {
        return this.decl;
    }

    public int getVerticesCount() {
        return this.storage.d;
    }

    public int getIndicesCount() {
        return this.faceIndices.size();
    }

    public int getUnmergedVerticesCount() {
        return this.numUnmergedVertices;
    }

    public int getCapacity() {
        return this.storage.c;
    }

    public int getVerticesSizeInBytes() {
        return this.storage.d * this.decl.a;
    }

    public static TriMesh fromMesh(VertexDeclaration iterable, Mesh entity) {
        boolean bl2 = iterable.a(VertexFieldSemantic.POSITION) != null;
        if (!bl2) {
            throw new IllegalStateException(cH.l());
        }
        if (!entity.c()) {
            entity = PolygonModifier.triangulate(entity);
        }
        iterable = new TriMesh("", (VertexDeclaration)iterable);
        Mesh mesh = entity;
        entity = iterable;
        boolean bl3 = false;
        TriMesh triMesh = iterable;
        mw mw2 = new mw(mesh);
        triMesh.a(mesh, mw2, false);
        return iterable;
    }

    static TriMesh a(PointCloud object, boolean bl2) {
        VertexDeclaration vertexDeclaration = VertexDeclaration.fromGeometry((Geometry)object, true);
        Object object2 = vertexDeclaration;
        object2 = object;
        object = vertexDeclaration;
        boolean bl3 = vertexDeclaration.a(VertexFieldSemantic.POSITION) != null;
        if (!bl3) {
            throw new IllegalStateException(cH.l());
        }
        object = new TriMesh("", (VertexDeclaration)object);
        mw mw2 = new mw((Geometry)object2);
        super.a((PointCloud)object2, mw2, false);
        return object;
    }

    private void a(PointCloud pointCloud, mw mw2, boolean bl2) {
        VertexDeclaration vertexDeclaration = this.decl;
        VertexElement[] vertexElementArray = new VertexElement[vertexDeclaration.b.size()];
        int n2 = 0;
        VertexField vertexField = null;
        for (VertexField vertexField2 : vertexDeclaration.b) {
            TriMesh.a(vertexField2);
            if (vertexField2.b == VertexFieldSemantic.POSITION) {
                if (vertexField != null) {
                    throw new IllegalStateException(cH.m());
                }
                vertexField = vertexField2;
                ++n2;
                continue;
            }
            VertexElement vertexElement = TriMesh.a(mw2, vertexField2.b, vertexField2.c);
            if (vertexElement != null && vertexElement.c == MappingMode.CONTROL_POINT) {
                vertexElementArray[n2] = vertexElement;
            }
            ++n2;
        }
        int n3 = pointCloud.controlPoints.b;
        this.storage.a(n3);
        this.faceIndices.b(n3);
        this.storage.a(pointCloud, vertexField, vertexElementArray);
    }

    private void a(Mesh mesh, mw mw2, boolean bl2) {
        VertexDeclaration vertexDeclaration = this.decl;
        VertexElement[] vertexElementArray = new VertexElement[vertexDeclaration.b.size()];
        int n2 = 0;
        VertexField vertexField = null;
        for (VertexField vertexField2 : vertexDeclaration.b) {
            TriMesh.a(vertexField2);
            if (vertexField2.b == VertexFieldSemantic.POSITION) {
                if (vertexField != null) {
                    throw new IllegalStateException(cH.m());
                }
                vertexField = vertexField2;
                ++n2;
                continue;
            }
            VertexElement vertexElement = TriMesh.a(mw2, vertexField2.b, vertexField2.c);
            if (vertexElement != null) {
                vertexElementArray[n2] = mx.b(vertexElement, mesh);
            }
            ++n2;
        }
        int n3 = mesh.polygons.size() * 3;
        this.storage.a(n3);
        this.faceIndices.b(n3);
        this.storage.a(this, mesh, vertexField, vertexElementArray, bl2);
    }

    final void a(Mesh mesh, mw mw2) {
        this.a(mesh, mw2, false);
    }

    public static TriMesh copyFrom(TriMesh triMesh, VertexDeclaration vertexDeclaration) {
        if (triMesh == null) {
            throw new IllegalArgumentException("Argument input cannot be null");
        }
        if (vertexDeclaration == null) {
            throw new IllegalArgumentException("Argument vd cannot be null");
        }
        TriMesh triMesh2 = new TriMesh("", vertexDeclaration);
        new TriMesh("", vertexDeclaration).storage.d = triMesh.storage.d;
        triMesh2.storage.a(triMesh.storage.d);
        triMesh2.faceIndices.a(triMesh.faceIndices);
        for (int i2 = 0; i2 < vertexDeclaration.b.size(); ++i2) {
            VertexField vertexField = vertexDeclaration.b.get(i2);
            VertexField vertexField2 = triMesh.getVertexDeclaration().a(vertexField.b);
            if (vertexField2 == null) continue;
            TriMesh.a(triMesh2, vertexField, triMesh, vertexField2);
        }
        return triMesh2;
    }

    private static boolean a(TriMesh triMesh, VertexField vertexField, TriMesh triMesh2, VertexField vertexField2) {
        float[] fArray = new float[4];
        int n2 = vertexField.a >> 4;
        int n3 = vertexField2.a >> 4;
        int n4 = vertexField2.a & 0xF;
        int n5 = vertexField.a & 0xF;
        if (n2 != 2 && n2 != 1) {
            return false;
        }
        if (n3 != 2 && n3 != 1) {
            return false;
        }
        if (vertexField.b == VertexFieldSemantic.POSITION) {
            fArray[3] = 1.0f;
        }
        for (n2 = 0; n2 < triMesh.storage.d; ++n2) {
            triMesh2.storage.a(n2, vertexField2, fArray, n4);
            triMesh.storage.b(n2, vertexField, fArray, n5);
        }
        return true;
    }

    private static void a(VertexField vertexField) {
        int n2 = vertexField.a;
        int n3 = n2 >> 4;
        n2 &= 0xF;
        switch (vertexField.b) {
            case BINORMAL: 
            case NORMAL: 
            case POSITION: 
            case SPECULAR: 
            case TANGENT: 
            case VERTEX_COLOR: {
                if (n2 != 3 && n2 != 4) {
                    throw new ClassCastException(StringUtils.format(cH.n(), vertexField.b.toString()));
                }
                if ((n3 & 3) != 0) break;
                throw new ClassCastException(StringUtils.format(cH.o(), vertexField.b.toString()));
            }
            case UV: {
                if ((n3 & 3) != 0) break;
                throw new ClassCastException(StringUtils.format(cH.o(), vertexField.b.toString()));
            }
            case EDGE_CREASE: 
            case VERTEX_CREASE: 
            case WEIGHT: {
                if ((n3 & 3) != 0) break;
                throw new ClassCastException(StringUtils.format(cH.o(), vertexField.b.toString()));
            }
            case VISIBILITY: 
            case USER_DATA: {
                if ((n3 & 3) == 0) break;
                throw new ClassCastException(StringUtils.format(cH.p(), vertexField.b.toString()));
            }
        }
    }

    private static VertexElement a(mw mw2, VertexFieldSemantic enum_, int n2) {
        enum_ = VertexDeclaration.b((VertexFieldSemantic)enum_);
        return mw2.a((VertexElementType)enum_, n2);
    }

    public static TriMesh fromMesh(Mesh mesh, boolean bl2) {
        if (!mesh.c()) {
            mesh = PolygonModifier.triangulate(mesh);
        }
        VertexDeclaration vertexDeclaration = VertexDeclaration.fromGeometry(mesh, bl2);
        return TriMesh.fromMesh(vertexDeclaration, mesh);
    }

    public static TriMesh fromMesh(Mesh mesh) {
        return TriMesh.fromMesh(mesh, true);
    }

    public Vertex beginVertex() {
        if (this.lastVertex != null) {
            throw new IllegalStateException(cH.q());
        }
        if (this.storage.c == this.storage.d) {
            this.storage.a(this.storage.c << 1);
        }
        this.lastVertex = this.storage.b(this.storage.d);
        return this.lastVertex;
    }

    public void endVertex() {
        int n2;
        Integer[] integerArray = new Integer[1];
        if (this.lastVertex == null) {
            throw new IllegalStateException(cH.r());
        }
        if (!AsposeUtils.tryGetValue(this.vertexIndices, this.lastVertex, integerArray)) {
            if (integerArray[0] != null) {
                integerArray[0].intValue();
            }
            n2 = this.lastVertex.a;
            this.vertexIndices.put(this.lastVertex, n2);
            ++this.storage.d;
        } else {
            n2 = integerArray[0] == null ? 0 : integerArray[0];
        }
        ++this.numUnmergedVertices;
        this.faceIndices.c(n2);
        this.lastVertex = null;
    }

    public void writeVerticesTo(Stream stream) throws IOException {
        if (this.storage.d == 0) {
            return;
        }
        this.storage.a(stream);
    }

    public void write16bIndicesTo(Stream stream) throws IOException {
        int[] nArray = this.faceIndices.b();
        short[] sArray = new short[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            sArray[i2] = (short)nArray[i2];
        }
        b.a(stream, (Object)sArray);
    }

    public void write32bIndicesTo(Stream stream) throws IOException {
        int[] nArray = this.faceIndices.b();
        b.a(stream, (Object)nArray);
    }

    public byte[] verticesToArray() {
        return this.storage.a();
    }

    @Deprecated
    public void indicesToArray(short[][] sArray) {
        sArray[0] = this.getShortIndices();
    }

    public short[] getShortIndices() {
        int[] nArray = this.faceIndices.b();
        short[] sArray = new short[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            sArray[i2] = (short)nArray[i2];
        }
        return sArray;
    }

    public int[] getIntIndices() {
        return this.faceIndices.b();
    }

    @Deprecated
    public void indicesToArray(int[][] nArray) {
        nArray[0] = this.faceIndices.b();
    }

    public String toString() {
        int n2 = this.decl.a * this.storage.d;
        return String.format("%d vertices in %d bytes", this.storage.d, n2);
    }

    public static TriMesh fromRawData(VertexDeclaration iterable, byte[] byArray, int[] nArray, boolean bl2) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument vd cannot be null");
        }
        if (((VertexDeclaration)iterable).b.isEmpty()) {
            throw new IllegalArgumentException("Vertex declaration cannot be undefined");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Argument vertices cannot be null");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("Argument indices cannot be null");
        }
        int n2 = byArray.length / ((VertexDeclaration)iterable).getSize();
        iterable = new TriMesh("", (VertexDeclaration)iterable);
        v0.numUnmergedVertices = n2;
        ((TriMesh)iterable).storage.d = n2;
        ((TriMesh)iterable).storage.a(n2);
        ((TriMesh)iterable).storage.a(byArray);
        ((TriMesh)iterable).faceIndices.b(nArray);
        if (bl2) {
            super.b();
        }
        return iterable;
    }

    private void b() {
        for (int i2 = 0; i2 < this.storage.d; ++i2) {
            Vertex vertex = this.storage.b(i2);
            this.vertexIndices.put(vertex, i2);
        }
    }

    public Vector4 readVector4(int n2, VertexField vertexField) {
        return this.storage.a(n2, vertexField);
    }

    public FVector4 readFVector4(int n2, VertexField vertexField) {
        return this.storage.b(n2, vertexField);
    }

    public Vector3 readVector3(int n2, VertexField vertexField) {
        return this.storage.c(n2, vertexField);
    }

    public FVector3 readFVector3(int n2, VertexField vertexField) {
        return this.storage.d(n2, vertexField);
    }

    public Vector2 readVector2(int n2, VertexField vertexField) {
        return this.storage.e(n2, vertexField);
    }

    public FVector2 readFVector2(int n2, VertexField vertexField) {
        return this.storage.f(n2, vertexField);
    }

    public double readDouble(int n2, VertexField vertexField) {
        return this.storage.g(n2, vertexField);
    }

    public float readFloat(int n2, VertexField vertexField) {
        return this.storage.h(n2, vertexField);
    }

    @Override
    public Iterator<Vertex> iterator() {
        return new lt(this);
    }
}

