/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.Axis;
import com.aspose.threed.ComposeOrder;
import com.aspose.threed.MathUtils;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Quaternion;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.lo;

public class TransformBuilder {
    private Matrix4 a = new Matrix4();
    private ComposeOrder b = ComposeOrder.APPEND;

    public Matrix4 getMatrix() {
        return this.a.clone();
    }

    public void setMatrix(Matrix4 matrix4) {
        this.a.copyFrom(matrix4);
    }

    public ComposeOrder getComposeOrder() {
        return this.b;
    }

    public void setComposeOrder(ComposeOrder composeOrder) {
        this.b = composeOrder;
    }

    public TransformBuilder(Matrix4 matrix4, ComposeOrder composeOrder) {
        this.a.copyFrom(matrix4);
        this.setComposeOrder(composeOrder);
    }

    public TransformBuilder(ComposeOrder composeOrder) {
        this.a.copyFrom(Matrix4.getIdentity());
        this.setComposeOrder(composeOrder);
    }

    public TransformBuilder() {
        this(ComposeOrder.APPEND);
    }

    public void compose(Matrix4 matrix4) {
        if (this.getComposeOrder() == ComposeOrder.APPEND) {
            this.a.copyFrom(Matrix4.mul(this.a, matrix4));
            return;
        }
        this.a.copyFrom(Matrix4.mul(matrix4, this.a));
    }

    public TransformBuilder append(Matrix4 matrix4) {
        this.a.copyFrom(Matrix4.mul(this.a, matrix4));
        return this;
    }

    public TransformBuilder prepend(Matrix4 matrix4) {
        this.a.copyFrom(Matrix4.mul(matrix4, this.a));
        return this;
    }

    public TransformBuilder rearrange(Axis axis, Axis axis2, Axis axis3) {
        Matrix4 matrix4 = new Matrix4(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        matrix4.a(0, TransformBuilder.a(axis));
        matrix4.a(1, TransformBuilder.a(axis2));
        matrix4.a(2, TransformBuilder.a(axis3));
        this.compose(matrix4);
        return this;
    }

    private static Vector4 a(Axis axis) {
        switch (axis) {
            case X_AXIS: {
                return new Vector4(1.0, 0.0, 0.0, 0.0);
            }
            case Y_AXIS: {
                return new Vector4(0.0, 1.0, 0.0, 0.0);
            }
            case Z_AXIS: {
                return new Vector4(0.0, 0.0, 1.0, 0.0);
            }
        }
        throw new RuntimeException("Invalid axis value");
    }

    public TransformBuilder scale(double d2) {
        double d3 = d2;
        this.scale(d3, d3, d2);
        return this;
    }

    public TransformBuilder scale(double d2, double d3, double d4) {
        this.compose(lo.b(d2, d3, d4));
        return this;
    }

    public TransformBuilder scale(Vector3 vector3) {
        this.compose(lo.b(vector3));
        return this;
    }

    public TransformBuilder rotateDegree(double d2, Vector3 vector3) {
        this.compose(lo.a(MathUtils.toRadian(d2), vector3));
        return this;
    }

    public TransformBuilder rotateRadian(double d2, Vector3 vector3) {
        this.compose(lo.a(d2, vector3));
        return this;
    }

    public TransformBuilder rotate(Quaternion quaternion) {
        this.compose(quaternion.toMatrix());
        return this;
    }

    public TransformBuilder rotateEulerDegree(double d2, double d3, double d4) {
        this.rotateEulerRadian(MathUtils.toRadian(d2), MathUtils.toRadian(d3), MathUtils.toRadian(d4));
        return this;
    }

    public TransformBuilder rotateEulerRadian(double d2, double d3, double d4) {
        this.compose(lo.c(new Vector3(d2, d3, d4)));
        return this;
    }

    public TransformBuilder rotateEulerRadian(Vector3 vector3) {
        this.compose(lo.c(vector3));
        return this;
    }

    public TransformBuilder translate(double d2, double d3, double d4) {
        this.compose(lo.a(d2, d3, d4));
        return this;
    }

    public TransformBuilder translate(Vector3 vector3) {
        this.compose(lo.a(vector3.x, vector3.y, vector3.z));
        return this;
    }

    public void reset() {
        this.a.copyFrom(Matrix4.getIdentity());
    }
}

