/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.BoundingBox;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Mesh;
import com.aspose.threed.Primitive;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.a;
import com.aspose.threed.dX;
import com.aspose.threed.hi;

public class Sphere
extends Primitive {
    private double radius;
    private int widthSegments;
    private int heightSegments;
    private double phiStart;
    private double phiLength;
    private double thetaStart;
    private double thetaLength;

    public Sphere() {
        this(1.0);
    }

    public Sphere(double d2) {
        this(d2, 12, 8);
    }

    public Sphere(double d2, int n2, int n3) {
        this("", d2, n2, n3, 0.0, Math.PI * 2, 0.0, Math.PI);
    }

    public Sphere(String string, double d2, int n2, int n3, double d3, double d4, double d5, double d6) {
        super(string);
        this.radius = d2;
        this.setWidthSegments(n2);
        this.setHeightSegments(n3);
        this.phiStart = d3;
        this.phiLength = d4;
        this.thetaStart = d5;
        this.thetaLength = d6;
    }

    public boolean equals(Object object) {
        if ((object = object instanceof Sphere ? (Sphere)object : null) == null) {
            return false;
        }
        return a.a(this.radius, ((Sphere)object).radius) && this.widthSegments == ((Sphere)object).widthSegments && this.heightSegments == ((Sphere)object).heightSegments && a.a(this.phiStart, ((Sphere)object).phiStart) && a.a(this.phiLength, ((Sphere)object).phiLength) && a.a(this.thetaStart, ((Sphere)object).thetaStart) && a.a(this.thetaLength, ((Sphere)object).thetaLength);
    }

    public int getWidthSegments() {
        return this.widthSegments;
    }

    public void setWidthSegments(int n2) {
        this.widthSegments = Math.max(3, n2);
    }

    public int getHeightSegments() {
        return this.heightSegments;
    }

    public void setHeightSegments(int n2) {
        this.heightSegments = Math.max(2, n2);
    }

    public double getPhiStart() {
        return this.phiStart;
    }

    public void setPhiStart(double d2) {
        this.phiStart = d2;
    }

    public double getPhiLength() {
        return this.phiLength;
    }

    public void setPhiLength(double d2) {
        this.phiLength = d2;
    }

    public double getThetaStart() {
        return this.thetaStart;
    }

    public void setThetaStart(double d2) {
        this.thetaStart = d2;
    }

    public double getThetaLength() {
        return this.thetaLength;
    }

    public void setThetaLength(double d2) {
        this.thetaLength = d2;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d2) {
        this.radius = d2;
    }

    @Override
    final BoundingBox a(Matrix4 matrix4) {
        double d2 = this.radius;
        BoundingBox boundingBox = new BoundingBox();
        boundingBox.a(Matrix4.mul(matrix4, new Vector3(0.0, 0.0, d2)));
        boundingBox.a(Matrix4.mul(matrix4, new Vector3(0.0, 0.0, -d2)));
        boundingBox.a(Matrix4.mul(matrix4, new Vector3(0.0, d2, 0.0)));
        boundingBox.a(Matrix4.mul(matrix4, new Vector3(0.0, -d2, 0.0)));
        boundingBox.a(Matrix4.mul(matrix4, new Vector3(d2, 0.0, 0.0)));
        boundingBox.a(Matrix4.mul(matrix4, new Vector3(-d2, 0.0, 0.0)));
        return boundingBox;
    }

    @Override
    public Mesh toMesh() {
        int n2;
        int n3;
        Mesh mesh = this.createEmptyMesh();
        double d2 = this.thetaStart + this.thetaLength;
        int n4 = (this.widthSegments + 1) * (this.heightSegments + 1);
        Vector4[] vector4Array = (Vector4[])hi.c.newArray(n4);
        Vector4[] vector4Array2 = (Vector4[])hi.c.newArray(n4);
        Vector4[] vector4Array3 = (Vector4[])hi.c.newArray(n4);
        int n5 = 0;
        int[][] nArrayArray = new int[this.heightSegments + 1][];
        for (n3 = 0; n3 <= this.heightSegments; ++n3) {
            int[] nArray = new int[this.widthSegments + 1];
            double d3 = 1.0 * (double)n3 / (double)this.heightSegments;
            for (n2 = 0; n2 <= this.widthSegments; ++n2) {
                double d4 = 1.0 * (double)n2 / (double)this.widthSegments;
                double d5 = -this.radius * Math.cos(this.phiStart + d4 * this.phiLength) * Math.sin(this.thetaStart + d3 * this.thetaLength);
                double d6 = this.radius * Math.cos(this.thetaStart + d3 * this.thetaLength);
                double d7 = this.radius * Math.sin(this.phiStart + d4 * this.phiLength) * Math.sin(this.thetaStart + d3 * this.thetaLength);
                vector4Array[n5] = new Vector4(d5, d6, d7, 1.0);
                vector4Array2[n5] = new Vector4(new Vector3(d5, d6, d7).normalize());
                vector4Array3[n5] = new Vector4(d4, 1.0 - d3, 0.0, 0.0);
                nArray[n2] = n5++;
            }
            nArrayArray[n3] = nArray;
        }
        for (n3 = 0; n3 < this.heightSegments; ++n3) {
            for (int i2 = 0; i2 < this.widthSegments; ++i2) {
                boolean bl2;
                int n6 = nArrayArray[n3][i2 + 1];
                int n7 = nArrayArray[n3][i2];
                n2 = nArrayArray[n3 + 1][i2];
                int n8 = nArrayArray[n3 + 1][i2 + 1];
                boolean bl3 = n3 != 0 || this.thetaStart > 0.0;
                boolean bl4 = bl2 = n3 != this.heightSegments - 1 || d2 < Math.PI;
                if (bl3 && bl2) {
                    mesh.createPolygon(n6, n7, n2, n8);
                    continue;
                }
                if (bl3) {
                    mesh.createPolygon(n6, n7, n8);
                    continue;
                }
                if (!bl2) continue;
                mesh.createPolygon(n7, n2, n8);
            }
        }
        Primitive.setup(mesh, vector4Array, vector4Array2, vector4Array3);
        return mesh;
    }

    public int hashCode() {
        return new dX().a(this.radius).a(this.widthSegments).a(this.heightSegments).a(this.phiStart).a(this.phiLength).a(this.thetaStart).a(this.thetaLength).hashCode();
    }
}

